
<title><?php echo e(trans('home.edit_testimonials')); ?></title>
<?php $__env->startSection('content'); ?>

<div class="container-fluid">
    <!-- Page Header -->
    <div class="page-header">
        <div>
            <h2 class="main-content-title tx-24 mg-b-5"><?php echo e(trans('home.testimonials')); ?></h2>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?php echo e(url('/admin')); ?>"><?php echo e(trans('home.admin')); ?></a></li>
                <li class="breadcrumb-item"><a href="<?php echo e(url('admin/testimonials')); ?>"><?php echo e(trans('home.testimonials')); ?></a></li>
                <li class="breadcrumb-item active" aria-current="page"><?php echo e(trans('home.edit_testimonial')); ?></li>
            </ol>
        </div>
    </div>
    <!-- End Page Header -->
    
    <?php echo Form::open(['method'=>'PATCH','url' => 'admin/testimonials/'.$testimonial->id, 'data-toggle'=>'validator', 'files'=>'true']); ?>

        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
    
                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1"><?php echo e(trans('home.edit_testimonial')); ?></h6>
                            <hr>
                        </div>
                        <div class="row">

                            <div class="form-group col-md-6">
                                <label class=""><?php echo e(trans('home.name')); ?></label>
                                <input class="form-control" name="name" type="text" placeholder="<?php echo e(trans('home.name')); ?>" value="<?php echo e(old('name',$testimonial->name)); ?>">
                            </div>
                            
                            <div class="form-group col-md-6">
                                <label for="helperText"><?php echo e(trans('home.lang')); ?></label>
                                <select class="form-control" data-trigger name="lang" required>
                                    <option <?php if(old('lang',$testimonial->lang) == 'en'): echo 'selected'; endif; ?> value="en"><?php echo e(trans('home.english')); ?></option>
                                    <option <?php if(old('lang',$testimonial->lang) == 'ar'): echo 'selected'; endif; ?> value="ar"><?php echo e(trans('home.arabic')); ?></option>
                                </select>
                            </div>
                            
                            <div class="form-group col-md-6">
                                <label class=""><?php echo e(trans('home.rate')); ?></label>
                                <input class="form-control" name="rate" type="text" placeholder="<?php echo e(trans('home.rate')); ?>" value="<?php echo e(old('rate',$testimonial->rate)); ?>">
                            </div>
                            
                            <div class="form-group col-md-6">
                                <label class=""><?php echo e(trans('home.position')); ?></label>
                                <input class="form-control" name="position" type="text" placeholder="<?php echo e(trans('home.position')); ?>" value="<?php echo e(old('postion',$testimonial->position)); ?>">
                            </div>
                            
                            <div class="form-group  col-md-12">
                                <label><?php echo e(trans('home.image')); ?></label>
                                <div class="input-group mb-1">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text"> <?php echo e(trans('home.upload')); ?></span>
                                    </div>
                                    <div class="custom-file">
                                        <input type="file" class="custom-file-input" name="img">
                                        <label class="custom-file-label" for="inputGroupFile01"><?php echo e(trans('home.choose_image')); ?></label>
                                    </div>
                                </div>
                            </div>

                            <?php if($testimonial->img): ?>
                                <div class="form-group  col-md-12">
                                    <img style="border-radius:50%" src="<?php echo e(url('uploads/testimonials/source/'.$testimonial->img)); ?>" width="150">   
                                </div>
                            <?php endif; ?>

                            <div class="form-group col-md-12">
                                <label class=""><?php echo e(trans('home.text')); ?></label>
                                <textarea class="form-control" name="text"  placeholder="<?php echo e(trans('home.text')); ?>"><?php echo old('text',$testimonial->text); ?></textarea>
                            </div>
                            
                            <div class="form-group col-md-12">
                                <p class="mt-4 mb-2"><?php echo e(trans('home.publish')); ?></p>
                                <label class="custom-switch">
                                    <input type="checkbox" name="status" value="1" class="custom-switch-input" <?php echo e(($testimonial->status == 1)? 'checked':''); ?>/>
                                    <span class="custom-switch-indicator"></span>
                                    <span class="custom-switch-description"><?php echo e(trans('home.click_to_publish')); ?></span>
                                </label>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
        
        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div class="row">
                            <div class="form-group col-md-12">
                                <button type="submit" class="btn btn-success"><i class="icon-note"></i> <?php echo e(trans('home.save')); ?> </button>
                                <a href="<?php echo e(url('/admin/testimonials')); ?>"><button type="button" class="btn btn-danger mr-1"><i class="icon-trash"></i> <?php echo e(trans('home.cancel')); ?></button></a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
        
    <?php echo Form::close(); ?>

</div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/academybadertech/public_html/resources/views/admin/testimonials/editTestimonial.blade.php ENDPATH**/ ?>