<?php $__env->startSection('meta'); ?>
    <title><?php echo e(trans('home.surveys')); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="container-fluid">

        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5"><?php echo e(trans('home.surveys')); ?></h2>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?php echo e(url('/admin')); ?>"><?php echo e(trans('home.admin')); ?></a></li>
                    <li class="breadcrumb-item active" aria-current="page"><?php echo e(trans('home.surveys')); ?></li>
                </ol>
            </div>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('surveys_opertions')): ?>
                <div class="btn btn-list">
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('surveys_add_button')): ?>
                        <a href="<?php echo e(url('admin/surveys/create')); ?>"><button class="btn ripple btn-primary"><i class="fas fa-plus-circle"></i> <?php echo e(trans('home.add')); ?></button></a>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('surveys_delete_buttons')): ?>
                        <a class="mr-2" id="btn_active"><button class="btn ripple btn-dark"><i class="fas fa-eye"></i> <?php echo e(trans('home.publish/unpublish')); ?></button></a>
                        <a class="mr-2" id="btn_delete" ><button class="btn ripple btn-danger"><i class="fas fa-trash"></i> <?php echo e(trans('home.delete')); ?></button></a>
                    <?php endif; ?>
                </div>
            <?php endif; ?>
        </div>
        <!-- End Page Header -->

        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1"><?php echo e(trans('home.surveys')); ?></h6>
                            <p class="text-muted card-sub-title"><?php echo e(trans('home.table_contain_all_data_shortly_you_can_view_more_details')); ?></p>
                        </div>

                        <div class="table-responsive">
                        <table class="table" id="exportexample">
                            <thead>
                                <tr>
                                    <th><input type="checkbox" id="checkAll"/></th>
                                    <th><?php echo e(trans('home.id')); ?></th>
                                    <th><?php echo e(trans('home.name_en')); ?></th>
                                    <th><?php echo e(trans('home.name_ar')); ?></th>
                                    <th><?php echo e(trans('home.type')); ?></th>
                                    <th><?php echo e(trans('home.status')); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $surveys; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $survey): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr id="<?php echo e($survey->id); ?>">
                                        <td> <input type="checkbox" name="checkbox"  class="tableChecked" value="<?php echo e($survey->id); ?>" /> </td>
                                        <td><a href="<?php echo e(route('surveys.edit', $survey->id)); ?>"><?php echo e($survey->id); ?></a></td>
                                        <td><a href="<?php echo e(route('surveys.edit', $survey->id)); ?>"><?php echo e($survey->name_en); ?></a></td>
                                        <td><a href="<?php echo e(route('surveys.edit', $survey->id)); ?>"><?php echo e($survey->name_ar); ?></a></td>
                                        <td><a href="<?php echo e(route('surveys.edit', $survey->id)); ?>"><?php echo e($survey->survay_type); ?></a></td>
                                        <td>
                                            <a href="<?php echo e(route('surveys.edit', $survey->id)); ?>">
                                                <?php if($survey->status == 1): ?>
                                                    <span class="badge badge-success"><?php echo e(trans('home.yes')); ?></span>
                                                <?php else: ?>
                                                    <span class="badge badge-danger"><?php echo e(trans('home.no')); ?></span>
                                                <?php endif; ?>
                                            </a>
                                        </td>  
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            </tbody>
                        </table>
					</div>
                    </div>

                </div>
            </div>
        </div>
        <!-- End Row -->
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/academybadertech/public_html/resources/views/admin/surveys/surveys.blade.php ENDPATH**/ ?>