
<title><?php echo e(trans('home.webinars')); ?></title>
<?php $__env->startSection('content'); ?>
    <div class="container-fluid">

        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5"><?php echo e(trans('home.webinars')); ?></h2>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?php echo e(route('admin')); ?>"><?php echo e(trans('home.admin')); ?></a></li>
                    <li class="breadcrumb-item active" aria-current="page"><?php echo e(trans('home.webinars')); ?></li>
                </ol>
            </div>

            <div class="btn btn-list">

                <a href="<?php echo e(route('webinars.create')); ?>"><button class="btn ripple btn-primary"><i
                            class="fas fa-plus-circle"></i> <?php echo e(trans('home.add')); ?></button></a>
                <a class="mr-2" id="btn_active"><button class="btn ripple btn-dark"><i class="fas fa-eye"></i>
                        <?php echo e(trans('home.publish/unpublish')); ?></button></a>
                <a class="mr-2" id="btn_delete"><button class="btn ripple btn-danger"><i class="fas fa-trash"></i>
                        <?php echo e(trans('home.delete')); ?></button></a>
            </div>
        </div>

        <?php if(session()->has('success')): ?>
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <?php echo e(session()->pull('success')); ?> <button type="button" class="btn-close" data-bs-dismiss="alert"
                    aria-label="Close"></button>
            </div>
        <?php endif; ?>


        <!-- Row-->
        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card-body">
                    <table class="table text-center" id="exportexample">
                        <thead>
                            <tr>
                                <th><input type="checkbox" name="checkbox" class="tableChecked form-check-input"
                                        id="checkAll" /></th>
                                <th><?php echo e(trans('home.id')); ?></th>
                                <th><?php echo e(trans('home.name')); ?></th>
                                <th><?php echo e(trans('home.start_date')); ?></th>
                                <th><?php echo e(trans('home.end_date')); ?></th>
                                <th><?php echo e(trans('home.image')); ?></th>
                                <th><?php echo e(__('home.publish/unpublish')); ?></th>
                                <th><?php echo e(__('home.edit')); ?></th>
                                <th><?php echo e(__('home.delete')); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $webinars; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $webinar): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr id="<?php echo e($webinar->id); ?>">
                                    <td> <input type="checkbox" name="checkbox" class="tableChecked form-check-input"
                                            value="<?php echo e($webinar->id); ?>" /> </td>
                                    <td><a href="<?php echo e(route('webinars.edit', $webinar->id)); ?>"><?php echo e($webinar->id); ?></a> </td>
                                    <td><?php echo e($webinar->{'name_' . $lang}); ?> </td>
                                    <td><?php echo e($webinar->formatted_start_date); ?> </td>
                                    <td><?php echo e($webinar->formatted_end_date); ?> </td>

                                    <td>
                                        <?php if($webinar->image): ?>
                                            <img src="<?php echo e(url('uploads/webinars/source/' . $webinar->image)); ?>"
                                                width="150">
                                        <?php else: ?>
                                            <img src="<?php echo e(url('resources/assets/back/images/noimage.jpg')); ?>"  width="100">
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <input class="btn_active" data-id="<?php echo e($webinar->id); ?>" type="checkbox"
                                            id="switch-<?php echo e($webinar->id); ?>" switch="success"
                                            <?php echo e($webinar->status == 1 ? 'checked' : ''); ?> />
                                        <label for="switch-<?php echo e($webinar->id); ?>" data-on-label="<?php echo e(trans('home.yes')); ?>"
                                            data-off-label="<?php echo e(trans('home.no')); ?>"></label>
                                    </td>
                                    <td>
                                        <a type="button" class="btn btn-info waves-effect waves-light "
                                            href="<?php echo e(route('webinars.edit', $webinar->id)); ?>"><?php echo e(__('home.edit')); ?></a>
                                    </td>
                                    <td>
                                        <a type="button" class="btn btn-danger waves-effect waves-light btn_delete"
                                            data-id="<?php echo e($webinar->id); ?>"><?php echo e(__('home.delete')); ?></a>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        <!-- End Row -->
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/academybadertech/public_html/resources/views/admin/webinars/webinars.blade.php ENDPATH**/ ?>