
<?php $__env->startSection('title'); ?>
    <title><?php echo e(__('home.wishlist')); ?></title>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('sub-title', __('home.wishlist') ); ?>

<?php $__env->startSection('content'); ?>

    <div class="col-lg-9">
        <!-- Start Enrole Course  -->
        <div class="rbt-dashboard-content bg-color-white rbt-shadow-box">
            <div class="content">
                <div class="section-title">
                    <h4 class="rbt-title-style-3"><?php echo e(__('home.wishlist')); ?></h4>
                </div>
                <div class="row g-5">
                    <!-- Start Single Course  -->
                    <?php $__currentLoopData = $wishlist; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $training): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-lg-4 col-md-6 col-12">
                        <div class="rbt-card variation-01 rbt-hover">
                            <div class="rbt-card-img">
                                <a    href="<?php echo e(LaravelLocalization::localizeUrl('course/' . $training->course->{'link_'.$lang})); ?>" class="thumbnail">
                                                    <img src="<?php echo e(isset($training->course->image) ? Helper::uploadedImagesPath('courses/source', $training->course->image) : Helper::imageFilesPath('noimage.png')); ?>" alt="course">
                                </a>
                            </div>
                            <div class="rbt-card-body">
                                <h4 class="rbt-card-title"><a href="<?php echo e(LaravelLocalization::localizeUrl('course/' . $training->course->{'link_'.$lang} )); ?>">
                                        <?php echo e($training->course->{'name_' . $lang}); ?></a>
                                </h4>
                                <ul class="rbt-meta">
                                    <li><i class="feather-book"></i><?php echo e($training->course->category->{'name_' . $lang} ?? ''); ?></li>
                                </ul>
                                                <div class="rbt-card-bottom">
                                                    <div class="rbt-price">
                                                        <?php if($training->course->discount): ?>
                                                        <span class="off-price">
                                                        <?php echo e($training->course->last_price() . ' ' . __('home.SAR')); ?>  
                                                    </span>
                                                        <span class="current-price">
                                                        <?php echo e($training->course->price . ' ' . __('home.SAR')); ?> 
                                                    </span>
                                                        <?php if(isset($training->course->discount->end_date)): ?>
                                                        <div class="clock-area">
                                                            <i class="ms-1 fa-light fa-clock"></i>
                                                            <?php
                                                            $end_date = \Carbon\Carbon::parse($training->course->discount->end_date);
                                                            $daysLeft = \Carbon\Carbon::now()->diffInDays($end_date);
                                                            ?>
                                                            <span class="text-danger"><?php echo e($daysLeft); ?> <?php echo app('translator')->get('home.Day left at this price!'); ?></span>
                                                        </div>
                                                        <?php endif; ?>
                                                        <?php else: ?>
                                                        <div class="current-price">
                                                            <?php echo e($training->course->last_price() . ' ' . __('home.SAR')); ?>

                                                        </div>
                                                        <?php endif; ?>
                                                    </div>
                                                    <a class="rbt-btn-link" href="<?php echo e(LaravelLocalization::localizeUrl('course/' . $training->course->{'link_'.$lang})); ?>"><?php echo e(__('home.Learn_More')); ?><i class="feather-arrow-right"></i></a>
                                                </div>

                            </div>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <!-- End Single Course  -->
                </div>
            </div>
        </div>
        <!-- End Enrole Course  -->
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('website.student.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/academybadertech/public_html/resources/views/website/student/wishlist.blade.php ENDPATH**/ ?>