<?php if(count($rondomCourses) > 0): ?>
<!-- Start Course Area -->
<div class="rbt-course-area bg-color-extra2 rbt-section-gap">
    <div class="container">
        <div class="row mb--55 g-5 align-items-end">
            <div class="col-lg-6 col-md-6 col-12">
                <div class="section-title text-start">
                    
                    <?php if($lang == 'en'): ?>
                     <h2 class="title"><?php echo e(trans('home.most_popular')); ?><span class="color-primary"><?php echo e(trans('home.courses')); ?></span></h2>
                    <?php elseif($lang =='ar'): ?>
                      <h2 class="title"><?php echo e(trans('home.courses')); ?> <span class="color-primary"><?php echo e(trans('home.popular')); ?></span></h2>
                    <?php endif; ?>
                </div>
            </div>
            <div class="col-lg-6 col-md-6 col-12">
                <div class="load-more-btn text-start text-md-end">
                    <a class="rbt-btn rbt-switch-btn bg-primary-opacity" href="<?php echo e(LaravelLocalization::localizeUrl('/courses')); ?>">
                        <span data-text="<?php echo e(trans('home.show_all')); ?>"><?php echo e(trans('home.show_all')); ?></span>
                    </a>
                </div>
            </div>
        </div>
        <!-- Start Card Area -->
        <div class="row g-5">
            <!-- Start Single Course  -->
            <div class="col-12" data-sal-delay="150" data-sal="slide-up" data-sal-duration="800">
                <div
                    class="swiper category-activation-three rbt-arrow-between icon-bg-gray gutter-swiper-30 ptb--20">
                    <div class="swiper-wrapper">
                        <?php $__currentLoopData = $rondomCourses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rondomCourse): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <!-- Start Single Category  -->
                        <div class="swiper-slide">
                            <div class="single-slide">
                                <div class="rbt-card variation-01 rbt-hover">
                                    <div class="rbt-card-img">
                                        <a    href="<?php echo e($rondomCourse->publish ? LaravelLocalization::localizeUrl('course/' . $rondomCourse->{'link_'.$lang}) : '#'); ?>" class="thumbnail">
                                            <img src="<?php echo e(isset($rondomCourse->image) ? Helper::uploadedImagesPath('courses/source', $rondomCourse->image) : Helper::imageFilesPath('noimage.png')); ?>" alt="course">
                                        </a>
                                    </div>
                                    <div class="rbt-card-body">
                                        <div class="rbt-card-top">
                                            <div class="rbt-review">
                                                
                                            </div>
                                           <div class="rbt-bookmark-btn">
                                                <form action="<?php echo e(route('addWishlist')); ?>" method="POST">
                                                    <?php echo csrf_field(); ?>
                                                    <input type="hidden" name="course_id" value="<?php echo e($rondomCourse->id); ?>">
                                                    <button type="submit" class="rbt-round-btn" title="Bookmark">
                                                        <i class="feather-bookmark"></i>
                                                    </button>
                                                </form>
                                            </div>
                                        </div>

                                        <h4 class="rbt-card-title">
                                            <a href="<?php echo e($rondomCourse->publish ? LaravelLocalization::localizeUrl('course/' . $rondomCourse->{'link_'.$lang}) : '#'); ?>">
                                                <h5 class="title"><?php echo e($rondomCourse->{'name_' . $lang}); ?></h5>
                                            </a>
                                        </h4>


                                                <ul class="rbt-meta">
                                                    <li><i class="feather-book"></i>
                                                        <?php echo e($rondomCourse->category->{'name_' . $lang} ?? ''); ?>

                                                    </li>
                                                    <li>
                                                        <p class=' mb-3 rounded d-inline-block p-2 border 'style=' background: #f379241f;  color: #f37924;   border: 1px solid #f379245c !important; font-size: 13px;  padding: 3px 6px !important;'>
                                                           <i class="feather-user-plus"></i>
                                                            <?php echo e($rondomCourse->type->{'name_'.$lang}); ?> 
                                                        </p>
                                                         
                                                    </li>
                                                </ul>
                                                
                                                <div class="leasson-students">
                                                    <div class="lesson">
                                                        <i class="feather-clock"></i>
                                                        <span><?php echo e(intval($rondomCourse->duration).' '.__('home.hours')); ?></span>
                                                    </div>
                                                    <div class="lesson">
                                                        <i class="feather-calendar"></i>
                                                        <span>  <?php echo e(intval($rondomCourse->overall_days).' '.__('home.days')); ?></span>
                                                    </div>
                                                </div>
                                        <div class="rbt-card-bottom">
                                            <div class="rbt-price">
                                            <?php if($rondomCourse->publish): ?>
                                                <?php if($rondomCourse->discount): ?>
                                                <span class="off-price">
                                                <?php echo e($rondomCourse->last_price() . ' ' . __('home.SAR')); ?>  
                                            </span>
                                                <span class="current-price">
                                                <?php echo e($rondomCourse->price . ' ' . __('home.SAR')); ?> 
                                            </span>
                                                <?php if(isset($rondomCourse->discount->end_date)): ?>
                                                <div class="clock-area">
                                                    <i class="ms-1 fa-light fa-clock"></i>
                                                    <?php
                                                    $end_date = \Carbon\Carbon::parse($rondomCourse->discount->end_date);
                                                    $daysLeft = \Carbon\Carbon::now()->diffInDays($end_date);
                                                    ?>
                                                    <span class="text-danger"><?php echo e($daysLeft); ?> <?php echo app('translator')->get('home.Day left at this price!'); ?></span>
                                                </div>
                                                <?php endif; ?>
                                                <?php else: ?>
                                                <div class="current-price">
                                                    <?php echo e($rondomCourse->last_price() . ' ' . __('home.SAR')); ?>

                                                </div>
                                                <?php endif; ?>
                                            <?php else: ?>
                                                <span class="current-price">
                                                <?php echo e(__('home.soon')); ?>  
                                            </span>
                                            <?php endif; ?>
                                            </div>
                                            <a class="rbt-btn-link" href="<?php echo e($rondomCourse->publish ? LaravelLocalization::localizeUrl('course/' . $rondomCourse->{'link_'.$lang}) : '#'); ?>"><?php echo e(__('home.Learn_More')); ?><i class="feather-arrow-right"></i></a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                    <div class="rbt-swiper-arrow rbt-arrow-left">
                        <div class="custom-overfolow">
                            <i class="rbt-icon feather-arrow-left"></i>
                            <i class="rbt-icon-top feather-arrow-left"></i>
                        </div>
                    </div>

                    <div class="rbt-swiper-arrow rbt-arrow-right">
                        <div class="custom-overfolow">
                            <i class="rbt-icon feather-arrow-right"></i>
                            <i class="rbt-icon-top feather-arrow-right"></i>
                        </div>
                    </div>
                    <div class="rbt-swiper-pagination text-center"></div>
                </div>
            </div>
            <!-- End Single Card  -->
        </div>
        <!-- End Card Area -->
    </div>
</div>
<!-- End Course Area -->
<?php endif; ?><?php /**PATH /home/academybadertech/public_html/resources/views/website/home-partials/courses.blade.php ENDPATH**/ ?>