<title><?php echo e(trans('home.aboutStrucs')); ?></title>
<?php $__env->startSection('content'); ?>
    <div class="container-fluid">

        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5"><?php echo e(trans('home.aboutStrucs')); ?></h2>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?php echo e(url('/admin')); ?>"><?php echo e(trans('home.admin')); ?></a></li>
                    <li class="breadcrumb-item active" aria-current="page"><?php echo e(trans('home.aboutStrucs')); ?></li>
                </ol>
            </div>

            <div class="btn btn-list">
                <a href="<?php echo e(url('admin/aboutStrucs/create')); ?>"><button class="btn ripple btn-primary"><i class="fas fa-plus-circle"></i> <?php echo e(trans('home.add')); ?></button></a>
                <a id="btn_active"><button class="btn ripple btn-dark"><i class="fas fa-eye"></i> <?php echo e(trans('home.publish/unpublish')); ?></button></a>
                <a id="btn_delete" ><button class="btn ripple btn-danger"><i class="fas fa-trash"></i> <?php echo e(trans('home.delete')); ?></button></a>
            </div>
        </div>
        <!-- End Page Header -->

        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1"><?php echo e(trans('home.aboutStrucs')); ?></h6>
                            <p class="text-muted card-sub-title"><?php echo e(trans('home.table_contain_all_data_shortly_you_can_view_more_details')); ?></p>
                        </div>

                        <div class="table-responsive">
                        <table class="table" id="exportexample">
                            <thead>
                                <tr>
                                    <th><input type="checkbox" id="checkAll" class="tableChecked" name="checkbox" /></th>
                                    <th><?php echo e(trans('home.id')); ?></th>
                                    <th><?php echo e(trans('home.title_en')); ?></th>
                                    <th><?php echo e(trans('home.title_ar')); ?></th>
                                    <th><?php echo e(trans('home.image')); ?></th>
                                    <th><?php echo e(trans('home.status')); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $aboutStrucs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $aboutStruc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr id="<?php echo e($aboutStruc->id); ?>">
                                        <td> <input type="checkbox" name="checkbox"  class="tableChecked" value="<?php echo e($aboutStruc->id); ?>" /></td>
                                        <td><a href="<?php echo e(route('aboutStrucs.edit', $aboutStruc->id)); ?>"><?php echo e($aboutStruc->id); ?></a></td>
                                        <td><a href="<?php echo e(route('aboutStrucs.edit', $aboutStruc->id)); ?>"><?php echo e($aboutStruc->title_en); ?></a></td>
                                        <td><a href="<?php echo e(route('aboutStrucs.edit', $aboutStruc->id)); ?>"><?php echo e($aboutStruc->title_ar); ?></a></td>
                                        <td>
                                            <a href="<?php echo e(route('aboutStrucs.edit', $aboutStruc->id)); ?>">
                                                <?php if($aboutStruc->image): ?>
                                                    <img style="border-radius:50%" src="<?php echo e(url('/uploads/aboutStrucs')); ?>/<?php echo e($aboutStruc->image); ?>" width="70">
                                                <?php else: ?>
                                                    <img style="border-radius:50%" src="<?php echo e(url('resources/assets/back/img/noimage.png')); ?>" width="70">
                                                <?php endif; ?>
                                            </a>
                                        </td>
                                        
                                        <td>
                                            <a href="<?php echo e(route('aboutStrucs.edit', $aboutStruc->id)); ?>">
                                                <?php if($aboutStruc->status == 1): ?>
                                                    <span class="badge badge-success"><?php echo e(trans('home.yes')); ?></span>
                                                <?php else: ?>
                                                    <span class="badge badge-danger"><?php echo e(trans('home.no')); ?></span>
                                                <?php endif; ?>
                                            </a>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
					</div>
                </div>

                </div>
            </div>
        </div>
        <!-- End Row -->
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/academybadertech/public_html/resources/views/admin/aboutStrucs/aboutStrucs.blade.php ENDPATH**/ ?>