
<?php $__env->startSection('meta'); ?>
    <title><?php echo e(trans('home.students')); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="container-fluid">

        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5"><?php echo e(trans('home.students')); ?></h2>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?php echo e(route('admin')); ?>"><?php echo e(trans('home.admin')); ?></a></li>
                    <li class="breadcrumb-item active" aria-current="page"><?php echo e(trans('home.students')); ?></li>
                </ol>
            </div>

            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('students_operations')): ?>
                <div class="btn btn-list">
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('students_add_buttons')): ?>
                        <a href="<?php echo e(route('students.create')); ?>"><button class="btn m-2 ripple btn-primary"><i
                                    class="fas fa-plus-circle"></i> <?php echo e(trans('home.add')); ?></button></a>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('students_delete_buttons')): ?>
                    <a id="btn_active"><button class="btn m-2 ripple btn-dark"><i class="fas fa-eye"></i>
                            <?php echo e(trans('home.publish/unpublish')); ?></button></a>
                    <a id="btn_delete"><button class="btn m-2 ripple btn-danger"><i class="fas fa-trash"></i>
                            <?php echo e(trans('home.delete')); ?></button></a>
                    <?php endif; ?>
                </div>
            <?php endif; ?>
        </div>
        <!-- End Page Header -->

        <?php if(session()->has('success')): ?>
            <div class="alert alert-success">
                <?php echo e(session()->pull('success')); ?>

                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        <?php endif; ?>
       <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden"> 
                    <div class="card-body">
                        
                        <div>
                            <h6 class="card-title mb-1"><?php echo e(trans('home.students')); ?></h6>
                            <p class="text-muted card-sub-title">
                                <?php echo e(trans('home.table_contain_all_data_shortly_you_can_view_more_details')); ?></p>
                        </div>
                        <div class="d-flex justify-content-left m-3">
                            <input style="width:15px; margin-left:5px" type="checkbox" name="checkbox" class="tableChecked" value="Select All" id="checkAll"/>
                            <label style="font-size:20px; padding-top:10px" for="checkAll"><?php echo e(trans('home.select_all')); ?></label>
                        </div>
                      <?php echo $dataTable->table(['class' => 'table dataTable  table-bordered w-100']); ?>


                    </div>
                </div>
            </div>
        </div>
          <!-- End Row -->
        <div class="modal fade bd-example-modal-xl" id="importstudentsmodel" tabindex="-1" role="dialog" aria-labelledby="importstudentsmodelTitle" aria-hidden="true">
          <div class="modal-dialog modal-xl modal-dialog-centered" role="document">
            <div class="modal-content" style="border-radius: 35px;">
              <div class="modal-header row">
                    <img class="col-12 p-2"  src="<?php echo e(url('resources/assets/back/img/students_1.png')); ?>">
                 <img  class="col-12" src="<?php echo e(url('resources/assets/back/img/students_2.png')); ?>">
              </div>
             <form method="post" action="<?php echo e(route('student.import.excel')); ?>" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
              <div class="modal-body ">
                    <div class="m-auto">
                                <div class="row">
                                    
                                    <div class="input-group mb-1 d-flex justify-content-first">
                                        <div class="custom-file m-auto col-6">
                                            <div class="input-group-prepend"> 
                                                <span class="input-group-text"> <?php echo e(trans('home.upload')); ?></span>
                                            </div>
                                            <input type="file" class="custom-file-input" name="excelFile"  accept=".csv,.xlsx">
                                            <label class="custom-file-label"
                                                for="inputGroupFile01"><?php echo e(trans('home.choose_excel_file')); ?></label>
                                        </div>
                                        
                                    </div>
                                        
                                    <?php $__errorArgs = ['excelFile'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="alert alert-danger"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                    </div>
              </div>
              <div class="modal-footer justify-content-center ">
                  <button class="btn ripple btn-primary " type="submit"><i
                                        class="fas fa-plus-circle"></i>
                                        <?php echo e(trans('home.importExcel')); ?></button>
                <button id="closeModalButton" type="button" class="btn btn-secondary " data-bs-dismiss="modal">Close</button>
              </div>
            </form>
            </div>
          
          </div>
        </div>
            

        <!-- Row-->
        <!-- End Row -->
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script src="<?php echo e(Helper::jsFilesPath('bootstrap.min.js')); ?>"></script>
    <script>
        // Select the close button
        var closeModalButton = document.getElementById("closeModalButton");
    
        // Add click event listener to the close button
        closeModalButton.addEventListener("click", function() {
            document.getElementById("importstudentsmodel").classList.remove("show");
            document.querySelector(".modal-backdrop").remove();
            document.getElementById("importstudentsmodel").setAttribute("aria-hidden", "true");
        });
    </script>
    <script>
        $('.msg_check').html('<input type="checkbox" name="checkbox" class="tableChecked" id="checkAll"/>');
    </script>
    <script>
        function viewModel2(id){
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });
                $.ajax({
                    url: '<?php echo e(route('viewtrainings2.show')); ?>',
                    method: 'POST',
                    data: {
                        std_id: id,
                    },
                    success: function (response) {
                        $('#view_trainingModal').empty();
                        $('.main-content').append(response.view);
                        $('#view_trainingModal_'+id).modal('show');
                    }
                });
        }
    </script>
    
    <?php echo $dataTable->scripts(); ?>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/academybadertech/public_html/resources/views/admin/students/index_copy.blade.php ENDPATH**/ ?>