<title><?php echo e(trans('home.clients').' | '.trans('home.crm')); ?></title>
<?php $__env->startSection('content'); ?>
    <div class="container-fluid">

        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5"><?php echo e(trans('home.crm')); ?></h2>
                <h2 class="main-content-title tx-24 mg-b-5"><?php echo e(trans('home.clients')); ?></h2>
            </div>

            <div class="row btn btn-list gap-3 mx-3">
                <a href="<?php echo e(url('admin/crm/add-client/single')); ?>"><button class="btn ripple btn-primary"><i class="fas fa-plus-circle"></i> <?php echo e(trans('home.add_client')); ?></button> </a>
                <a id="btn_delete_crm" ><button class="btn ripple btn-danger"><i class="fas fa-trash"></i> <?php echo e(trans('home.delete')); ?></button></a>
            </div>
        </div>
        <!-- End Page Header -->
        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div class="table-responsive">
                        <table class="table" id="exportexample">
                            <thead>
                                <tr>
                                    <th><input type="checkbox" id="checkAll"/></th>
                                    <th><?php echo e(trans('home.id')); ?></th>
                                    <th class="wd-20p"><?php echo e(trans('home.name')); ?></th>
                                    <th class="wd-25p"><?php echo e(trans('home.phone')); ?></th>
                                    <th class="wd-25p"><?php echo e(trans('home.ssn')); ?></th>
                                    <th class="wd-25p"><?php echo e(trans('home.email')); ?></th>
                                    <th class="wd-15p">البرنامج</th>
                                    <th class="wd-15p"><?php echo e(trans('home.responsible_employee')); ?></th>
                                    <th class="wd-15p"><?php echo e(trans('home.client_status')); ?></th>
                                    <th class="wd-25p"><?php echo e(trans('home.nationality')); ?></th>
                                    <th class="wd-25p"><?php echo e(trans('home.qualification')); ?></th>
                                    <th class="wd-25p"><?php echo e(trans('home.region')); ?></th>
                                    <th class="wd-25p"><?php echo e(trans('home.area')); ?></th>
                                    <th class="wd-15p"><?php echo e(trans('home.come_from')); ?></th>
                                    <th class="wd-15p"><?php echo e(trans('home.payment_status')); ?></th>
                                    <th class="wd-15p"><?php echo e(trans('home.company')); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $clients; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $client): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr id="<?php echo e($client->id); ?>">
                                        <td> <input type="checkbox" name="checkbox"  class="tableChecked" value="<?php echo e($client->id); ?>" /> </td>
                                        <td><a href="<?php echo e(url('admin/crm/clients/'.$client->id)); ?>"> <?php echo e($client->id); ?></a> </td>
                                        <td><a href="<?php echo e(url('admin/crm/clients/'.$client->id)); ?>"> <?php echo e($client->name); ?></a> </td>
                                        <td><a href="<?php echo e(url('admin/crm/clients/'.$client->id)); ?>"> <?php echo e($client->phone); ?></a> </td>
                                        <td><a href="<?php echo e(url('admin/crm/clients/'.$client->id)); ?>"> <?php echo e($client->ssn); ?></a> </td>
                                        <td><a href="<?php echo e(url('admin/crm/clients/'.$client->id)); ?>"> <?php echo e($client->email); ?></a> </td>
                                        <td><a href="<?php echo e(url('admin/crm/clients/'.$client->id)); ?>"> 
                                                    <?php echo $client->companyTraining?->map(function($training) use($lang) {
                                                    return "<span class='badge badge-primary m-1'>" . $training->training->{'name_' . $lang} . "</span>";
                                                })->implode(' '); ?>

                                            </a> 
                                        </td>
                                        <td><a href="<?php echo e(url('admin/crm/clients/'.$client->id)); ?>"> <?php echo e($client->responsible_employee?->user?->name()); ?></a> </td>
                                        <td><a href="<?php echo e(url('admin/crm/clients/'.$client->id)); ?>"> <?php echo e($client->status?->{'name_'.$lang}); ?></a> </td>
                                        <td><a href="<?php echo e(url('admin/crm/clients/'.$client->id)); ?>"> <?php echo e($client->nationality); ?></a> </td>
                                        <td><a href="<?php echo e(url('admin/crm/clients/'.$client->id)); ?>"> <?php echo e($client->qualification); ?></a> </td>
                                        <td><a href="<?php echo e(url('admin/crm/clients/'.$client->id)); ?>"> <?php echo e($client->area?->{'name_'.$lang}); ?></a> </td>
                                        <td><a href="<?php echo e(url('admin/crm/clients/'.$client->id)); ?>"> <?php echo e($client->region?->{'name_'.$lang}); ?></a> </td>
                                        <td><a href="<?php echo e(url('admin/crm/clients/'.$client->id)); ?>"> <?php echo e($client->source?->{'name_'.$lang}); ?> </a> </td>
                                        <td><a href="<?php echo e(url('admin/crm/clients/'.$client->id)); ?>"> 
                                        <?php if($client->training): ?>
                                            <?php if($client->training->payment_status=="paid"): ?>
                                                <span class='badge badge-success m-1'>
                                                    <?php echo e(__('home.paid')); ?>

                                                </span>
                                            <?php else: ?>
                                                <span class='badge badge-danger m-1'>
                                                    <?php echo e(__('home.un_paid')); ?>

                                                </span>
                                            <?php endif; ?>
                                        <?php endif; ?>
                                        </a> </td>
                                        <td><a href="<?php echo e(url('admin/crm/client/'.$client->id)); ?>"> <?php echo e($client->company?$client->company->name: __('home.no_company')); ?></a> </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
					</div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
<script>
     $(document).ready(function(){
            $('#btn_delete_crm').click(function(){
                var id = [];
                <?php
                $last_word = Request::segment(3);
                // return $last_word;
                Session::put('route', $last_word);
                ?>
                $('.tableChecked:checked').each(function(i){
                    id[i] = $(this).val();
                });
                if(id.length === 0) //tell you if the array is empty
                {
                    alert("Please Select atleast one checkbox");
                }
                else
                {
                    $.confirm({
                        title: '<?php echo e(__('home.Are you sure you want to delete that ?')); ?>',
                        content:'',
                        buttons: {
                            confirm: {
                                text: '<?php echo e(__('home.delete')); ?>',
                                btnClass: 'btn-red any-other-class',
                                keys: ['enter', 'shift'],
                                action: function(){
                                     $.ajaxSetup({
                                        headers: {
                                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                                        }
                                    });
                    
                                    $.ajax({
                                        url: "<?php echo e(url('admin/crm/clients/delete/')); ?>" +'/'+ id,
                                        type: 'POST',
                                        data: {id: id},
                                        success: function () {
                                            for (var i = 0; i < id.length; i++) {
                                                $('tr#' + id[i]).css('background-color', '#ccc').fadeOut('slow');
                                                $('input:checkbox[value="' + id[i] + '"]').removeClass('tableChecked').removeAttr('checked');
                                            }
                                        }
                                    }); 
                                }
                            },
                            cancel: {
                                text: '<?php echo e(__('home.cancel')); ?>',
                                action: function(){
                                    close();
                                }
                            }
                        }
                    });
                }
            });
        });
        
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/academybadertech/public_html/resources/views/admin/crm/client/clients.blade.php ENDPATH**/ ?>