
<title><?php echo e(trans('home.companies_requests')); ?></title>
<?php $__env->startSection('content'); ?>
    <div class="container-fluid">

        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5"><?php echo e(trans('home.companies_requests')); ?></h2>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?php echo e(route('admin')); ?>"><?php echo e(trans('home.admin')); ?></a></li>
                    <li class="breadcrumb-item active" aria-current="page"><?php echo e(trans('home.companies_requests')); ?></li>
                </ol>
            </div>

            
        </div>
        <!-- End Page Header -->

        <?php if(session()->has('success')): ?>
            <div class="alert alert-success">
                <?php echo e(session()->pull('success')); ?>

                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        <?php endif; ?>
        
        
        
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1"><?php echo e(trans('home.companies_requests')); ?></h6>
                            <br>
                        </div>
                        
                            <div class="row d-flex justify-content-start">
        						<div class="col-sm-6 col-md-6 col-xl-3">
        							<div class="card custom-card">
        								<div class="card-body text-center">
        									<div class="icon-service bg-success-transparent rounded-circle text-success">
        									    <i class="far fa-registered"></i>
        									</div>
        									<p class="mb-1 text-muted"><?php echo e(trans('home.registered_count')); ?></p>
        									<h3 class="mb-0"><?php echo e($registered_count); ?></h3>
        								</div>
        							</div>
        						</div>
					        </div>
                        </div>
                    </div>
                </div>
            </div>
        
        

        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1"><?php echo e(trans('home.companies_requests')); ?></h6>
                            <p class="text-muted card-sub-title">
                                <?php echo e(trans('home.table_contain_all_data_shortly_you_can_view_more_details')); ?></p>
                        </div>
                        <div class="table-responsive">
                            
                            <table class="table" id="exportexample">
                                <thead>
                                    <tr>
                                        <!--<th><input type="checkbox" name="checkbox" class="tableChecked" id="checkAll"/></th>-->
                                        <th><?php echo e(trans('home.id')); ?></th>
                                        <th class="wd-20p" ><?php echo e(trans('home.name')); ?></th>
                                        <th class="wd-20p" ><?php echo e(trans('home.responsible_name')); ?></th>
                                        <th class="wd-10p"><?php echo e(trans('home.phone')); ?></th>
                                        <th class="wd-20p"><?php echo e(trans('home.email')); ?></th>
                                        <th class="wd-10p"><?php echo e(trans('home.company_activity')); ?></th>
                                        <th class="wd-100p"><?php echo e(trans('home.message')); ?></th>
                                        <th class="wd-10p"><?php echo e(trans('home.created_at')); ?></th>
                                        
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $companies_requests; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $companies_request): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr id="<?php echo e($companies_request->id); ?>">
                                            <!--<td> <input type="checkbox" name="checkbox" class="tableChecked" value="<?php echo e($companies_request->id); ?>" /> </td>-->
                                            <td><a href="javascript::void(0)"><?php echo e($companies_request->id); ?></a>  </td>
                                            <td ><a href="javascript::void(0)"><?php echo e($companies_request->name); ?></a>  </td>
                                            <td ><a href="javascript::void(0)"><?php echo e($companies_request->responsible_name); ?></a>  </td>
                                            <td><a href="javascript::void(0)"><?php echo e($companies_request->phone); ?></a>  </td>
                                            <td><a href="javascript::void(0)"><?php echo e($companies_request->email); ?></a>  </td>
                                            <td><a href="javascript::void(0)"><?php echo e($companies_request->activity); ?></a>  </td>
                                            <td><a href="javascript::void(0)"><?php echo e($companies_request->message); ?></a>  </td>
                                            <td><a href="javascript::void(0)"><?php echo e($companies_request->created_at); ?></a>  </td>
                                            
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>    
                            </table>
                           
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
<script>
    $(document).ready(function(){
        $('#btn_active_marketing_program').click(function(){
            var id = [];
            $('.tableChecked:checked').each(function(i){
                id[i] = $(this).val();
            });
            
            if(id.length === 0) //tell you if the array is empty
            {
                alert("Please Select at least one checkbox");
            }
            else
            {
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });
                $.ajax({
                    url:"<?php echo url('admin/marketing_program_requests_change_status')?>", 
                    method:'POST',
                    data:{id:id},
                    success:function(data)
                    {
                        // console.log(data);
                        location.reload();
                    }
                });
            }
        });
    });
</script>
    

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/academybadertech/public_html/resources/views/admin/partners/companies_requests.blade.php ENDPATH**/ ?>