
<?php $__env->startSection('meta'); ?>
    <title><?php echo e(trans('home.edit_lesson')); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

<div class="container-fluid">
    <!-- Page Header -->
    <div class="page-header">
        <div>
            <h2 class="main-content-title tx-24 mg-b-5"><?php echo e(trans('home.lessons')); ?></h2>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?php echo e(route('admin')); ?>"><?php echo e(trans('home.admin')); ?></a></li>
                <li class="breadcrumb-item"><a href="<?php echo e(route('lessons.index')); ?>"><?php echo e(trans('home.lessons')); ?></a></li>
                <li class="breadcrumb-item active" aria-current="page"><?php echo e(trans('home.edit_lesson')); ?></li>
            </ol>
        </div>
    </div>
        <?php if(session()->has('success')): ?>
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <?php echo e(session()->pull('success')); ?> <button type="button" class="btn-close" data-bs-dismiss="alert"
                    aria-label="Close"></button>
            </div>
        <?php endif; ?>

        <!-- Row-->
        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header">
                        <div class="d-flex justify-content-between align-items-center">
                            <h4 class="card-title"><?php echo e(trans('home.edit')); ?></h4>
                            <a data-bs-toggle="modal" data-bs-target="#attachments" href="javascript:void(0)"
                                class="btn btn-info mr-1 px-5">
                                <i class="dripicons-bookmarks"></i>
                                <?php echo e(trans('home.attachments')); ?></a>
                        </div>
                    </div>
                    <div class="card-body p-4">
                        <div class="row">
                            <div class="col-lg-12">
                                <?php echo Form::open([
                                    'method' => 'PATCH',
                                    'url' => 'admin/lessons/' . $lesson->id,
                                    'data-toggle' => 'validator',
                                    'files' => 'true',
                                ]); ?>



                                    <div class="row">

                                        <div class="col-md-3 mb-3">
                                            <label for="name_en"><?php echo e(trans('home.name_en')); ?></label>
                                            <input type="text" class="form-control"
                                                placeholder="<?php echo e(trans('home.name_en')); ?>" value="<?php echo e($lesson->name_en); ?>"
                                                name="name_en" required>
                                        </div>
                                        <div class="col-md-3 mb-3">
                                            <label for="name_ar"><?php echo e(trans('home.name_ar')); ?></label>
                                            <input type="text" class="form-control"
                                                placeholder="<?php echo e(trans('home.name_ar')); ?>" value="<?php echo e($lesson->name_ar); ?>"
                                                name="name_ar" required>
                                        </div>

                                        <div class="col-md-2 mb-3">
                                            <label for="course"><?php echo e(trans('home.course')); ?></label>
                                            <input type="text" class="form-control" disabled
                                                placeholder="<?php echo e(trans('home.course')); ?>"
                                                value="<?php echo e($lesson->course->{'name_' . $lang}); ?>">
                                        </div>

                                        
                                        <div class="col-md-2 mb-3">
                                            <label for="order"><?php echo e(trans('home.order')); ?></label>
                                            <input type="number" class="form-control" 
                                                value="<?php echo e($lesson->order); ?>"
                                                placeholder="<?php echo e(trans('home.order')); ?>" name="order">
                                        </div>


                                        <div class="col-md-3 mb-3">
                                            <label for="duration"><?php echo e(trans('home.duration')); ?></label>
                                            <input type="text" class="form-control"
                                                placeholder="<?php echo e(trans('home.duration')); ?>" name="duration"
                                                value="<?php echo e($lesson->duration); ?>" required>
                                        </div>

                                        <div class="col-md-3 mb-3">
                                            <label for="chapter_id"><?php echo e(trans('home.chapter')); ?></label>
                                            <select class="form-control" required id="chapter_id" name="chapter_id">
                                                <?php $__currentLoopData = $chapters; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $chapter): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($chapter->id); ?>"
                                                        <?php echo e($chapter->id == $lesson->chapter_id ? 'selected' : ''); ?>>
                                                        <?php echo e($chapter->{'name_' . $lang}); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                        <?php if($lesson?->course?->trainings()?->first()?->type_id == 1): ?>
                                            <div class="col-md-6 mb-3" id="content_link">
                                                <label for="content_link"><?php echo e(trans('home.content_link_en')); ?></label>
                                                <input type="text" class="form-control" value="<?php echo e($lesson->content_link_en); ?>"
                                                    placeholder="<?php echo e(trans('home.content_link_en')); ?>" name="content_link_en"
                                                    required>
                                            </div>
                                            <div class="col-md-6 mb-3" id="meeting_Link_ar">
                                                <label for="meeting_Link_ar"><?php echo e(trans('home.meeting_Link_ar')); ?></label>
                                                <input type="text" class="form-control" value="<?php echo e($lesson->meeting_Link_ar); ?>"
                                                    placeholder="<?php echo e(trans('home.meeting_Link_ar')); ?>" name="meeting_Link_ar"
                                                    required>
                                            </div>
                                        <?php elseif($lesson?->course?->trainings()?->first()?->type_id == 2): ?>
                                            <div class="col-md-3 mb-3 " id="meeting_date">
                                                <label for="meeting_date"><?php echo e(trans('home.meeting_date')); ?></label>
                                                <input type="date" class="form-control"
                                                    value="<?php echo e(\Carbon\Carbon::parse($lesson->date)->format('Y-m-d')); ?>"
                                                    placeholder="<?php echo e(trans('home.meeting_date')); ?>" name="meeting_date">
                                            </div>
                                            <div class="col-md-2 mb-3 " id="meeting_time">
                                                <label for="meeting_time"><?php echo e(trans('home.meeting_time')); ?></label>
                                                <input type="time" class="form-control" value="<?php echo e($lesson->time); ?>"
                                                    placeholder="<?php echo e(trans('home.meeting_time')); ?>" name="meeting_time">
                                            </div>
                                            <div class="col-md-6">
                                                <label
                                                    for="content_link"><?php echo e(trans('home.address') . ' ' . __('home.en')); ?></label>
                                                <input type="text" class="form-control"
                                                    value="<?php echo e($lesson->content_link_en); ?>"
                                                    placeholder="<?php echo e(trans('home.address')); ?>" name="content_link_en">
                                            </div>
                                            <div class="col-md-6"><label
                                                    for="content_link"><?php echo e(trans('home.address') . ' ' . __('home.ar')); ?></label>
                                                <input type="text" class="form-control"
                                                    value="<?php echo e($lesson->content_link_ar); ?>"
                                                    placeholder="<?php echo e(trans('home.address')); ?>" name="content_link_ar">
                                            </div>
                                        <?php elseif($lesson?->course?->trainings()?->first()?->type_id == 3): ?>
                                            <div class="col-md-6">
                                                <label for="content_link"><?php echo e(trans('home.content_link_en')); ?></label>
                                                <input type="text" class="form-control"
                                                    value="<?php echo e($lesson->content_link_en); ?>"
                                                    placeholder="<?php echo e(trans('home.content_link_en')); ?>" name="content_link_en">
                                            </div>
                                            <div class="col-md-6">
                                                <label for="content_link"><?php echo e(trans('home.meeting_Link_ar')); ?></label>
                                                <input type="text" class="form-control"
                                                    value="<?php echo e($lesson->meeting_Link_ar); ?>"
                                                    placeholder="<?php echo e(trans('home.meeting_Link_ar')); ?>" name="meeting_Link_ar">
                                            </div>
                                        <?php endif; ?>



                                        <div class="col-md-12 row mt-2">
                                            <div class="col-md-6 mb-3 ">
                                                <label for="text_en"><?php echo e(trans('home.text_en')); ?></label>
                                                <textarea class="form-control ckeditor-classic" placeholder="<?php echo e(trans('home.text_en')); ?>" name="text_en"><?php echo e($lesson->text_en); ?></textarea>
                                            </div>
                                            <div class="col-md-6 mb-3 ">
                                                <label for="text_ar"><?php echo e(trans('home.text_ar')); ?></label>
                                                <textarea class="form-control ckeditor-classic" placeholder="<?php echo e(trans('home.text_ar')); ?>" name="text_ar"><?php echo e($lesson->text_ar); ?></textarea>
                                            </div>
                                        </div>

                                        <h4 class="card-title mt-3 mb-3"><?php echo e(trans('home.seo_block')); ?></h4>
                                        <div class="form-group col-md-6">
                                            <span class="badge-soft-primary"><?php echo e(trans('home.en')); ?></span>
                                            <div class="col-md-12 mb-3">
                                                <label for="link_en"><?php echo e(trans('home.slug')); ?></label>
                                                <input type="text" class="form-control" value="<?php echo e($lesson->link_en); ?>"
                                                    placeholder="<?php echo e(trans('home.slug') . ' ' . __('home.en')); ?>"
                                                    name="link_en">
                                            </div>
                                        </div>

                                        <div class="form-group col-md-6">
                                            <span class="badge-soft-primary"><?php echo e(trans('home.ar')); ?></span>
                                            <div class="col-md-12 mb-3">
                                                <label for="link_ar"><?php echo e(trans('home.slug')); ?></label>
                                                <input type="text" class="form-control" value="<?php echo e($lesson->link_ar); ?>"
                                                    placeholder="<?php echo e(trans('home.slug') . ' ' . __('home.ar')); ?>"
                                                    name="link_ar">
                                            </div>
                                        </div>


                                    </div>

                                    <div class="row">
                                        <div class="form-group col-4">
                                            <div class="form-check d-flex">
                                                <input type="checkbox" value="1" name="status" id="switch"
                                                    switch="success" <?php echo e($lesson->status ? 'checked' : ''); ?> />
                                                <label for="switch" data-on-label="<?php echo e(trans('home.yes')); ?>"
                                                    data-off-label="<?php echo e(trans('home.no')); ?>"></label>
                                                <label class="form-check-label mx-3" for="switch">
                                                    <?php echo e(trans('home.publish')); ?></label>
                                            </div>
                                        </div>
                                        <div class="form-group col-4">
                                            <div class="form-check d-flex">
                                                <input type="checkbox" value="1" name="free" id="free"
                                                    switch="success" <?php echo e($lesson->free ? 'checked' : ''); ?> />
                                                <label for="free" data-on-label="<?php echo e(trans('home.yes')); ?>"
                                                    data-off-label="<?php echo e(trans('home.no')); ?>"></label>
                                                <label class="form-check-label mx-3" for="free">
                                                    <?php echo e(trans('home.free')); ?></label>
                                            </div>
                                        </div>
                                        <div class="mt-4">
                                            <button type="submit"
                                                class="btn btn-primary w-md"><?php echo e(trans('home.save')); ?></button>
                                            <a href="<?php echo e(url('/admin/courses')); ?>"><button type="button"
                                                    class="btn btn-danger mr-1"><i class="icon-trash"></i>
                                                    <?php echo e(trans('home.cancel')); ?></button></a>
                                        </div>
                                    </div>


                                <?php echo Form::close(); ?>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- End Row -->
        </div>
    </div>
    
    <div class="modal fade text-left" id="attachments" tabindex="-1" role="dialog" aria-labelledby="myModalLabel34"
        aria-hidden="true">
        <div class="modal-dialog modal-xl modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h3 class="modal-title" id="myModalLabel34"><?php echo e(trans('home.attachments')); ?></h3>

                    <a type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                        <h5 class="modal-title" id="myModalLabel34">X</h5>
                    </a>
                </div>
                <div class="modal-body">
                    <div class="row justify-content-end">
                        <a data-bs-toggle="modal" data-bs-target="#add_attachment" href="javascript:void(0)"
                            class="btn btn-info m-1 px-5 col-md-2">
                            <i class="dripicons-plus"></i>
                            <?php echo e(trans('home.add')); ?></a>
                    </div>
                    <table class="table text-center" id="datatable">
                        <thead>
                            <tr>
                                <th><?php echo e(trans('home.id')); ?></th>
                                <th><?php echo e(trans('home.name') . ' ' . __('home.en')); ?></th>
                                <th><?php echo e(trans('home.name') . ' ' . __('home.ar')); ?></th>
                                <th><?php echo e(trans('home.view')); ?></th>
                                <th><?php echo e(__('home.edit')); ?></th>
                                <th><?php echo e(__('home.delete')); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $lesson->attachments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $attachment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($attachment->id); ?></td>
                                    <td><?php echo e($attachment->name_en); ?></td>
                                    <td><?php echo e($attachment->name_ar); ?></td>

                                    <td>
                                        <a type="button" class="btn btn-secondary waves-effect waves-light  col-8"
                                            href="<?php echo e(Helper::uploadedAttachmentPath($attachment->path)); ?>"
                                            target="_blank"><?php echo e(__('home.view')); ?></a>
                                    </td>
                                    <td>
                                        <a type="button" data-attach_id="<?php echo e($attachment->id); ?>"
                                            class="btn btn-info waves-effect waves-light  col-8 edit_attach"><?php echo e(__('home.edit')); ?></a>
                                    </td>
                                    <td>
                                        <form action="<?php echo e(route('attachments.destroy', $attachment)); ?>" method="POST">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                            <button type="submit" class="btn btn-danger waves-effect waves-light col-6"
                                                data-id="<?php echo e($attachment->id); ?>"><?php echo e(__('home.delete')); ?></button>
                                        </form>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    
    <div class="modal fade text-left sub-modal" id="add_attachment" tabindex="-1" role="dialog"
        aria-labelledby="myModalLabel34" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h3 class="modal-title" id="myModalLabel34"><?php echo e(__('home.New') . ' ' . trans('home.attachments')); ?>

                    </h3>

                    <a type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                        <h5 class="modal-title" id="myModalLabel34">X</h5>
                    </a>
                </div>
                <div class="modal-body">
                    <?php echo Form::open([
                        'method' => 'POST',
                        'url' => 'admin/attachments',
                        'data-toggle' => 'validator',
                        'files' => 'true',
                    ]); ?>

                    <div class="row">

                        <input type="hidden" name="lesson_id" value="<?php echo e($lesson->id); ?>">
                        <div class="col-md-6 mb-3">
                            <label for="name_en"><?php echo e(trans('home.name_en')); ?></label>
                            <input type="text" class="form-control" placeholder="<?php echo e(trans('home.name_en')); ?>"
                                name="name_en" required>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label for="name_ar"><?php echo e(trans('home.name_ar')); ?></label>
                            <input type="text" class="form-control" placeholder="<?php echo e(trans('home.name_ar')); ?>"
                                name="name_ar" required>
                        </div>
                        <div class="col-md-12 mb-3 mt-3">
                            <label for="formFile" class="form-label"><?php echo e(trans('home.choose_image')); ?></label>
                            <input class="form-control" type="file" id="formFile" name="attachment">
                        </div>

                    </div>
                    <div class="row mt-4 justify-content-end">
                        <button type="submit" class="btn btn-primary w-md col-auto"><?php echo e(trans('home.save')); ?></button>
                        <a class="close col-auto" data-bs-dismiss="modal" aria-label="Close"><button type="button"
                                class="btn btn-danger mr-1"><i class="icon-trash"></i>
                                <?php echo e(trans('home.cancel')); ?></button></a>
                    </div>
                    <?php echo Form::close(); ?>



                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <script>
        $(document).on('click', '.edit_attach', function() {
            var attach_id = $(this).data('attach_id');
            console.log(attach_id);

            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                url: "/admin/attachments/" + attach_id + "/edit",
                method: 'GET',
                success: function(data) {
                    $('body').append(data.html);
                    $('#edit_attachment_'+attach_id).modal('show');
                }
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/academybadertech/public_html/resources/views/admin/lessons/editLesson.blade.php ENDPATH**/ ?>