
<?php $__env->startSection('meta'); ?>
    <title><?php echo e(trans('home.add_training')); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

<div class="container-fluid">
    <!-- Page Header -->
    <div class="page-header">
        <div>
            <h2 class="main-content-title tx-24 mg-b-5"><?php echo e(trans('home.trainings')); ?></h2>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?php echo e(url('/admin')); ?>"><?php echo e(trans('home.admin')); ?></a></li>
                <li class="breadcrumb-item"><a href="<?php echo e(url('admin/trainings')); ?>"><?php echo e(trans('home.trainings')); ?></a></li>
                <li class="breadcrumb-item active" aria-current="page"><?php echo e(trans('home.add_training')); ?></li>
            </ol>
        </div>
    </div>

 <!-- End Page Header -->
    <?php echo Form::open(['route' => 'trainings.store', 'data-toggle'=>'validator', 'files'=>'true']); ?>

        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    
                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1"><?php echo e(trans('home.training_info')); ?></h6>
                            <hr>
                        </div>
                        
                        <div class="row">

                                    <div class="col-md-4 mb-3">
                                        <label for="name_en"><?php echo e(trans('home.name_en')); ?></label>
                                        <input type="text"  class="form-control" value="<?php echo e(old('name_en')); ?>" placeholder="<?php echo e(trans('home.name_en')); ?>" name="name_en" required>
                                    </div>
                                    <div class="col-md-4 mb-3">
                                        <label for="name_ar"><?php echo e(trans('home.name_ar')); ?></label>
                                        <input type="text"  class="form-control" value="<?php echo e(old('name_ar')); ?>" placeholder="<?php echo e(trans('home.name_ar')); ?>" name="name_ar" required>
                                    </div>
                                    <div class="col-md-2 mb-3">
                                        <label for="name_ar"><?php echo e(trans('home.price')); ?></label>
                                        <input type="text"  class="form-control" value="<?php echo e(old('price')); ?>" placeholder="<?php echo e(trans('home.price')); ?>" name="price" >
                                    </div>
                                    
                                    <div class="col-md-2 mb-3">
                                        <label for="period"><?php echo e(trans('home.training_period')); ?></label>
                                        <select class="form-control" data-trigger name="period">
                                            <option <?php if(old('period') == 'am'): echo 'selected'; endif; ?> value="am" ><?php echo e(__('home.am')); ?></option>
                                            <option <?php if(old('period') == 'pm'): echo 'selected'; endif; ?> value="pm" ><?php echo e(__('home.pm')); ?></option>
                                        </select>
                                    </div>
                                
                                    <div class="col-md-3 mb-3">
                                            <label for="level_id"><?php echo e(trans('home.category')); ?></label>
                                            <select class="form-control" data-trigger name="category_id" required>
                                                <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($category->id); ?>" <?php echo e($category->id==old('category_id')?'selected':''); ?> ><?php echo e($category->{'name_'.$lang}); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>

                                    
                                    <div class="col-md-3 mb-3">
                                        <label for="type"><?php echo e(trans('home.training_type')); ?></label>
                                        <select class="form-control" data-trigger name="type_id">
                                            <?php $__currentLoopData = $types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($type->id); ?>" <?php if(old('type_id') == $type->id): echo 'selected'; endif; ?> ><?php echo e($type->{'name_'.$lang}); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>

                                    <div class="col-md-2 mb-3">
                                        <label for="duration"><?php echo e(trans('home.duration')); ?></label>
                                        <input type="text"  class="form-control" placeholder="<?php echo e(trans('home.duration')); ?>" value="<?php echo e(old('duration')); ?>" name="duration" >
                                    </div>
                                    <div class="col-md-2 mb-3">
                                        <label for="duration"><?php echo e(trans('home.overall_days')); ?></label>
                                        <input type="text"  class="form-control" placeholder="<?php echo e(trans('home.overall_days')); ?>" value="<?php echo e(old('overall_days')); ?>" name="overall_days" >
                                    </div>
                                    
                                    <div class="form-group col-md-2">
                                        <label for="mobile"><?php echo e(trans('home.mobile')); ?></label>
                                        <input type="text"  class="form-control" placeholder="<?php echo e(trans('home.mobile')); ?>" name="mobile">
                                    </div>
                                    
                                    <div class="form-group col-md-2">
                                        <label for="whatsapp"><?php echo e(trans('home.whatsapp')); ?></label>
                                        <input type="text"  class="form-control" placeholder="<?php echo e(trans('home.whatsapp')); ?>" name="whatsapp">
                                    </div>
                                    <!--<span style="color: red;padding: 0 3px">*</span>-->
                                    <div class="form-group col-md-3">
                                        <label for="start_date"><?php echo e(trans('home.start_date')); ?></label>
                                        <div class="input-group">
                                            <input type='text' class="form-control datepicker"  name="start_date" placeholder="<?php echo e(trans('home.start_date')); ?>"  value="<?php echo e(old('start_date')); ?>" readonly/>
                                            <div class="input-group-append">
                                                <span class="input-group-text">
                                                    <i class="fas fa-calendar"></i>
                                                </span>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <div class="form-group col-md-3">
                                        <label for="end_date"><?php echo e(trans('home.end_date')); ?></label>
                                        <div class="input-group">
                                            <input type='text' class="form-control datepicker" name="end_date" placeholder="<?php echo e(trans('home.end_date')); ?>"  value="<?php echo e(old('end_date')); ?>" readonly/>
                                            <div class="input-group-append">
                                                <span class="input-group-text">
                                                    <i class="fas fa-calendar"></i>
                                                </span>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <div class="col-md-3 mb-3">
                                        <label for="type"><?php echo e(trans('home.teachers')); ?></label>
                                        <select class="form-control choices-multiple-remove-button" name="teacher_id[]" multiple>
                                            <?php $__currentLoopData = $teachers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $teacher): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value ="<?php echo e($teacher->id); ?>" ><?php echo e($teacher->name); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>


                                    <div class="col-md-3 mb-3">
                                        <label for="type"><?php echo e(trans('home.learn points')); ?></label>
                                        <select class="form-control choices-multiple-remove-button" name="point_id[]" multiple>
                                            <?php $__currentLoopData = $points; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $point): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value ="<?php echo e($point->id); ?>" ><?php echo e($point->{'text_'.$lang}); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                    <div class="col-md-3 mb-3">
                                        <label for="type"><?php echo e(trans('home.Include material')); ?></label>
                                        <select class="form-control choices-multiple-remove-button" name="material_id[]" multiple>
                                            <?php $__currentLoopData = $materials; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $material): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value ="<?php echo e($material->id); ?>" ><?php echo e($material->{'text_'.$lang}); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                    <div class="col-md-3 mb-3">
                                        <label for="type"><?php echo e(trans('home.requirments')); ?></label>
                                        <select class="form-control choices-multiple-remove-button" name="requirment_id[]" multiple>
                                            <?php $__currentLoopData = $requirments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $requirment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value ="<?php echo e($requirment->id); ?>"><?php echo e($requirment->{'text_'.$lang}); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                    <div class="col-md-3 mb-3">
                                        <label for="type"><?php echo e(trans('home.course')); ?></label>
                                        <select class="form-control choices-multiple-remove-button" name="course_id">
                                            <option value =""><?php echo e(trans('home.choose_course')); ?></option>
                                            <?php $__currentLoopData = $courses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $course): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value ="<?php echo e($course->id); ?>" <?php if(old('course_id') == $course->id): echo 'selected'; endif; ?>><?php echo e($course->{'name_'.$lang}); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                    <div class="col-md-3 mb-3">
                                        <label for="type"><?php echo e(trans('home.course_field')); ?></label>
                                        <select class="form-control choices-multiple-remove-button" name="training_field_id" required>
                                            <option value =""><?php echo e(trans('home.choose_course_field')); ?></option>
                                            <?php $__currentLoopData = $fields; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $field): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value ="<?php echo e($field->id); ?>" <?php if(old('training_field_id') == $field->id): echo 'selected'; endif; ?>><?php echo e($field->{'name_'.$lang}); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                    <hr class="mt-3">
                                    <div class="form-group col-4 mb-3">                                            
                                        <div class="form-check d-flex">
                                            <input type="checkbox" value="1" name="intro_link" id="switch_intro_link" switch="success" />
                                            <label for="switch_intro_link" data-on-label="<?php echo e(trans('home.yes')); ?>" data-off-label="<?php echo e(trans('home.no')); ?>"></label>
                                            <label class="form-check-label mx-3" for="switch_intro_link"><?php echo e(trans('home.intro_link')); ?> (<?php echo e(trans('home.press_to_add')); ?>)</label>
                                        </div>
                                    </div>
                                    <div class="col-md-4 mb-3">
                                        <label for="intro_link_video"><?php echo e(trans('home.intro_link_video')); ?></label>
                                        <input type="text"  class="form-control" placeholder="<?php echo e(trans('home.intro_link_video')); ?>" name="intro_link_video"  >
                                    </div>

                                    <div class="col-md-4 mb-3">
                                        <label for="formFile" class="form-label"><?php echo e(trans('home.choose_intro_video')); ?></label>
                                        <input class="form-control" type="file" id="formFile" name="video">
                                    </div>
                                    <hr class="mb-3">


                                    <div class="col-md-6 mb-3 ">
                                        <label for="formFile" class="form-label"><?php echo e(trans('home.choose_image')); ?></label>
                                        <input class="form-control" type="file" id="formFile" name="image">
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label for="formFile" class="form-label"><?php echo e(trans('home.certificate')); ?></label>
                                        <input class="form-control" type="file" id="formFile" name="certificate">
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label for="formFile" class="form-label"><?php echo e(trans('home.course_file')); ?></label>
                                        <input class="form-control" type="file" id="formFile" name="course_file">
                                    </div>
                                    <br>
                                    <hr>
                                    <br>
                                    <div class="col-md-6 mb-3 ">  
                                        <label for="text_en"><?php echo e(trans('home.text_en')); ?></label>
                                        <textarea class="form-control ckeditor-classic area1" placeholder="<?php echo e(trans('home.text_en')); ?>" name="text_en"><?php echo e(old('text_en')); ?></textarea>
                                    </div>                                      
                                    <div class="col-md-6 mb-3 ">  
                                        <label for="text_ar"><?php echo e(trans('home.text_ar')); ?></label>
                                        <textarea class="form-control ckeditor-classic area1" placeholder="<?php echo e(trans('home.text_ar')); ?>" name="text_ar"><?php echo e(old('text_ar')); ?></textarea>
                                    </div>                                       

                                    <hr>
                                    
                                    <h4 class="card-title mt-3 mb-3"><?php echo e(trans('home.seo_block')); ?></h4>
                                    <div class="col-md-12 mb-3">
                                        <label for="redirect_url"><?php echo e(trans('home.redirect_url')); ?></label>
                                        <input type="text" class="form-control" value="<?php echo e(old('redirect_url')); ?>" placeholder="<?php echo e(trans('home.redirect_url')); ?>" name="redirect_url">
                                    </div>
                                    <div class="form-group col-md-6">
                                        <span class="badge-soft-primary"><?php echo e(trans('home.en')); ?></span>
                                        <div class="col-md-12 mb-3">
                                            <label for="link_en"><?php echo e(trans('home.slug')); ?></label>
                                            <input type="text" class="form-control" value="<?php echo e(old('link_en')); ?>" placeholder="<?php echo e(trans('home.slug').' '.__('home.en')); ?>" name="link_en">
                                        </div>
                                        <div class="col-md-12 mb-3">
                                            <label for="meta_title"> <?php echo e(trans('home.meta_title')); ?></label>
                                            <textarea class="form-control" name="meta_title_en" placeholder="<?php echo e(trans('home.meta_title')); ?>"><?php echo e(old('meta_title_en')); ?></textarea>
                                        </div>
    
                                        <div class="col-md-12 mb-3">
                                            <label for="meta_desc"> <?php echo e(trans('home.meta_desc')); ?></label>
                                            <textarea class="form-control" name="meta_desc_en" placeholder="<?php echo e(trans('home.meta_desc')); ?>"><?php echo e(old('meta_desc_en')); ?></textarea>
                                        </div>
                                    </div>


                                    <div class="form-group col-md-6">
                                        <span class="badge-soft-primary"><?php echo e(trans('home.ar')); ?></span>
                                        <div class="col-md-12 mb-3">
                                            <label for="link_ar"><?php echo e(trans('home.slug')); ?></label>
                                            <input type="text" class="form-control" value="<?php echo e(old('link_ar')); ?>" placeholder="<?php echo e(trans('home.slug').' '.__('home.ar')); ?>" name="link_ar">
                                        </div>
                                        <div class="col-md-12 mb-3">
                                            <label for="meta_title"> <?php echo e(trans('home.meta_title')); ?></label>
                                            <textarea class="form-control" name="meta_title_ar" placeholder="<?php echo e(trans('home.meta_title')); ?>"><?php echo e(old('meta_title_ar')); ?></textarea>
                                        </div>
    
                                        <div class="col-md-12 mb-3">
                                            <label for="meta_desc"> <?php echo e(trans('home.meta_desc')); ?></label>
                                            <textarea class="form-control" name="meta_desc_ar" placeholder="<?php echo e(trans('home.meta_desc')); ?>"><?php echo e(old('meta_desc_ar')); ?></textarea>
                                        </div>
                                    </div>

                                </div>
                                
                                <div class="row">
                                    <div class="form-group col-4">                                            
                                        <div class="form-check d-flex">
                                            <input type="checkbox" value="1" name="status" id="switch" switch="success" checked/>
                                            <label for="switch" data-on-label="<?php echo e(trans('home.yes')); ?>" data-off-label="<?php echo e(trans('home.no')); ?>"></label>
                                            <label class="form-check-label mx-3" for="switch"> <?php echo e(trans('home.publish')); ?></label>
                                        </div>
                                    </div>
                                    <div class="form-group col-4">                                            
                                        <div class="form-check d-flex">
                                            <input type="checkbox" value="1" name="header" id="switch1" switch="success" checked/>
                                            <label for="switch1" data-on-label="<?php echo e(trans('home.yes')); ?>" data-off-label="<?php echo e(trans('home.no')); ?>"></label>
                                            <label class="form-check-label mx-3" for="switch1"> <?php echo e(trans('home.featured')); ?></label>
                                        </div>
                                    </div>
                                    <div class="form-group col-md-12">
                                        <p class="mt-4 mb-2"><?php echo e(trans('home.meta_robots')); ?></p>
                                        <label class="custom-switch">
                                            <input type="checkbox" name="meta_robots" value="1" class="custom-switch-input">
                                            <span class="custom-switch-indicator"></span>
                                            <span class="custom-switch-description"><?php echo e(trans('home.click_to_index')); ?></span>
                                        </label>
                                    </div>
                                     <div class="form-group col-4">                                            
                                        <div class="form-check d-flex">
                                            <input type="checkbox" value="1" name="publish" id="switch2" switch="success" checked/>
                                            <label for="switch2" data-on-label="<?php echo e(trans('home.yes')); ?>" data-off-label="<?php echo e(trans('home.no')); ?>"></label>
                                            <label class="form-check-label mx-3" for="switch2"> <?php echo e(trans('home.clickable')); ?></label>
                                        </div>
                                    </div>
                                <div class="mt-4">
                                    <button type="submit" class="btn btn-primary w-md"><?php echo e(trans('home.save')); ?></button>
                                    <a href="<?php echo e(url('/admin/trainings')); ?>"><button type="button" class="btn btn-danger mr-1"><i class="icon-trash"></i> <?php echo e(trans('home.cancel')); ?></button></a>
                                </div>
                            <?php echo Form::close(); ?>

                        </div>
                    </div>
                        
                
            </div> 
        </div>
    </div>
    <!-- End Row -->
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script>
        $( ".datepicker" ).datepicker({
            changeMonth: true,
            changeYear: true,
            dateFormat: 'yy-mm-dd'
        });
        
        $(document).ready(function(){
            $('.timepicker').timepicker({
                timeFormat: 'h:mm p',
            });
        });
        
        document.getElementById('switch_discount').addEventListener('change', function() {
            var discountDiv = $('.discount_div') ;
            if (this.checked) {
                $('.discount_div').removeClass('d-none')
            } else {
                $('.discount_div').addClass('d-none')
            }
        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/academybadertech/public_html/resources/views/admin/trainings/addTraining.blade.php ENDPATH**/ ?>