<title><?php echo e(trans('home.chapters')); ?></title>
<?php $__env->startSection('content'); ?>
    <div class="container-fluid">

        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5"><?php echo e(trans('home.chapters')); ?></h2>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?php echo e(route('admin')); ?>"><?php echo e(trans('home.admin')); ?></a></li>
                    <li class="breadcrumb-item active" aria-current="page"><?php echo e(trans('home.chapters')); ?></li>
                </ol>
            </div>

            <div class="btn btn-list">

                <a href="<?php echo e(route('chapters.create')); ?>"><button class="btn ripple btn-primary"><i
                            class="fas fa-plus-circle"></i> <?php echo e(trans('home.add')); ?></button></a>
                <a class="mr-2" id="btn_active"><button class="btn ripple btn-dark"><i class="fas fa-eye"></i>
                        <?php echo e(trans('home.publish/unpublish')); ?></button></a>
                <a class="mr-2" id="btn_delete"><button class="btn ripple btn-danger"><i class="fas fa-trash"></i>
                        <?php echo e(trans('home.delete')); ?></button></a>
            </div>
        </div>

        <?php if(session()->has('success')): ?>
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <?php echo e(session()->pull('success')); ?> <button type="button" class="btn-close" data-bs-dismiss="alert"
                    aria-label="Close"></button>
            </div>
        <?php endif; ?>

        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card-body">
                    <table class="table text-center" id="exportexample">
                        <thead>
                            <tr>
                                <th><input type="checkbox" class="form-check-input" id="checkAll" /></th>
                                <th><?php echo e(trans('home.id')); ?></th>
                                <th><?php echo e(trans('home.name')); ?></th>
                                <th><?php echo e(trans('home.order')); ?></th>
                                <th><?php echo e(trans('home.course')); ?></th>
                                <th><?php echo e(trans('home.view_all') . ' ' . __('home.lessons')); ?></th>
                                <th><?php echo e(__('home.publish/unpublish')); ?></th>
                                <th><?php echo e(__('home.edit')); ?></th>
                                <th><?php echo e(__('home.delete')); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $chapters; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $chapter): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr id="<?php echo e($chapter->id); ?>">
                                    <td> <input type="checkbox" name="checkbox" class="tableChecked form-check-input"  value="<?php echo e($chapter->id); ?>" /> </td>
                                    <td><a href="<?php echo e(route('chapters.edit', $chapter->id)); ?>"><?php echo e($chapter->id); ?></a></td>
                                    <td><?php echo e($chapter->{'name_' . $lang}); ?></td>
                                    <td><?php echo e($chapter->order); ?></td>
                                    <td><a
                                            href="javascript:void;"><?php echo e($chapter->course ? $chapter->course->{'name_' . $lang} : 'N/A'); ?></a>
                                    </td>
                                    <td><a href="<?php echo e(url('admin/chapters/' . $chapter->id . '/lessons')); ?>"
                                            class="btn btn-info waves-effect waves-light "><?php echo e('( ' . count($chapter->lessons) . ' ) ' . __('home.lessons')); ?></a>
                                    </td>
                                    <td>
                                        <input class="btn_active" data-id="<?php echo e($chapter->id); ?>" type="checkbox"
                                            id="switch-<?php echo e($chapter->id); ?>" switch="success"
                                            <?php echo e($chapter->status == 1 ? 'checked' : ''); ?> />
                                        <label for="switch-<?php echo e($chapter->id); ?>" data-on-label="<?php echo e(trans('home.yes')); ?>"
                                            data-off-label="<?php echo e(trans('home.no')); ?>"></label>
                                    </td>
                                    <td>
                                        <a type="button" class="btn btn-info waves-effect waves-light "
                                            href="<?php echo e(route('chapters.edit', $chapter->id)); ?>"><?php echo e(__('home.edit')); ?></a>
                                    </td>
                                    <td>
                                        <a type="button" class="btn btn-danger waves-effect waves-light btn_delete"
                                            data-id="<?php echo e($chapter->id); ?>"><?php echo e(__('home.delete')); ?></a>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        <!-- End Row -->
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/academybadertech/public_html/resources/views/admin/chapters/chapters.blade.php ENDPATH**/ ?>