<?php $__env->startSection('meta'); ?>
    <title><?php echo e(trans('home.edit_blog_category')); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

<div class="container-fluid">
    <!-- Page Header -->
    <div class="page-header">
        <div>
            <h2 class="main-content-title tx-24 mg-b-5"><?php echo e(trans('home.blogCategories')); ?></h2>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?php echo e(url('/admin')); ?>"><?php echo e(trans('home.admin')); ?></a></li>
                <li class="breadcrumb-item"><a href="<?php echo e(url('admin/blog-categories')); ?>"><?php echo e(trans('home.blogCategories')); ?></a></li>
                <li class="breadcrumb-item active" aria-current="page"><?php echo e(trans('home.edit_blog_category')); ?></li>
            </ol>
        </div>
    </div>
    <!-- End Page Header -->
    <?php echo Form::open(['method'=>'PATCH','url' => 'admin/blog-categories/'.$blogCategory->id, 'data-toggle'=>'validator', 'files'=>'true']); ?>

        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    
                    <div class="card-body">
                        <div>
                            <h6 class="card-title "><?php echo e(trans('home.edit_blog_category')); ?></h6>
                            <hr>
                        </div>
                        <div class="row">

                            <div class="form-group col-md-6">
                                <label for="name_en"><?php echo e(trans('home.name_en')); ?></label>
                                <input type="text"  class="form-control" placeholder="<?php echo e(trans('home.name_en')); ?>" name="name_en"value="<?php echo e($blogCategory->name_en); ?>" required>
                            </div>

                            <div class="form-group col-md-6">
                                <label for="name_ar"><?php echo e(trans('home.name_ar')); ?></label>
                                <input type="text"  class="form-control" placeholder="<?php echo e(trans('home.name_ar')); ?>" name="name_ar"value="<?php echo e($blogCategory->name_ar); ?>">
                            </div>


                            <div class="form-group col-md-6 ">
                                <label for="text_en"><?php echo e(trans('home.text_en')); ?></label>
                                <textarea class="form-control area1" name="text_en" placeholder="<?php echo e(trans('home.text_en')); ?>" ><?php echo e($blogCategory->text_en); ?></textarea>
                            </div>

                            <div class="form-group col-md-6 "> 
                                <label for="text_ar"><?php echo e(trans('home.text_ar')); ?></label>
                                <textarea class="form-control area1" name="text_ar" placeholder="<?php echo e(trans('home.text_ar')); ?>" ><?php echo e($blogCategory->text_ar); ?></textarea>
                            </div>

                            <div class="form-group col-md-12">
                                <p class="mt-4 mb-2"><?php echo e(trans('home.publish')); ?></p>
                                <label class="custom-switch">
                                    <input type="checkbox" name="status" value="1" class="custom-switch-input" <?php echo e(($blogCategory->status == 1)? 'checked':''); ?>/>
                                    <span class="custom-switch-indicator"></span>
                                    <span class="custom-switch-description"><?php echo e(trans('home.click_to_publish')); ?></span>
                                </label>
                            </div>  
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->

        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body"> 
                        <div>
                            <h6 class="card-title "><?php echo e(trans('home.seo_block')); ?></h6>
                        </div>                               
                        <div class="row">
                            <div class="form-group col-md-12">
                                <hr>
                                <span class="badge badge-success"><?php echo e(trans('home.en')); ?></span>
                            </div>
                            
                            <div class="form-group col-md-2">
                                <label for="link_en"><?php echo e(trans('home.slug')); ?></label>
                                <input type="text" class="form-control" placeholder="<?php echo e(trans('home.slug')); ?>" name="link_en" value="<?php echo e($blogCategory->link_en); ?>">
                            </div>
                    
                            <div class="form-group col-md-5">
                                <label for="meta_title"> <?php echo e(trans('home.meta_title')); ?></label>
                                <textarea class="form-control" name="meta_name_en" placeholder="<?php echo e(trans('home.meta_title')); ?>"><?php echo e($blogCategory->meta_name_en); ?></textarea>
                            </div>
                            
                            <div class="form-group col-md-5">
                                <label for="meta_desc"> <?php echo e(trans('home.meta_desc')); ?></label>
                                <textarea class="form-control" name="meta_desc_en" placeholder="<?php echo e(trans('home.meta_desc')); ?>"><?php echo e($blogCategory->meta_desc_en); ?></textarea>
                            </div>
                            
                            <div class="form-group col-md-12">
                                <hr>
                                <span class="badge badge-success"><?php echo e(trans('home.ar')); ?></span>
                            </div>
                            
                            <div class="form-group col-md-2">
                                <label for="link_ar"><?php echo e(trans('home.slug')); ?></label>
                                <input type="text" class="form-control" placeholder="<?php echo e(trans('home.slug')); ?>" name="link_ar" value="<?php echo e($blogCategory->link_ar); ?>">
                            </div>
                            
                            <div class="form-group col-md-5">
                                <label for="meta_title"> <?php echo e(trans('home.meta_title')); ?></label>
                                <textarea class="form-control" name="meta_name_ar" placeholder="<?php echo e(trans('home.meta_title')); ?>"><?php echo e($blogCategory->meta_name_ar); ?></textarea>
                            </div>
                            
                            <div class="form-group col-md-5">
                                <label for="meta_desc"> <?php echo e(trans('home.meta_desc')); ?></label>
                                <textarea class="form-control" name="meta_desc_ar" placeholder="<?php echo e(trans('home.meta_desc')); ?>"><?php echo e($blogCategory->meta_desc_ar); ?></textarea>
                            </div>
                            
                            <div class="form-group col-md-12">
                                <p class="mt-4 mb-2"><?php echo e(trans('home.meta_robots')); ?></p>
                                <label class="custom-switch">
                                    <input type="checkbox" name="meta_robots" value="1" class="custom-switch-input" <?php echo e(($blogCategory->meta_robots == 1)? 'checked':''); ?>>
                                    <span class="custom-switch-indicator"></span>
                                    <span class="custom-switch-description"><?php echo e(trans('home.click_to_index')); ?></span>
                                </label>
                            </div>
                        </div>                                
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->

        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div class="row">

                            <div class="form-group col-md-12">
                                <button type="submit" class="btn btn-success"><i class="icon-note"></i> <?php echo e(trans('home.save')); ?> </button>
                                <a href="<?php echo e(url('/admin/blog-categories')); ?>"><button type="button" class="btn btn-danger mr-1"><i class="icon-trash"></i> <?php echo e(trans('home.cancel')); ?></button></a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->

    <?php echo Form::close(); ?>


</div>

<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/academybadertech/public_html/resources/views/admin/blogCategories/editBlogCategory.blade.php ENDPATH**/ ?>