<title><?php echo e(trans('home.newsitems')); ?></title>
<?php $__env->startSection('content'); ?>
    <div class="container-fluid">

        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5"><?php echo e(trans('home.newsitems')); ?></h2>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?php echo e(url('/admin')); ?>"><?php echo e(trans('home.admin')); ?></a></li>
                    <li class="breadcrumb-item active" aria-current="page"><?php echo e(trans('home.newsitems')); ?></li>
                </ol>
            </div>

            <div class="btn btn-list">
                <a href="<?php echo e(url('admin/news-items/create')); ?>"><button class="btn ripple btn-primary"><i class="fas fa-plus-circle"></i> <?php echo e(trans('home.add')); ?></button></a>
                <a id="btn_active"><button class="btn ripple btn-dark"><i class="fas fa-eye"></i> <?php echo e(trans('home.publish/unpublish')); ?></button></a>
                <a id="btn_delete" ><button class="btn ripple btn-danger"><i class="fas fa-trash"></i> <?php echo e(trans('home.delete')); ?></button></a>
            </div>
        </div>
        <!-- End Page Header -->

        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1"><?php echo e(trans('home.newsitems')); ?></h6>
                            <p class="text-muted card-sub-title"><?php echo e(trans('home.table_contain_all_data_shortly_you_can_view_more_details')); ?></p>
                            <hr>
                        </div>

                        <div class="table-responsive">
                        <table class="table" id="exportexample">
                            <thead>
                                <tr>
                                   <th><input type="checkbox" name="checkbox" class="tableChecked" id="checkAll"/></th>
                                    <th><?php echo e(trans('home.id')); ?></th>
                                    <th><?php echo e(trans('home.name_en')); ?></th>
                                    <th><?php echo e(trans('home.name_ar')); ?></th>
                                    <th><?php echo e(trans('home.date')); ?></th>
                                    <th><?php echo e(trans('home.writer')); ?></th>
                                    <th><?php echo e(trans('home.status')); ?></th>
                                    <!--<th><?php echo e(trans('home.actions')); ?></th>-->
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $newsItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $newsItem): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr id="<?php echo e($newsItem->id); ?>">
                                        <td> <input type="checkbox" name="checkbox"  class="tableChecked" value="<?php echo e($newsItem->id); ?>" /> </td>
                                        <td><a href="<?php echo e(route('news-items.edit', $newsItem->id)); ?>"><?php echo e($newsItem->id); ?></a></td>
                                        <td><a href="<?php echo e(route('news-items.edit', $newsItem->id)); ?>"><?php echo e($newsItem->name_en); ?></a></td>
                                        <td><a href="<?php echo e(route('news-items.edit', $newsItem->id)); ?>"><?php echo e($newsItem->name_ar); ?></a></td>
                                        <td><a href="<?php echo e(route('news-items.edit', $newsItem->id)); ?>"><?php echo e($newsItem->date); ?></a></td>
                                        <td><a href="<?php echo e(route('news-items.edit', $newsItem->id)); ?>"><?php echo e($newsItem->writer?->name); ?></a></td>
                                        <td>
                                            <a href="<?php echo e(route('news-items.edit', $newsItem->id)); ?>">
                                                <?php if($newsItem->status == 1): ?>
                                                    <span class="badge badge-success"><?php echo e(trans('home.yes')); ?></span>
                                                <?php else: ?>
                                                    <span class="badge badge-danger"><?php echo e(trans('home.no')); ?></span>
                                                <?php endif; ?>
                                            </a>
                                        </td>
                                        <!--<td><a href='<?php echo e(($lang == "en")?LaravelLocalization::localizeUrl("/articles/$newsItem->link_en"):LaravelLocalization::localizeUrl("/articles/$newsItem->link_ar")); ?>' target="_blank"><i class="fas fa-eye"></i> <?php echo e(trans('home.news_preview')); ?></a></td>-->
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
					</div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
    </div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/academybadertech/public_html/resources/views/admin/newsItems/newsItems.blade.php ENDPATH**/ ?>