<!DOCTYPE html>
<html class="no-js" lang="<?php echo e($lang == 'en' ? 'en' : 'ar'); ?>" dir="<?php echo e($lang == 'en' ? 'ltr' : 'rtl'); ?>">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <?php echo $__env->yieldContent('title'); ?>
    <?php echo $__env->make('layouts.partials.hreflang', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <meta name="robots" content="noindex, follow" />
    <meta name="description" content="">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

    <!-- Favicon -->
    <link rel="shortcut icon" type="image/x-icon" href="<?php echo e(Helper::imageFilesPath('favicon.ico')); ?>">

    <!-- CSS
	============================================ -->
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('vendor/bootstrap.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('plugins/feather.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('vendor/slick.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('vendor/slick-theme.css')); ?>">
    <link rel="shortcut icon" type="image/x-icon"
          href="<?php echo e(Helper::uploadedImagesPath('settings', $configration->app_logo)); ?>">
    <link rel="icon" href="<?php echo e(url('uploads/settings/'.$configration->fav_icon)); ?>" type="image/x-icon" />

    <!-- fontawesome 6.4.2 -->
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('plugins/jodit.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('plugins/sal.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('plugins/fontawesome.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('plugins/magnigy-popup.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('plugins/euclid-circulara.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('plugins/plyr.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('plugins/odometer.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('plugins/animation.css')); ?>">
    <!-- swiper Css 10.2.0 -->
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('plugins/swiper.css')); ?>">
    <!-- magnific popup css -->
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('vendor/magnific-popup.css')); ?>">
    <!-- Bootstrap 5.0.2 -->
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('plugins/bootstrap-select.min.css')); ?>">
    <!-- jquery ui css -->
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('plugins/jquery-ui.css')); ?>">
    <!-- metismenu scss -->
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('vendor/metismenu.css')); ?>">
    <!-- custom style css -->
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('styles.css')); ?>">
    <?php if(app()->getLocale() === 'ar'): ?>
        <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('rtl.css')); ?>">
    <?php endif; ?>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@10/dist/sweetalert2.min.css">


    <?php echo $__env->yieldContent('style'); ?>


</head>

<body class="rbt-header-sticky">


<?php echo $__env->make('layouts.partials.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
 <?php echo $__env->make('website.student.layouts.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?> 


<div class="rbt-dashboard-area rbt-section-overlayping-top rbt-section-gapBottom">
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <!-- Start Dashboard Top  -->
                <div class="rbt-dashboard-content-wrapper">
                    <!--<div class="tutor-bg-photo bg_image bg-gradient-1 height-350"></div>-->
                
                </div>
                <div class="row g-5">
                    <?php echo $__env->make('website.student.layouts.aside', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php echo $__env->yieldContent('content'); ?>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- End Card Style -->


<div class="rbt-separator-mid">
    <div class="container">
        <hr class="rbt-separator m-0">
    </div>
</div>

<?php echo $__env->make('layouts.partials.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


<div class="rbt-progress-parent">
    <svg class="rbt-back-circle svg-inner" width="100%" height="100%" viewBox="-1 -1 102 102">
        <path d="M50,1 a49,49 0 0,1 0,98 a49,49 0 0,1 0,-98" />
    </svg>
</div>

<!-- JS ============================================ -->
<!-- Modernizer JS -->
<script src="<?php echo e(Helper::jsFilesPath('vendor/modernizr.min.js')); ?>"></script>
<!-- jQuery JS -->
<script src="<?php echo e(Helper::jsFilesPath('vendor/jquery.js')); ?>"></script>
<!-- Bootstrap JS -->
<script src="<?php echo e(Helper::jsFilesPath('vendor/bootstrap.min.js')); ?>"></script>
<!-- sal') }} -->
<script src="<?php echo e(Helper::jsFilesPath('vendor/sal.js')); ?>"></script>
<!-- Dark Mode Switcher -->
<script src="<?php echo e(Helper::jsFilesPath('vendor/js.cookie.js')); ?>"></script>
<script src="<?php echo e(Helper::jsFilesPath('vendor/jquery.style.switcher.js')); ?>"></script>
<script src="<?php echo e(Helper::jsFilesPath('vendor/swiper.js')); ?>"></script>
<script src="<?php echo e(Helper::jsFilesPath('vendor/jquery-appear.js')); ?>"></script>
<script src="<?php echo e(Helper::jsFilesPath('vendor/odometer.js')); ?>"></script>
<script src="<?php echo e(Helper::jsFilesPath('vendor/backtotop.js')); ?>"></script>
<script src="<?php echo e(Helper::jsFilesPath('vendor/isotop.js')); ?>"></script>
<script src="<?php echo e(Helper::jsFilesPath('vendor/imageloaded.js')); ?>"></script>

<script src="<?php echo e(Helper::jsFilesPath('vendor/wow.js')); ?>"></script>
<script src="<?php echo e(Helper::jsFilesPath('vendor/waypoint.min.js')); ?>"></script>
<script src="<?php echo e(Helper::jsFilesPath('vendor/easypie.js')); ?>"></script>
<script src="<?php echo e(Helper::jsFilesPath('vendor/text-type.js')); ?>"></script>
<script src="<?php echo e(Helper::jsFilesPath('vendor/jquery-one-page-nav.js')); ?>"></script>
<script src="<?php echo e(Helper::jsFilesPath('vendor/bootstrap-select.min.js')); ?>"></script>
<script src="<?php echo e(Helper::jsFilesPath('vendor/jquery-ui.js')); ?>"></script>
<script src="<?php echo e(Helper::jsFilesPath('vendor/magnify-popup.min.js')); ?>"></script>
<script src="<?php echo e(Helper::jsFilesPath('vendor/paralax-scroll.js')); ?>"></script>
<script src="<?php echo e(Helper::jsFilesPath('vendor/paralax.min.js')); ?>"></script>
<script src="<?php echo e(Helper::jsFilesPath('vendor/countdown.js')); ?>"></script>
<script src="<?php echo e(Helper::jsFilesPath('vendor/plyr.js')); ?>"></script>
<script src="<?php echo e(Helper::jsFilesPath('vendor/jodit.min.js')); ?>"></script>
<script src="<?php echo e(Helper::jsFilesPath('vendor/Sortable.min.js')); ?>"></script>



<!-- Main JS -->
<script src="<?php echo e(Helper::jsFilesPath('main.js')); ?>"></script>
<?php echo $__env->yieldContent('script'); ?>
</body>

</html><?php /**PATH /home/academybadertech/public_html/resources/views/website/student/layouts/master.blade.php ENDPATH**/ ?>