@extends('layouts.app')
@section('title')
    <title> {{ trans('home.validate-certificate') }}</title>
@endsection
@section('content')
    <div class="rts-bread-crumbarea-1 rts-section-gap bg_image">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="breadcrumb-main-wrapper">
                        <h1 class="title"> {{ trans('home.validate-certificate') }}</h1>
                        <!-- breadcrumb pagination area -->
                        <div class="pagination-wrapper">
                            <a href="{{ url('/') }}">@lang('home.home')</a>
                            <i class="fa-regular fa-chevron-right"></i>
                            <a class="active"> {{ trans('home.validate-certificate') }}</a>
                        </div>
                        <!-- breadcrumb pagination area end -->
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- blog details area start -->
    <div class="rts-blog-list-area rts-section-gap">
        <div class="container">
            <form method="POST" action="{{ route('checkCertificate') }}">
                @csrf
                <div class="row justify-content-center">
                    <div class="settings-wrapper-dashed col-6 row justify-content-center text-center">
                        @if(Session::has('certificate'))
                            <h5><span class="m-3 text-secondary">@lang('home.certificate code'):</span>{{ Session::get('certificate')}}</h5>
                        @endif
                        @if(Session::has('certificate'))
                        <a href="{{ url('certificate/' . Session::get('certificate')) }}"
                            class="rts-btn btn-primary">@lang('home.viewCertificate') 
                        <i class="fa-regular fa-download"></i></a>
                        <a href="{{ url('validate-certificate') }}"
                            class="rts-btn btn-secondary text-white mx-4">@lang('home.newValidation')</a>
                        @else
                        <div class="social-profile-link-wrapper">
                            <div class="single-profile-wrapper">
                                <div class="left">
                                    <div class="icon">
                                        <span>{{ trans('home.validate-certificate') }}</span>
                                    </div>
                                </div>
                                <div class="right">
                                    <input type="text" name="certificateCode" required
                                        value="{{ old('certificateCode') }}">
                                        @error('certificateCode')
                                            <span class="text-danger">{{$message}}</span>
                                        @enderror
                                </div>
                            </div>
                        </div>
                            <button class="rts-btn btn-primary" type="submit">@lang('home.submit')</button>
                        @endif
                    </div>
                </div>
            </form>

        </div>
    </div>
    <!-- blog details area end -->
@endsection
@section('script')
    @isset($success)
        <script>
            Swal.fire({
                icon: 'success',
                title: '{{ $success }}',
            });
        </script>
    @endisset
    @if (Session::has('error'))
        <script>
            Swal.fire({
                icon: 'error',
                title: '{{ Session::pull('error') }}',
            });
        </script>
    @endif
@endsection
