@extends('website.student.layouts.master')
@section('title')
    <title>{{ __('home.wishlist') }}</title>
@endsection

@section('sub-title', __('home.wishlist') )

@section('content')

    <div class="col-lg-9">
        <!-- Start Enrole Course  -->
        <div class="rbt-dashboard-content bg-color-white rbt-shadow-box">
            <div class="content">
                <div class="section-title">
                    <h4 class="rbt-title-style-3">{{ __('home.wishlist') }}</h4>
                </div>
                <div class="row g-5">
                    <!-- Start Single Course  -->
                    @foreach($wishlist as $training)
                    <div class="col-lg-4 col-md-6 col-12">
                        <div class="rbt-card variation-01 rbt-hover">
                            <div class="rbt-card-img">
                                <a    href="{{ LaravelLocalization::localizeUrl('course/' . $training->course->{'link_'.$lang}) }}" class="thumbnail">
                                                    <img src="{{ isset($training->course->image) ? Helper::uploadedImagesPath('courses/source', $training->course->image) : Helper::imageFilesPath('noimage.png') }}" alt="course">
                                </a>
                            </div>
                            <div class="rbt-card-body">
                                <h4 class="rbt-card-title"><a href="{{ LaravelLocalization::localizeUrl('course/' . $training->course->{'link_'.$lang} ) }}">
                                        {{ $training->course->{'name_' . $lang} }}</a>
                                </h4>
                                <ul class="rbt-meta">
                                    <li><i class="feather-book"></i>{{ $training->course->category->{'name_' . $lang} ?? '' }}</li>
                                </ul>
                                                <div class="rbt-card-bottom">
                                                    <div class="rbt-price">
                                                        @if ($training->course->discount)
                                                        <span class="off-price">
                                                        {{ $training->course->last_price() . ' ' . __('home.SAR') }}  
                                                    </span>
                                                        <span class="current-price">
                                                        {{ $training->course->price . ' ' . __('home.SAR') }} 
                                                    </span>
                                                        @if(isset($training->course->discount->end_date))
                                                        <div class="clock-area">
                                                            <i class="ms-1 fa-light fa-clock"></i>
                                                            @php
                                                            $end_date = \Carbon\Carbon::parse($training->course->discount->end_date);
                                                            $daysLeft = \Carbon\Carbon::now()->diffInDays($end_date);
                                                            @endphp
                                                            <span class="text-danger">{{ $daysLeft }} @lang('home.Day left at this price!')</span>
                                                        </div>
                                                        @endif
                                                        @else
                                                        <div class="current-price">
                                                            {{ $training->course->last_price() . ' ' . __('home.SAR') }}
                                                        </div>
                                                        @endif
                                                    </div>
                                                    <a class="rbt-btn-link" href="{{ LaravelLocalization::localizeUrl('course/' . $training->course->{'link_'.$lang}) }}">{{__('home.Learn_More')}}<i class="feather-arrow-right"></i></a>
                                                </div>

                            </div>
                        </div>
                    </div>
                    @endforeach
                    <!-- End Single Course  -->
                </div>
            </div>
        </div>
        <!-- End Enrole Course  -->
    </div>
@endsection