@extends('website.student.layouts.master')
@section('title')
    <title>{{ __('home.settings') }}</title>
@endsection

@section('sub-title',__('home.settings'))

@section('content')
    <div class="col-lg-9">
        <!-- Start Instructor Profile  -->
        <div class="rbt-dashboard-content bg-color-white rbt-shadow-box">
            <div class="content">

                <div class="section-title">
                    <h4 class="rbt-title-style-3">{{__('home.settings')}}</h4>
                </div>
                @if(session()->has('success'))
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        {{ session()->pull('success') }} <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                @endif
                @if($errors->any())
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <ul>
                            @foreach($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                @endif
                <div class="advance-tab-button mb--30">
                    <ul class="nav nav-tabs tab-button-style-2 justify-content-start"
                        id="settinsTab-4" role="tablist">
                        <li role="presentation">
                            <a href="#" class="tab-button active" id="profile-tab"
                               data-bs-toggle="tab" data-bs-target="#profile" role="tab"
                               aria-controls="profile" aria-selected="true">
                                <span class="title">@lang('home.profile')</span>
                            </a>
                        </li>
                        <li role="presentation">
                            <a href="#" class="tab-button" id="password-tab" data-bs-toggle="tab"
                               data-bs-target="#password" role="tab" aria-controls="password"
                               aria-selected="false">
                                <span class="title">@lang('home.password')</span>
                            </a>
                        </li>
                    </ul>
                </div>

                <div class="tab-content">
                    <div class="tab-pane fade active show" id="profile" role="tabpanel"
                         aria-labelledby="profile-tab">
                        <!-- Start Profile Row  -->
                        <form method="POST" class="rbt-profile-row rbt-default-form row row--15" action="{{route('updateMyAccount')}}" enctype="multipart/form-data">
                            @csrf
                            <div class="col-lg-6 col-md-6 col-sm-6 col-12">
                                <div class="rbt-form-group">
                                    <label for="firstname">@lang('home.f_name')</label>
                                    <input type="text" placeholder="@lang('home.f_name')" name="f_name" value="{{$user->f_name}}">
                                </div>
                            </div>
                            <div class="col-lg-6 col-md-6 col-sm-6 col-12">
                                <div class="rbt-form-group">
                                    <label for="lastname">@lang('home.l_name')</label>
                                    <input type="text" placeholder="@lang('home.l_name')" name="l_name" value="{{$user->l_name}}">
                                </div>
                            </div>
                            <div class="col-lg-6 col-md-6 col-sm-6 col-12">
                                <div class="rbt-form-group">
                                    <label for="email">@lang('home.email')</label>
                                    <input type="email" placeholder="@lang('home.email')" name="email" value="{{$user->email}}">
                                </div>
                            </div>

                            <div class="col-lg-6 col-md-6 col-sm-6 col-12">
                                <div class="rbt-form-group">
                                    <label for="phone">@lang('home.phone')</label>
                                    <input type="tel" name="phone"  value="{{$user->phone}}">
                                </div>
                            </div>
                            <div class="col-lg-12 col-md-12 col-sm-12 col-12">
                                <div class="rbt-form-group">
                                    <label for="image">@lang('home.image')</label>
                                    <input type="file" name="image" >
                                </div>
                            </div>
                            <div class="col-sm-6 form-group mb-2">
                                @if ($user->image)
                                    <img alt="{{ $user->name() }}" class="col-2 m-2"
                                         src="{{ URL::to('uploads/users/source') }}/{{ $user->image }}">
                                @else
                                    <img alt="avatar" class="col-2 m-2"
                                         src="{{ URL::To('resources/assets/back/images/users/avatar-1.jpg') }}">
                                @endif
                            </div>
                            <div class="col-12 mt--20">
                                <div class="rbt-form-group">
                                  <button type="submit" class="rbt-btn btn-gradient">@lang('home.update_info')</button>
                                </div>
                            </div>
                        </form>
                        <!-- End Profile Row  -->
                    </div>

                    <div class="tab-pane fade" id="password" role="tabpanel"
                         aria-labelledby="password-tab">
                        <!-- Start Profile Row  -->
                        <form method="POST" action="{{route('updateMyAccountPassword')}}" class="rbt-profile-row rbt-default-form row row--15" enctype="multipart/form-data">
                            @csrf
                            <div class="col-12">
                                <div class="rbt-form-group">
                                    <label for="currentpassword">@lang('home.current_password')</label>
                                    <input id="currentpassword" type="password" name="Current Password"
                                           placeholder="@lang('home.Current Password')" required>
                                </div>
                            </div>
                            <div class="col-12">
                                <div class="rbt-form-group">
                                    <label for="newpassword">@lang('home.new_password')</label>
                                    <input id="newpassword" type="password" name="newPassword" placeholder="@lang('home.new_password')" required>
                                </div>
                            </div>
                            <div class="col-12">
                                <div class="rbt-form-group">
                                    <label for="retypenewpassword">@lang('home.confirm_password')</label>
                                    <input id="retypenewpassword" type="password" name="newPassword_confirmation" placeholder="@lang('home.confirm_password')" required>
                                </div>
                            </div>
                            <div class="col-12 mt--10">
                                <div class="rbt-form-group">
                                    <button type="submit" class="rbt-btn btn-gradient">@lang('home.rest_password')</button>
                                </div>
                            </div>
                        </form>
                        <!-- End Profile Row  -->
                    </div>
                </div>
            </div>
        </div>
        <!-- End Instructor Profile  -->

    </div>
@endsection