@extends('website.student.layouts.master')
@section('title')
    <title>{{trans('home.my_courses')}}</title>
@endsection    

@section('sub-title',trans('home.my_courses'))

@section('content')
    <div class="col-lg-9">
        <!-- Start Enrole Course  -->
        <div class="rbt-dashboard-content bg-color-white rbt-shadow-box">
            <div class="content">

                <div class="section-title">
                    <h4 class="rbt-title-style-3">{{ trans('home.my_courses') }}</h4>
                </div>

                <div class="advance-tab-button mb--30">
                    <ul class="nav nav-tabs tab-button-style-2 justify-content-start" id="myTab-4"
                        role="tablist">
                        <li role="presentation">
                            <a href="#" class="tab-button active" id="home-tab-4"
                               data-bs-toggle="tab" data-bs-target="#home-4" role="tab"
                               aria-controls="home-4" aria-selected="true">
                                <span class="title">@lang('home.enrolled_cousrse')</span>
                            </a>
                        </li>
                        <li role="presentation">
                            <a href="#" class="tab-button" id="contact-tab-4" data-bs-toggle="tab"
                               data-bs-target="#contact-4" role="tab" aria-controls="contact-4"
                               aria-selected="false">
                                <span class="title">@lang('home.completed_courses')</span>
                            </a>
                        </li>
                    </ul>
                </div>

                <div class="tab-content">
                    <div class="tab-pane fade active show" id="home-4" role="tabpanel"
                         aria-labelledby="home-tab-4">
                        <div class="row g-5">
                            @forelse ($my_courses as $my_course)
                                <!-- Start Single Course  -->
                                <div class="col-lg-4 col-md-6 col-12">
                                    <div class="rbt-card variation-01 rbt-hover">
                                        <div class="rbt-card-img">
                                            <a    href="{{ LaravelLocalization::localizeUrl('user/course/' . $my_course->course->{'link_' . $lang}) }}" class="thumbnail">
                                                <img src="{{ Helper::uploadedImagesPath('courses/source', $my_course->course?->image) }}" alt="{{ $my_course->course->{'name_' . $lang} }}">
                                                <div class="tag-thumb">
                                                </div>
                                            </a>

                                        </div>
                                        <div class="rbt-card-body">
                                            <h4 class="rbt-card-title">
                                                <a    href="{{ LaravelLocalization::localizeUrl('user/course/' . $my_course->course->{'link_' . $lang}) }}">
                                                    <h5 >{{ $my_course->course->{'name_' . $lang} }}</h5>
                                                </a>
                                            </h4>
                                            <ul class="rbt-meta">
                                                <li><i class="feather-book"></i>{{ $my_course->course->category->{'name_' . $lang} }}</li>
                                            </ul>

                                            <div class="rbt-progress-style-1 mb--20 mt--10">
                                                <div class="single-progress">
                                                    <h6 class="rbt-title-style-2 mb--10">@lang('home.completed')</h6>
                                                    <div class="progress">
                                                        <div class="progress-bar wow fadeInLeft bar-color-success"
                                                             data-wow-duration="0.5s"
                                                             data-wow-delay=".3s" role="progressbar"
                                                             style="width: {{$my_course->progress}}%" aria-valuenow="90"
                                                             aria-valuemin="0" aria-valuemax="100">
                                                        </div>
                                                        <span
                                                                class="rbt-title-style-2 progress-number">{{$my_course->progress}}%</span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!-- End Single Course  -->
                            @empty
                                <div class="m-5 text-center"> {{__('home.empty_courses')}}</div>
                            @endforelse
                        </div>
                    </div>


                    <div class="tab-pane fade" id="contact-4" role="tabpanel"
                         aria-labelledby="contact-tab-4">
                        <div class="row g-5">
                            @forelse($my_completed_courses as $my_completed_course)
                            <!-- Start Single Course  -->
                            <div class="col-lg-4 col-md-6 col-12">
                                <div class="rbt-card variation-01 rbt-hover">
                                    <div class="rbt-card-img">
                                        <a    href="{{ LaravelLocalization::localizeUrl('user/course/' . $my_completed_course->course->{'link_' . $lang}) }}" class="thumbnail">
                                            <img src="{{ Helper::uploadedImagesPath('courses/source', $my_completed_course->course?->image) }}" alt="{{ $my_completed_course->course->{'name_' . $lang} }}">
                                        </a>
                                    </div>
                                    <div class="rbt-card-body">
                                        <h4 class="rbt-card-title">
                                            <a    href="{{ LaravelLocalization::localizeUrl('user/course/' . $my_completed_course->course->{'link_' . $lang}) }}">
                                                <h5 class="title">{{ $my_completed_course->course->{'name_' . $lang} }}</h5>
                                            </a>
                                        </h4>
                                        <ul class="rbt-meta">
                                            <li><i class="feather-book"></i>{{ $my_completed_course->course->category->{'name_' . $lang} }}</li>
                                        </ul>

                                        <div class="rbt-progress-style-1 mb--20 mt--10">
                                            <div class="single-progress">
                                                <h6 class="rbt-title-style-2 mb--10">
                                                    @lang('home.completed')
                                                </h6>
                                                <div class="progress">
                                                    <div class="progress-bar wow fadeInLeft bar-color-success"
                                                             data-wow-duration="0.5s"
                                                             data-wow-delay=".3s" role="progressbar"
                                                        style="width: {{$my_completed_course->progress}}%" aria-valuenow="90"
                                                             aria-valuemin="0" aria-valuemax="100">
                                                        </div>
                                                        <span
                                                            class="rbt-title-style-2 progress-number">{{$my_completed_course->progress}}%</span>
                                                    
                                                  </div>
                                            </div>
                                        </div>
                                        <div class="rbt-card-bottom">
                                            @if ($my_completed_course->course->my_certificate)
                                                <a class="rbt-btn btn-sm bg-primary-opacity w-100 text-center"
                                                   href="{{Helper::uploadedImagesPath('certificates',$my_completed_course->course->my_certificate->path)}}" download class="rts-btn btn-border text-center">@lang('home.Download Certificate')</a>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- End Single Course  -->
                            @empty
                                <div class="m-5 text-center"> {{__('home.empty_courses')}}</div>
                            @endforelse
                        </div>
                    </div>
                </div>

            </div>
        </div>
        <!-- End Enrole Course  -->
    </div>

@endsection