@extends('layouts.app')
@section('title')
    @php echo $metatags @endphp
@endsection
@section('content')

    <!-- bread crumb area -->
    <div class="rts-bread-crumbarea-1 rts-section-gap bg_image">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="breadcrumb-main-wrapper">
                        <h1 class="title">{{$service->{'name_'.$lang} }}</h1>
                        <!-- breadcrumb pagination area -->
                        <div class="pagination-wrapper">
                            <a    href="{{url('/')}}"> @lang('home.home') </a>
                            <i class="fa-regular fa-chevron-right"></i>
                            <a    class="active" href="javascript:void;">{{$service->{'name_'.$lang} }}
                            </a>
                        </div>
                        <!-- breadcrumb pagination area end -->
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- bread crumb area end -->

    <!-- blog details area start -->
    <div class="rts-blog-list-area rts-section-gap">
        <div class="container">
            <div class="row g-5">
                <!-- rts blo post area -->
                <div class="col-xl-8 col-md-12 col-sm-12 col-12">
                    <!-- single post -->
                    <div class="blog-single-post-listing details mb--0">
                        <div class="thumbnail">
                            <img src="{{ isset($service->img) ? Helper::uploadedImagesPath('services',$service->img) : Helper::imageFilesPath('noimage.png') }}" alt="{{$service->alt_img}}">
                        </div>
                        <div class="blog-listing-content">
                            <div class="user-info">
                                <!-- single info -->
                                @if($service->ServiceCat)
                                    <div class="single">
                                        <i class="far fa-tags"></i>
                                        <span>{{$service->ServiceCat->{'name_'.$lang} ?? '' }}</span>
                                    </div>
                                @endif
                                <!-- single infoe end -->
                            </div>
                            <h3 class="title animated fadeIn">{{$service->{'name_'.$lang} }}</h3>
                            <p class="disc para-1">{!! $service->{'text_'.$lang} !!}</p>
                        </div>
                    </div>
                    <!-- single post End-->
                </div>
                <!-- rts-blog post end area -->
                
                <!--rts blog wizered area -->
                <div class="col-xl-4 col-md-12 col-sm-12 col-12 rts-sticky-column-item">
                    <div class="blog-sidebar theiaStickySidebar">
                        <!-- single wizered start -->
                       {{-- @if(count($serviceCategories) > 0)
                            <div class="rts-single-wized Categories">
                                <div class="wized-header">
                                    <h5 class="title">
                                        @lang('home.categories')
                                    </h5>
                                </div>
                                <div class="wized-body">
                                    <!-- single categoris -->
                                        @foreach ($serviceCategories as $serviceCategory)
                                            <ul class="single-categories">
                                                <li><a    href="{{LaravelLocalization::localizeUrl('category/'.$serviceCategory->{'link_'.$lang}.'/services' )}}">{{$serviceCategory->{'name_'.$lang} }} <i class="far fa-long-arrow-right"></i></a></li>
                                            </ul>
                                        @endforeach
                                    <!-- single categoris End -->
                                </div>
                            </div>
                        @endif --}}
                        <!-- single wizered End -->
                        <!-- single wizered start -->
                        @if (count($services)>0)
                            <div class="rts-single-wized Recent-post">
                                <div class="wized-header">
                                    <h5 class="title">
                                        @lang('home.other_services')
                                    </h5>
                                </div>
                                <div class="wized-body">
                                    <!-- recent-post -->
                                    @foreach ($services as $service)
                                        <div class="recent-post-single">
                                            <div class="thumbnail">
                                                <a href="{{LaravelLocalization::localizeUrl('service/'.$service->{'link_'.$lang} )}}"><img src="{{ isset($service->img) ? Helper::uploadedImagesPath('services',$service->img) : Helper::imageFilesPath('noimage.png') }}" alt="service"></a>
                                            </div>
                                            <div class="content-area text-start">
                                                {{--<div class="user">
                                                    <i class="fal fa-clock"></i>
                                                    <span>{{ \Carbon\Carbon::parse($service->date)->format('F j, Y') }}</span>
                                                </div>--}}
                                                <a    class="post-title" href="{{LaravelLocalization::localizeUrl('service/'.$service->{'link_'.$lang} )}}">
                                                    <h6 class="title">{{$service->{'name_'.$lang} }}</h6>
                                                </a>
                                            </div>
                                        </div>
                                    @endforeach
                                    <!-- recent-post End -->
                                </div>
                            </div>
                            <!-- single wizered End -->
                        @endif
                        
                    </div>
                </div>
                <!-- rts- blog wizered end area -->
            </div>
        </div>
    </div>
    <!-- blog details area end -->


@endsection
