@if (count($webinars)>0)
    <!-- up coming events area start -->
    <div class="up-coming-events rts-section-gap">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="title-area-center-style">
                        <div class="pre-title">
                            <img src="{{Helper::imageFilesPath('banner/bulb.png')}}" alt="icon">
                            <span>@lang('home.webinars')</span>
                        </div>
                        <h2 class="title">@lang('home.Upcoming webinars') </h2>
                    </div>
                </div>
            </div>
            <div class="row mt--50">
                <div class="col-lg-12">
                    <!-- single up coming events -->
                    <div class="upcoming-events-main-wrapper-1">
                    
                        @foreach ($webinars as $webinar)
                            <!-- single -->
                            <div class="single-upcoming-events">
                                <div class="img-information">
                                    <a    href="{{ LaravelLocalization::localizeUrl('webinars/' . $webinar->{'link_' . $lang}) }}" class="thumbnail">
                                        <img src="{{ isset($webinar->image) ? Helper::uploadedImagesPath('webinars/source',$webinar->image) : Helper::imageFilesPath('noimage.png') }}" alt="events">
                                    </a>
                                    <div class="information">
                                        <div class="date-details">
                                            <div class="date">
                                                <i class="fa-thin fa-calendar-days"></i>
                                                <p> {{ \Carbon\Carbon::parse($webinar->start_date)->format('F j, Y') }} </p>

                                            </div>
                                            {{--<div class="time">
                                                <i class="fa-regular fa-clock"></i>
                                                <p> {{ \Carbon\Carbon::parse($webinar->start_date)->format('g:i a') }} </p>
                                            </div> --}}
                                            @if($webinar->type)
                                                <div class="single">
                                                    <i class="fa-light fa-clock"></i>
                                                    <span>{{ trans('home.' . $webinar->type) }}</span>
                                                </div>
                                            @endif
                                        
                                        </div>
                                        <a    href="{{ LaravelLocalization::localizeUrl('webinars/' . $webinar->{'link_' . $lang}) }}">
                                            <h5 class="title">{{$webinar->{'name_'.$lang } }}</h5>
                                        </a>
                                        <div class="bottom">
                                            <div class="left">
                                                <span>@lang('home.price')</span>
                                            </div>
                                            <a>
                                                {{ $webinar->price == 0 ? __('home.free') : $webinar->price . ' ' . __('home.SAR') }}
                                            </a>
                                        </div>
                                    </div>
                                </div>
                                <a href="{{ LaravelLocalization::localizeUrl('webinars/' . $webinar->{'link_' . $lang}) }}" class="rts-btn btn-primary with-arrow">@lang('home.explore') <i class="fa-light fa-arrow-right"></i></a>
                            </div>
                            <!-- single -->                            
                        @endforeach

                    </div>
                    <!-- single up coming events end -->
                </div>
            </div>

            <div class="d-flex justify-content-center mt-5">                         
                <a    href="{{Laravellocalization::localizeUrl('webinars')}}" class="rts-btn btn-primary">  @lang('home.show_all')  </a>
            </div>
        </div>
    </div>
    <!-- up coming events area end -->    
@endif