@extends('layouts.app')
@section('title')
    @php
        echo $metatags;
        echo $schema;
    @endphp
    <title>{{ app()->getLocale() == 'en' ? $course->name_en : $course->name_ar }}</title>
@endsection
@section('content')
 
 <!-- Start breadcrumb Area -->
    <div class="rbt-breadcrumb-default rbt-breadcrumb-style-3"> 
        <div class="breadcrumb-inner breadcrumb-dark">
            <img src="{{Helper::imageFilesPath('bg.png')}}" alt="Education Images">
        </div>
        <div class="container">
            <div class="row">
                <div class="col-lg-8">
                    <div class="content text-start">
                        <ul class="page-list">
                            <li class="rbt-breadcrumb-item"><a href="{{url('/'.$lang)}}">{{__('home.home')}}</a></li>
                            <li>
                                <div class="icon-right"><i class="feather-chevron-right"></i></div>
                            </li>
                            <li class="rbt-breadcrumb-item"><a href="{{url($lang.'/courses')}}">{{__('home.all_courses')}}</a></li>
                            <li>
                                <div class="icon-right"><i class="feather-chevron-right"></i></div>
                            </li>
                            <li class="rbt-breadcrumb-item active">{{__('home.course_details')}}</li>
                        </ul>
                        <h1 class="title">{{ $course->{'name_' . $lang} }}</h1>
                        <div class="d-flex  align-items-center  gap-5">
                        
                            <div class="feature-sin best-seller-badge d-block mb-2">
                                <!--<span class="rbt-badge-2">-->
                                <span>
                                   {{-- <span class="image">
                                        <img src="{{ Helper::imageFilesPath('icons/card-icon-1.png') }}" alt="Best Seller Icon">
                                    </span>
                                    --}}
                                    <i class="feather-award"></i>

                                    {{ __('home.certified_course') }}
                                </span>
                            </div>
                            <div class="feature-sin total-student d-block mb-2">
                                <span>
                                    <i class="feather-users"></i>
                                    {{  __('home.n_students') ." ".$student_num }}
                                </span>
                            </div>
                            <div class="feature-sin total-rating d-block mb-2">
                                 <span>
                                     <i class="feather-star"></i>

                                    {{   __('home.ratting') . " " . $roundedRate}}
                                </span>
                            </div>
                        
                            
                        
                        </div>
                        
                        <ul class="rbt-meta list-unstyled mt-3">
                            <li class="mb-2">
                                <i class="feather-calendar"></i>
                                {{ __('home.last_updated') . " " . $course->updated_at->format('m/Y') }}
                            </li>
                        </ul>
                       {{--
                       <div class="d-flex align-items-center mb--20 flex-wrap rbt-course-details-feature">
                            <div class="feature-sin best-seller-badge">
                                <span class="rbt-badge-2">
                                    <span class="image"><img src="{{Helper::imageFilesPath('icons/card-icon-1.png')}}"
                                                             alt="Best Seller Icon"></span> {{__('home.bestseller')}}
                                </span>
                            </div>


                            <div class="feature-sin total-rating">
                                <a class="rbt-badge-4" href="#">{{count($reviews) ." ". __('home.ratting')}} </a>
                            </div>
                            <div class="feature-sin total-student">
                                <span>{{ $student_num ." ". __('home.students')}}  </span>
                            </div>

                        </div>

                        <ul class="rbt-meta">
                                <li><i class="feather-calendar"></i>{{ __('home.last_updated')." " . $course->updated_at->format('m/Y') }}</li>
                            <li><i class="feather-award"></i>{{__('home.certified_course')}}</li>
                        </ul>
                        --}}
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- End Breadcrumb Area -->
        <div class="rbt-course-details-area ptb--60">
        <div class="container">
            <div class="row g-5">

                <div class="col-lg-8">
                    <div class="course-details-content">
                        <div class="rbt-course-feature-box rbt-shadow-box thuumbnail">
                            <img class="w-100" src="{{Helper::uploadedImagesPath('courses/source', $course->image)}}" alt="Card image">
                        </div>

                        <div id='tabss' class="rbt-inner-onepage-navigation   mt--30">
                            <nav class="mainmenu-nav onepagenav">
                                <ul class="nav nav-tabs mainmenu" id="nav-tab" role="tablist">
                                    <li>
                                        <a  class="nav-link active" id="nav-home-tab" data-bs-toggle="tab" data-bs-target="#nav-home" type="button" role="tab" aria-controls="nav-home" aria-selected="true">
                                            {{__('home.Overview')}}
                                        </a >
                                    </li>
                                    <li>
                                        <a class="nav-link" id="nav-contact-tab" data-bs-toggle="tab" data-bs-target="#nav-contact" type="button" role="tab" aria-controls="nav-contact" aria-selected="false">
                                            {{__('home.Details')}}
                                        </a >
                                    </li>
                                    <li>
                                        <a class="nav-link" id="nav-profile-tab" data-bs-toggle="tab" data-bs-target="#nav-profile" type="button" role="tab" aria-controls="nav-profile" aria-selected="false">
                                            {{__('home.Course Content')}}
                                        </a >
                                    </li>
                                    
                               </ul>
                               
                            </nav>
                        </div>
                        
                        
                        
                        
                        
                        <div class="tab-content" id="myTabContent">
                            
                          <div class="tab-pane fade show active" id="nav-home" role="tabpanel" aria-labelledby="nav-home-tab" tabindex="0">
                                <!-- Start Course Feature Box  -->
                                <div class="rbt-course-feature-box overview-wrapper rbt-shadow-box mt--30 has-show-more"
                                     id="overview">
                                    <div class="rbt-course-feature-inner has-show-more-inner-content">
                                        <div class="section-title">
                                            <h4 class="rbt-title-style-3">{{__('home.what_will_we_learn')}}</h4>
                                        </div>
                                        {!! $course->{'text_'.$lang} !!}
                                    </div>
                                    <div class="rbt-show-more-btn">{{__('home.show_more')}}</div>
                                </div>
                                <!-- End Course Feature Box  -->
                          
                          </div>
                          
                          
                          <div class="tab-pane fade" id="nav-profile" role="tabpanel" aria-labelledby="nav-profile-tab" tabindex="0">
                          
                               @if($course->course->chapters)
                                <!-- Start Course Content -->
                                <div class="course-content rbt-shadow-box coursecontent-wrapper mt--30" id="coursecontent">
                                    <div class="rbt-course-feature-inner">
                                        <div class="section-title">
                                            <h4 class="rbt-title-style-3">{{__('home.Course Content')}}</h4>
                                        </div>
                                        <div class="rbt-accordion-style rbt-accordion-02 accordion">
                                            <div class="accordion" id="accordionExampleb2">
                                                @foreach($course->course->chapters as $chapter)
                                                <div class="accordion-item card">
                                                    <h2 class="accordion-header card-header" id="headingTwo{{ $chapter->id }}">
                                                        <button class="accordion-button" type="button" data-bs-toggle="collapse"
                                                                data-bs-target="#collapseTwo{{ $chapter->id }}" aria-expanded="false"
                                                                aria-controls="collapseTwo{{ $chapter->id }}">
                                                            {{ $chapter->{'name_'.$lang} }} 
                                                            <span class="rbt-badge-5 ml--10">{{ $chapter->duration }} {{trans('home.hour')}}</span>
                                                        </button>
                                                    </h2>
                                                    <div id="collapseTwo{{ $chapter->id }}" class="accordion-collapse collapse"
                                                         aria-labelledby="headingTwo{{ $chapter->id }}" data-bs-parent="#accordionExampleb2">
                                                        <div class="accordion-body card-body pr--0">
                                                            <ul class="rbt-course-main-content liststyle">
                                                                @if($chapter->lessons)
                                                                @foreach($chapter->lessons as $lesson)
                                                                <li class="d-flex justify-content-between">
                                                                    @if($user) 
                                                                        <!-- User is authenticated and owns the course -->
                                                                        <a href="{{LaravelLocalization::localizeUrl('user/lesson/' . $lesson->{'link_' . $lang})}}">
                                                                            <div class="course-content-left">
                                                                                <i class="feather-play-circle"></i> 
                                                                                <span class="text">{{ $lesson->{'name_'.$lang} }}</span>
                                                                            </div>
                                                                            <div class="course-content-right">
                                                                                <span class="min-lable">{{ $lesson->duration }} min</span>
                                                                            </div>
                                                                        </a>
                                                                    @else
                                                                        <!-- User is not authenticated or does not own the course -->
                                                                        @if($lesson->free)
                                                                                <div class="course-content-left">
                                                                                    <i class="feather-play-circle"></i> 
                                                                                    <span class="text">{{ $lesson->{'name_'.$lang} }}</span>
                                                                                </div>
                                                                                <a href="{{ $lesson->{'content_link_' . $lang} }}" class="popup-video">
                                                                                    <div class="course-content-right">
                                                                                            <span class="min-lable">{{ $lesson->duration }} min</span>
                                                                                            <span class="rbt-badge variation-03 bg-primary-opacity">
                                                                                                <i class="feather-eye"></i> {{ __('home.preview') }}
                                                                                            </span>
                                                                                    </div>
                                                                                </a>
                                                                            
                                                                        @else
                                                                            <a href="javascript:void(0)" class="disabled w-100 d-flex justify-content-between">
                                                                                <div class="course-content-left">
                                                                                    <i class="feather-play-circle"></i> 
                                                                                    <span class="text">{{ $lesson->{'name_'.$lang} }}</span>
                                                                                </div>
                                                                                <div class="course-content-right">
                                                                                    <span class="course-lock">
                                                                                        <i class="feather-lock"></i>
                                                                                    </span>
                                                                                </div>
                                                                            </a>
                                                                        @endif
                                                                    @endif
                                                                </li>
                                                                @endforeach
                                                                @endif
                                                            </ul>
                                                        </div>
                                                    </div>
                                                </div>
                                                @endforeach
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!-- End Course Content -->
                                @endif
                          </div>
                          
                          
                          <div class="tab-pane fade" id="nav-contact" role="tabpanel" aria-labelledby="nav-contact-tab" tabindex="0">
                                @if($course->course_requirment_id && $course->course_requirments())
                                <!-- Start Course Feature Box  -->
                                <div class="rbt-course-feature-box rbt-shadow-box details-wrapper mt--30" id="details">
                                    <div class="row g-5">
                                        <!-- Start Feture Box  -->
                                        <div class="col-lg-6">
                                            <div class="section-title">
                                                <h4 class="rbt-title-style-3 mb--20">{{__('home.Requirements')}}</h4>
                                            </div>
                                            <ul class="rbt-list-style-1">
                                                @foreach($course->course_requirments() as $requirment)
                                                <li><i class="feather-check"></i>{{$requirment->{'text_'.$lang} }}</li>
                                                @endforeach
                                            </ul>
                                        </div>
                                        <!-- End Feture Box  -->
        
                                    </div>
                                </div>
                                <!-- End Course Feature Box  -->
                                @endif
                          
                          </div>
                          
                          
                        </div>
                        
                        
                        
                        
                        
                        


                        
                    </div>
                </div>

                <div class="col-lg-4">
                    
                    <div class="course-sidebar sticky-top rbt-shadow-box course-sidebar-top rbt-gradient-border">
                        
                         <!-- contact-form -->
                        <div class="course-side-bar mb-4">
                            
                            <div class="price-area  mt-1">
                                <h3 class="title">
                                    {{ trans('home.subscribe_course') }}
                                </h3>
                               
                            </div>
                           <form class='contact-page-form' method="POST" action="{{ route('save_course_subscriber_request') }}" id="course-subscribe-form">
                                @csrf
                                <div class="single-input mb-3">
                                    <input name="full_name" id="name" type="text" value="{{ old('full_name') }}" placeholder="{{ trans('home.name') }} *" required>
                                    @error('full_name')
                                        <div class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </div>
                                    @enderror
                                </div>
                                <div class="single-input mb-3">
                                    <input name="email" id="email" type="email" value="{{ old('email') }}" placeholder="{{ trans('home.email') }} *" required>
                                    @error('email')
                                        <div class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </div>
                                    @enderror
                                </div>
                                <div class="single-input mb-3">
                                    <input name="phone" id="phone" type="text" value="{{ old('phone') }}" minlength="10" placeholder="{{ trans('home.phone') }} *" required>
                                        @error('phone')
                                            <div class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </div>
                                        @enderror      
                                    </div>
                                <div class="single-input mb-3">
                                     <select class="form-select" name="qualification" id="qualification" type="text" required>
                                        <option value=''>{{ trans('home.qualification') }}</option>
                                        <option @selected(old('qualification') == 'university') value="university">{{trans('home.university')}}</option>
                                        <option @selected(old('qualification') == 'diploma') value="diploma">{{trans('home.diploma')}}</option>
                                        <option @selected(old('qualification') == 'secondary') value="secondary">{{trans('home.secondary')}}</option>
                                    </select>
                                    @error('qualification')
                                        <div class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </div>
                                    @enderror
                                </div>
                                
                                 <div class="single-input mb-3">
                                    <input name="job" id="job" type="text" value="{{ old('job') }}" placeholder="{{ trans('home.job') }}">
                                    @error('job')
                                        <div class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </div>
                                    @enderror  
                                </div>
                                <input type="hidden" name="training_id" value="{{ $course->id }}">
                            
                                <button type="submit" class="rbt-btn w-100 mt-4 mb-2 mx-auto contactUs">{{ trans('home.register_now') }}</button>
                                
                            </form>
                            <!-- <form class='contact-page-form' method="POST" action="" id="course-subscribe-form">-->
                                
                            <!--</form>-->
 
                        </div>
                        <!-- contact-form -->
                        
                        <div class="inner">

                            <!-- Start Viedo Wrapper  -->
                            <a class="video-popup-with-text video-popup-wrapper text-center popup-video sidebar-video-hidden mb--15"
                               href="{{$course->intro_link_video}}">
                                <div class="video-content">
                                    <img class="w-100 rbt-radius" src="{{Helper::imageFilesPath('others/image-07.jpg')}}"
                                         alt="Video Images">
                                </div>
                            </a>
                            <!-- End Viedo Wrapper  -->

                            <div class="content-item-content">
                                @if(!$user) 
                                <div
                                        class="rbt-price-wrapper d-flex flex-wrap align-items-center justify-content-between">
                                                    <div class="rbt-price">
                                                        @if ($course->discount)
                                                        <span class="off-price">
                                                        {{ $course->last_price() . ' ' . __('home.SAR') }}  
                                                    </span>
                                                        <span class="current-price">
                                                        {{ $course->price . ' ' . __('home.SAR') }} 
                                                    </span>
                                                        @if(isset($course->discount->end_date))
                                                        <div class="clock-area">
                                                            <i class="ms-1 fa-light fa-clock"></i>
                                                            @php
                                                            $end_date = \Carbon\Carbon::parse($course->discount->end_date);
                                                            $daysLeft = \Carbon\Carbon::now()->diffInDays($end_date);
                                                            @endphp
                                                            <span class="text-danger">{{ $daysLeft }} @lang('home.Day left at this price!')</span>
                                                        </div>
                                                        @endif
                                                        @else
                                                        <div class="current-price">
                                                            {{ $course->last_price() . ' ' . __('home.SAR') }}
                                                        </div>
                                                        @endif
                                                    </div>
                                </div>
                                <form method="POST" action="{{route('repare-checkout')}}">
                                    @csrf
                                <div class="buy-now-btn mt--15">
                                    <input type="hidden" name="course_id" value="{{$course->id}}">
                                    <ul>
                                      <li><input type="radio"   id="mada" required="" name="payment_method" value="mada"/>
                                        <label for="mada"><img src="{{ Helper::imageFilesPath('mada.svg ') }}" /></label>
                                      </li>
                                      <li><input type="radio"  id="visa" required="" name="payment_method" value="visa" />
                                        <label for="visa"><img src="{{ Helper::imageFilesPath('visa.svg ') }}" /></label>
                                      </li>
                                     
                                    </ul>
                                        <span class="subtitle"><i class="feather-rotate-ccw"></i>{{__('home.30-Day Money-Back Guarantee')}}</span>
                                    
                                   
                                   
                                    <button type="submit"  class="rbt-btn  mt-2 mb-2 mx-auto w-100 buyNow"> {{ trans('home.subscribe_now') }} </button>
                                </div>
                                </form>
                                @endif
                                {{--
                                <form action=" {{ $first_lesson ? LaravelLocalization::localizeUrl('user/lesson/'.$first_lesson->{'link_'.$lang}) :"" }}  ">
                                    <div class=" mt--15 mb--15">
                                        <input type="hidden" name="course_id" value="{{$course->id}}">
                                        <button type="submit"  class="rbt-btn btn-border icon-hover w-100 d-block text-center buyNow"> {{ trans('home.watch') }} </button>
                                    </div>
                                </form>
                                --}}
                                <div class="rbt-widget-details has-show-more">
                                    <ul class="has-show-more-inner-content rbt-course-details-list-wrapper">
                                        <li><span>{{__('home.hours')}}</span><span class="rbt-feature-value rbt-badge-5">{{$course->duration}}</span>
                                        </li>
                                        <li><span>{{__('home.enrolled')}}</span><span class="rbt-feature-value rbt-badge-5">{{ $student_num ." ". __('home.students')}} </span>
                                        </li>
                                        @if($course->level)
                                        <li><span>{{__('home.level')}}</span><span
                                                    class="rbt-feature-value rbt-badge-5">{{ $course->level->{'name_'.$lang} }}</span></li>
                                        @endif
                                            
                                        @if($course->course->chapters)
                                        <li>
                                            <span>{{__('home.chapters')}}</span>
                                            <span class="rbt-feature-value rbt-badge-5">
                                                {{ count($course->course->chapters) }}
                                                </span>
                                        </li>
                                        <li>
                                            <span>{{ __('home.total_lessons') }}</span>
                                            <span class="rbt-feature-value rbt-badge-5">
                                                {{ $course->course->chapters->sum(fn($chapter) => $chapter->lessons->count()) }}
                                            </span>
                                        </li>
                                        @endif
                                        
                                        <li>
                                            <span>{{__('home.exams')}}</span>
                                            <span class="rbt-feature-value rbt-badge-5">
                                                {{ $num_of_exam }}
                                            </span>
                                        </li>
                                                    
                                        <li>
                                            <span>{{__('home.certificate')}}</span>
                                            <span class="rbt-feature-value rbt-badge-5">
                                                {{__('home.yes')}}
                                            </span>
                                        </li>
                                  </ul>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    
      @if(count($related_courses) > 0)
    <!-- Start Similar Courses -->
    <div class="rbt-related-course-area bg-color-white pt--60 rbt-section-gapBottom">
        <div class="container">
            <div class="section-title mb--30">
                <span class="subtitle bg-primary-opacity">{{__('home.Related Courses')}}</span>
            </div>
            <div class="row g-5">
                @foreach($related_courses as $r_course)
                <!-- Start Single Card  -->
                <div class="col-lg-4 col-md-6 col-sm-6 col-12">
                    <div class="rbt-card variation-01 rbt-hover">
                        <div class="rbt-card-img">
                            <a    href="{{ LaravelLocalization::localizeUrl('course/' . $r_course->{'link_'.$lang}) }}" class="thumbnail">
                                <img src="{{ isset($r_course->image) ? Helper::uploadedImagesPath('courses/source', $r_course->image) : Helper::imageFilesPath('noimage.png') }}" alt="course">
                            </a>
                        </div>
                        <div class="rbt-card-body">
                            <div class="rbt-card-top">
                                <div class="rbt-review">
                                    
                                </div>
                                <div class="rbt-bookmark-btn">
                                    <a class="rbt-round-btn" title="Bookmark" href="#"><i
                                            class="feather-bookmark"></i></a>
                                </div>
                            </div>
        
                            <h4 class="rbt-card-title">
                                <a href="{{ LaravelLocalization::localizeUrl('course/' . $r_course->{'link_'.$lang} ) }}">
                                    <h5 class="title">{{ $r_course->{'name_' . $lang} }}</h5>
                                </a>
                            </h4>
        
                            <ul class="rbt-meta">
                                <li><i class="feather-book"></i>
                                    {{ $r_course->category->{'name_' . $lang} ?? '' }}
                                </li>
                            </ul>
                            <div class="rbt-card-bottom">
                                <div class="rbt-price">
                                    @if ($r_course->discount)
                                    <span class="off-price">
                                    {{ $r_course->last_price() . ' ' . __('home.SAR') }}  
                                </span>
                                    <span class="current-price">
                                    {{ $r_course->price . ' ' . __('home.SAR') }} 
                                </span>
                                    @if(isset($r_course->discount->end_date))
                                    <div class="clock-area">
                                        <i class="ms-1 fa-light fa-clock"></i>
                                        @php
                                        $end_date = \Carbon\Carbon::parse($r_course->discount->end_date);
                                        $daysLeft = \Carbon\Carbon::now()->diffInDays($end_date);
                                        @endphp
                                        <span class="text-danger">{{ $daysLeft }} @lang('home.Day left at this price!')</span>
                                    </div>
                                    @endif
                                    @else
                                    <div class="current-price">
                                        {{ $r_course->last_price() . ' ' . __('home.SAR') }}
                                    </div>
                                    @endif
                                </div>
                                <a class="rbt-btn-link" href="{{ LaravelLocalization::localizeUrl('course/' . $r_course->{'link_'.$lang}) }}">{{__('home.Learn_More')}}<i class="feather-arrow-right"></i></a>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- End Single Card  -->
                @endforeach


            </div>
        </div>
    </div>
    <!-- End Similar Courses -->
    @endif
    
    <div class="rbt-separator-mid">
        <div class="container">
            <hr class="rbt-separator m-0">
        </div>
    </div>
@endsection

