@extends('layouts.app')
@section('title')
    <title>{{ __('home.wishlist') }}</title>
@endsection
@section('content')
    <!-- dashboard banner area start -->
    <div class="dashboard-banner-area-wrapper">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="dashboard-banner-area-start bg_image">
                        <div class="author-profile-image-and-name">
                            <div class="profile-pic">
                                @if ($user->image)
                                    <img alt="{{ $user->name() }}"
                                        src="{{ URL::to('uploads/users/source') }}/{{ $user->image }}">
                                @else
                                    <img alt="avatar"
                                        src="{{ URL::To('resources/assets/back/img/noimage.png') }}">
                                @endif
                            </div>
                            <div class="name-desig">
                                <h1 class="title">{{ $user->name() }}</h1>
                                <div class="course-vedio">
                                    <div class="single">
                                        <i class="fa-light fa-envelope"></i>
                                        <span>{{ $user->email }}</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- dashboard banner area end -->
    <!-- rts dahboard-area-main-wrapper -->
    <div class="dashboard--area-main pt--100">
        <div class="container">
            <div class="row g-5">
                @include('userboard.partials.sideUserDashboard') 
                <div class="col-lg-9">
                    <div class="exrolled-course-wrapper-dashed">
                        <h5 class="title">@lang('home.wishlist')</h5>
                        <div class="row g-5">
                            @forelse ($wishlist as $my_course)
                                <div class="col-lg-4 col-md-6 col-sm-6 col-12">
                                    <!-- rts single course start -->
                                    <div class="rts-single-course">
                                        <a    href="single-course.html" class="thumbnail">
                                            <img src="{{ Helper::uploadedImagesPath('courses/source', $my_course->course->image) }}" alt="{{ $my_course->course->{'name_' . $lang} }}">
                                        
                                        </a>
                                        <div class="save-icon ">
                                            <a class="btnDelete_wishlist"  data-wishlist_id="{{ $my_course->id }}"><i class="fa-sharp fa-light fa-close"></i></a>
                                        </div>
                                        <div class="tags-area-wrapper">
                                            <div class="single-tag">
                                                <span>{{ $my_course->course->category->{'name_' . $lang} }}</span>
                                            </div>
                                        </div>
                                        <div class="lesson-studente">
                                            <div class="lesson">
                                                <i class="fa-light fa-calendar-lines-pen"></i>
                                                <span>{{ $my_course->course->course->countLessons() }} @lang('home.lessons')</span>
                                            </div>
                                        </div>
                                        <a    href="single-course.html">
                                            <h5 class="title">{{ $my_course->course->{'name_' . $lang} }}</h5>
                                        </a>
                                        <p class="teacher">
                                            @foreach ($my_course->course->teachers() as $teacher)
                                                <span class="teacher mx-2 col-auto">{{ $teacher->name }}</span>
                                                @if (!$loop->last)
                                                    /
                                                @endif
                                            @endforeach 
                                        </p>
                                        <div class="rating-and-price">
                                            <div class="rating-area">
                                                @if ($my_course->course->rate != 0)
                                                    <span >{{ $my_course->course->rate }}</span>
                                                @endif
                                                <div class="stars">
                                                    <ul>
                                                        <?php $rate = intval($my_course->course->rate); ?>
                                                        @for ($i = 1; $i <= $rate; $i++)
                                                            <li><i class="fa-sharp fa-solid fa-star"></i></li>
                                                        @endfor
                                                        @for ($i = 1; $i <= 5 - $rate; $i++)
                                                            <li><i class="fa-sharp fa-regular fa-star"></i></li>
                                                        @endfor
                                                    </ul>
                                                </div>
                                            </div>
                                            <div class="price-area">
                                                <div class="price">
                                                    {{ $my_course->course->last_price() == 0 ? __('home.free') : $my_course->course->last_price() . ' ' . __('home.SAR') }}
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- rts single course end -->
                                </div>
                            @empty
                                <div>
                                    
                                    <h5 class="title">@lang('home.empty_wishlist')</h5>
                                </div>
                            @endforelse
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- rts dahboard-area-main-wrapper end -->


    <div class="rts-section-gapTop">

    </div>
@endsection
@section('script')
    <Script>
        //btnDelete
        $(document).on('click', '.btnDelete_wishlist', function() {
            var wishlist_id = $(this).data('wishlist_id');
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                url: "{{ route('wishlistDelete') }}",
                method: 'POST',
                data: {
                    wishlist_id: wishlist_id
                },
                success: function() {
                    location.reload();
                },
            });
        });
    </script>
@endsection