@extends('layouts.app')
@section('title')
    <title>{{ __('home.settings') }}</title>
    <style>
        .form-control {
            background:#efefef !important;
        }
    </style>
@endsection
@section('content')
    <!-- dashboard banner area start -->
    <div class="dashboard-banner-area-wrapper">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="dashboard-banner-area-start bg_image">
                        <div class="author-profile-image-and-name">
                            <div class="profile-pic">
                                @if ($user->image)
                                    <img alt="{{ $user->name() }}"
                                        src="{{ URL::to('uploads/users/source') }}/{{ $user->image }}">
                                @else
                                    <img alt="avatar"
                                        src="{{ URL::To('resources/assets/back/images/users/avatar-1.jpg') }}">
                                @endif
                            </div>
                            <div class="name-desig">
                                <h1 class="title">{{ $user->name() }}</h1>
                                <div class="course-vedio">
                                    <div class="single">
                                        <i class="fa-light fa-envelope"></i>
                                        <span>{{ $user->email }}</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- dashboard banner area end -->
    <!-- rts dahboard-area-main-wrapper -->
    <div class="dashboard--area-main pt--100">
        <div class="container">
            <div class="row g-5">
                @include('userboard.partials.sideUserDashboard') 
                <div class="col-lg-9">
                    <div class="settings-wrapper-dashed">
                        <h5 class="title">@lang('home.settings')</h5>
                        @if(session()->has('success'))
                            <div class="alert alert-success alert-dismissible fade show" role="alert">
                                {{ session()->pull('success') }} <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                            </div>
                        @endif
                        @if($errors->any())
                            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                                <ul>
                                    @foreach($errors->all() as $error)
                                        <li>{{ $error }}</li>
                                    @endforeach
                                </ul>
                                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                            </div>
                        @endif
                        <ul class="nav nav-pills mb-3 tab-buttons" id="pills-tab" role="tablist">
                            <li class="nav-item" role="presentation">

                                <button class="nav-link active" id="pills-home-tab" data-bs-toggle="pill" data-bs-target="#pills-home"
                                    type="button" role="tab" aria-controls="pills-home" aria-selected="true">@lang('home.profile')</button>
                            </li>
                            <li class="nav-item" role="presentation">
                                <button class="nav-link" id="pills-profile-tab" data-bs-toggle="pill" data-bs-target="#pills-profile"
                                    type="button" role="tab" aria-controls="pills-profile" aria-selected="false">@lang('home.password')</button>
                            </li>
                        </ul>
                        <div class="tab-content" id="pills-tabContent">
                            <div class="tab-pane fade show active" id="pills-home" role="tabpanel" aria-labelledby="pills-home-tab">
                                <form method="POST" action="{{route('updateMyAccount')}}" enctype="multipart/form-data">
                                    @csrf
                                    <div class="social-profile-link-wrapper">
                                        <div class="row">
                                            <div class="col-sm-6 form-group mb-2">
                                                <label class='form-label'>@lang('home.email')</label>
                                                <input type="email" class='form-control'  disabled value="{{$user->email}}">
                                            </div>
                                            
                                            <div class="col-sm-6 form-group mb-2">
                                                <label class='form-label'>@lang('home.f_name')</label>
                                                 <input type="text" class='form-control' placeholder="@lang('home.f_name')" name="f_name" value="{{$user->f_name}}">
                                            </div>
                                            
                                            <div class="col-sm-6 form-group mb-2">
                                                <label class='form-label'>@lang('home.l_name')</label>
                                                 <input type="text" class='form-control' placeholder="@lang('home.l_name')" name="l_name" value="{{$user->l_name}}">

                                            </div>
                                            
                                            <div class="col-sm-6 form-group mb-2">
                                                <label class='form-label'>@lang('home.phone')</label>
                                                  <input type="tel" class='form-control' name="phone"  value="{{$user->phone}}">

                                            </div>
                                            
                                            <div class="col-sm-6 form-group mb-2">
                                                <label class='form-label'>@lang('home.address')</label>
                                                     <input type="tel" class='form-control' name="address"  value="{{$user->address}}">
                                            </div>
                                            
                                            <div class="col-sm-6 form-group mb-2">
                                                <label class='form-label'>@lang('home.image')</label>
                                                <input class='form-upload' type="file" name="image" >
                                                 @if ($user->image)
                                                    <img alt="{{ $user->name() }}"class="col-2 m-2"
                                                        src="{{ URL::to('uploads/users/source') }}/{{ $user->image }}">
                                                @else
                                                    <img alt="avatar" class="col-2 m-2"
                                                        src="{{ URL::To('resources/assets/back/images/users/avatar-1.jpg') }}">
                                                @endif
                                            </div>
                                    
                                        
                                 
                                     
                                         
                                         
                                               
                                      
                                        </div>


                                        <button type="submit" class="rts-btn btn-primary">@lang('home.update')</button>
                                    </div>
                                </form>
                            </div>
                            <div class="tab-pane fade" id="pills-profile" role="tabpanel" aria-labelledby="pills-profile-tab">
                                <div class="setting-change-password-area">
                                    <form method="POST" action="{{route('updateMyAccountPassword')}}" class="form-password-area" enctype="multipart/form-data">
                                        @csrf
                                        <div class="single-input">
                                            <label for="current">@lang('home.current_password')</label>
                                            <input id="current" type="password" name="current_password" placeholder="@lang('home.current_password')" required>
                                           
                                        </div>
                                        <div class="single-input">
                                            <label for="new">@lang('home.New Password')</label>
                                            <input id="new" type="password" name="newPassword" placeholder="@lang('home.New Password')" required>
                                           
                                        </div>
                                        <div class="single-input">
                                            <label for="Current">@lang('home.confirm_password')</label>
                                            <input type="password" name="newPassword_confirmation" placeholder="@lang('home.confirm_password')">
                                        </div>
                                        <button type="submit" class="rts-btn btn-primary">@lang('home.rest_password')</button>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- rts dahboard-area-main-wrapper end -->


    <div class="rts-section-gapTop">

    </div>
@endsection
