@extends('layouts.app')
@section('title')
    <title>{{ __('home.profile') }}</title>
@endsection
@section('content')
    <!-- dashboard banner area start -->
    <div class="dashboard-banner-area-wrapper">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="dashboard-banner-area-start bg_image">
                        <div class="author-profile-image-and-name">
                            <div class="profile-pic">
                                @if ($user->image)
                                    <img alt="{{ $user->name() }}"
                                        src="{{ URL::to('uploads/users/source') }}/{{ $user->image }}">
                                @else
                                    <img alt="avatar"
                                        src="{{ URL::To('resources/assets/back/images/users/avatar-1.jpg') }}">
                                @endif
                            </div>
                            <div class="name-desig">
                                <h1 class="title">{{ $user->name() }}</h1>
                                <div class="course-vedio">
                                    <div class="single">
                                        <i class="fa-light fa-envelope"></i>
                                        <span>{{ $user->email }}</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- dashboard banner area end -->
    <!-- rts dahboard-area-main-wrapper -->
    <div class="dashboard--area-main pt--100">
        <div class="container">
            <div class="row g-5">
                @include('userboard.partials.sideUserDashboard')

                <div class="col-lg-9  rts-sticky-column-item">
                    <div class="right-sidebar-my-profile-dash theiaStickySidebar pt--30">
                        <h5 class="title">@lang('home.my_account')</h5>
                        <!-- single My portfolio start-->
                        <div class="my-single-portfolio-dashed">
                            <div class="name">@lang('home.Registration Date')</div>
                            <div class="value">{{ $user->created_at->format('F d, Y g:i a') }}</div>
                        </div>
                        <!-- single My portfolio end-->
                        <!-- single My portfolio start-->
                        <div class="my-single-portfolio-dashed">
                            <div class="name">@lang('home.f_name')</div>
                            <div class="value">{{$user->f_name}}</div>
                        </div>
                        <!-- single My portfolio end-->
                        <!-- single My portfolio start-->
                        <div class="my-single-portfolio-dashed">
                            <div class="name">@lang('home.l_name'):</div>
                            <div class="value">{{$user->l_name}}</div>
                        </div>
                        <!-- single My portfolio end-->
                        <!-- single My portfolio start-->
                        <div class="my-single-portfolio-dashed">
                            <div class="name">@lang('home.email')</div>
                            <div class="value">{{$user->email}}</div>
                        </div>
                        <!-- single My portfolio end-->
                        <!-- single My portfolio start-->
                        <div class="my-single-portfolio-dashed">
                            <div class="name">@lang('home.phone')</div>
                            <div class="value">{{$user->phone}}</div>
                        </div>
                        
                        <div class="my-single-portfolio-dashed">
                            <div class="name">@lang('home.country')</div>
                            <div class="value">{{$user?->country?->{'name_'.$lang}  }}</div>
                        </div>
                        
                        <div class="my-single-portfolio-dashed">
                            <div class="name">@lang('home.area')</div>
                            <div class="value">{{$user?->area?->{'name_'.$lang}  }}</div>
                        </div>
                        
                        <div class="my-single-portfolio-dashed">
                            <div class="name">@lang('home.region')</div>
                            <div class="value">{{$user?->region?->{'name_'.$lang} }}</div>
                        </div>
                        <!-- single My portfolio end-->
                    </div>
                </div>

            </div>
        </div>
    </div>
    <!-- rts dahboard-area-main-wrapper end -->


    <div class="rts-section-gapTop">

    </div>
@endsection
