@extends('layouts.app')
@section('title')
    <title>{{ __('home.my_courses') }}</title>
@endsection
@section('content')
    <!-- dashboard banner area start -->
    <div class="dashboard-banner-area-wrapper">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="dashboard-banner-area-start bg_image">
                        <div class="author-profile-image-and-name">
                            <div class="profile-pic">
                                @if ($user->image)
                                    <img alt="{{ $user->name() }}"
                                        src="{{ URL::to('uploads/users/source') }}/{{ $user->image }}">
                                @else
                                    <img alt="avatar"
                                        src="{{ URL::To('resources/assets/back/img/noimage.png') }}">
                                @endif
                            </div>
                            <div class="name-desig">
                                <h1 class="title">{{ $user->name() }}</h1>
                                <div class="course-vedio">
                                    <div class="single">
                                        <i class="fa-light fa-envelope"></i>
                                        <span>{{ $user->email }}</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- dashboard banner area end -->
    <!-- rts dahboard-area-main-wrapper -->
    <div class="dashboard--area-main pt--100">
        <div class="container">
            <div class="row g-5">
                @include('userboard.partials.sideUserDashboard') 
                <div class="col-lg-9">
                    <div class="exrolled-course-wrapper-dashed">
                        <h5 class="title">{{ trans('home.my_courses') }}</h5>
                        <ul class="nav nav-tabs" id="myTab" role="tablist">
                            <li class="nav-item" role="presentation">
                                <button class="nav-link active" id="home-tab" data-bs-toggle="tab" data-bs-target="#home" type="button" role="tab" aria-controls="home" aria-selected="true">@lang('home.Enrolled Courses')</button>
                            </li>
                            <li class="nav-item" role="presentation">
                                <button class="nav-link" id="profile-tab" data-bs-toggle="tab" data-bs-target="#profile" type="button" role="tab" aria-controls="profile" aria-selected="false">@lang('home.Completed Courses')</button>
                            </li>
                        </ul>
                        <div class="tab-content mt--30" id="myTabContent">
                            <div class="tab-pane fade show active" id="home" role="tabpanel" aria-labelledby="home-tab">
                                <div class="row g-5">
                                    @forelse ($my_courses as $my_course)
                                        <div class="col-lg-4 col-md-6 col-sm-12 col-12">
                                            <!-- single course style two -->
                                            <div class="single-course-style-three enroll-course">
                                                <a    href="{{ LaravelLocalization::localizeUrl('user/course/' . $my_course->course->{'link_' . $lang}) }}" class="thumbnail">
                                                    <img src="{{ Helper::uploadedImagesPath('courses/source', $my_course->course?->image) }}" alt="{{ $my_course->course->{'name_' . $lang} }}">
                                                    <div class="tag-thumb">
                                                        <span>{{ $my_course->course->category->{'name_' . $lang} }}</span>
                                                    </div>
                                                </a>
                                                <div class="body-area">
                                                    <div class="course-top">
                                                        <div class="tags">{{ $my_course->course->type->{'name_' . $lang} }}</div>
                                                        <div class="price">
                                                            {{ $my_course->course->last_price() == 0 ? __('home.free') : $my_course->course->last_price() . ' ' . __('home.SAR') }}
                                                        </div>
                                                    </div>
                                                    <a    href="{{ LaravelLocalization::localizeUrl('user/course/' . $my_course->course->{'link_' . $lang}) }}">
                                                        <h5 class="title">{{ $my_course->course->{'name_' . $lang} }}</h5>
                                                    </a>
                                                    @if($my_course->course->teachers())
                                                        <div class="teacher-stars">
                                                            <div class="teacher">
                                                                @foreach ($my_course->course->teachers() as $teacher)
                                                                    <span class="teacher mx-2 col-auto">{{ $teacher->name }}</span>
                                                                    @if (!$loop->last)
                                                                        /
                                                                    @endif
                                                                @endforeach                                                            
                                                            </div>
                                                            <ul class="stars">
                                                                @if ($my_course->course->rate != 0)
                                                                    <span class="span">{{ $my_course->course->rate }}</span>
                                                                @endif
                                                                <?php $rate = intval($my_course->course->rate); ?>
                                                                @for ($i = 1; $i <= $rate; $i++)
                                                                    <li><i class="fa-sharp fa-solid fa-star"></i></li>
                                                                @endfor
                                                                @for ($i = 1; $i <= 5 - $rate; $i++)
                                                                    <li><i class="fa-sharp fa-regular fa-star"></i></li>
                                                                @endfor
                                                            </ul>
                                                        </div>
                                                    @endif
                                                    @if($my_course->course?->course?->countLessons())
                                                    <div class="leasson-students">
                                                        <div class="lesson">
                                                            <i class="fa-light fa-calendar-lines-pen"></i>
                                                            <span>{{ $my_course->course->course->countLessons() }} @lang('home.lessons')</span>
                                                        </div>
                                                    </div>
                                                    @endif
                                                    <div class="progress-wrapper-lesson-compleate">
                                                        <div class="compleate">
                                                            <div class="compl">
                                                                @lang('home.completed')
                                                            </div>
                                                            <div class="end">
                                                                <span>{{$my_course->progress}}%</span>
                                                            </div>
                                                        </div>
                                                        <div class="progress">
                                                            <div class="progress-bar wow fadeInLeft bg--primary" role="progressbar" style="width: {{$my_course->progress}}%" aria-valuenow="25" aria-valuemin="0" aria-valuemax="100">
                                                            </div>
                                                        </div>
                                                    </div>
                                                    @if($my_course->progress>=80 &&$my_course->course->my_certificate)
                                                        <a href="{{Helper::uploadedImagesPath('certificates',$my_course->course->my_certificate->path)}}" download class="rts-btn btn-border text-center">@lang('home.Download Certificate')</a>
                                                    @endif
                                                </div>
                                            </div>
                                            <!-- single course style two end -->
                                        </div>    
                                    @empty
                                        <div class="m-5 text-center"> {{__('home.empty_courses')}}</div>                            
                                    @endforelse
                                </div>
                            </div>
                            <div class="tab-pane fade" id="profile" role="tabpanel" aria-labelledby="profile-tab">
                                <div class="row g-5">
                                    @forelse($my_completed_courses as $my_completed_course)
                                        <div class="col-lg-4 col-md-6 col-sm-12 col-12">
                                            <!-- single course style two -->
                                            <div class="single-course-style-three enroll-course">
                                                <a    href="{{ LaravelLocalization::localizeUrl('user/course/' . $my_completed_course->course->{'link_' . $lang}) }}" class="thumbnail">
                                                    <img src="{{ Helper::uploadedImagesPath('courses', $my_completed_course->course->image) }}" alt="{{ $my_completed_course->course->{'name_' . $lang} }}">
                                                    <div class="tag-thumb">
                                                        <span>{{ $my_completed_course->course->category->{'name_' . $lang} }}</span>
                                                    </div>
                                                </a>
                                                <div class="body-area">
                                                    <div class="course-top">
                                                        <div class="tags">@lang('home.type'){{ ' : ' . $my_completed_course->course->type->{'name_' . $lang} }}</div>
                                                        <div class="price">
                                                            {{ $my_completed_course->course->last_price() == 0 ? __('home.free') : $my_completed_course->course->last_price() . ' ' . __('home.SAR') }}
                                                        </div>
                                                    </div>
                                                    <a    href="{{ LaravelLocalization::localizeUrl('user/course/' . $my_completed_course->course->{'link_' . $lang}) }}">
                                                        <h5 class="title">{{ $my_completed_course->course->{'name_' . $lang} }}</h5>
                                                    </a>
                                                    <div class="teacher-stars">
                                                        <div class="teacher">
                                                            @foreach ($my_completed_course->course->teachers() as $teacher)
                                                                <span class="teacher mx-2 col-auto">{{ $teacher->name }}</span>
                                                                @if (!$loop->last)
                                                                    /
                                                                @endif
                                                            @endforeach                                                            
                                                        </div>
                                                        <ul class="stars col-auto">
                                                            @if ($my_completed_course->course->rate != 0)
                                                                <span class="span">{{ $my_completed_course->course->rate }}</span>
                                                            @endif
                                                            <?php $rate = intval($my_completed_course->course->rate); ?>
                                                            @for ($i = 1; $i <= $rate; $i++)
                                                                <li><i class="fa-sharp fa-solid fa-star"></i></li>
                                                            @endfor
                                                            @for ($i = 1; $i <= 5 - $rate; $i++)
                                                                <li><i class="fa-sharp fa-regular fa-star"></i></li>
                                                            @endfor
                                                        </ul>
                                                    </div>
                                                    <div class="leasson-students">
                                                        <div class="lesson">
                                                            <i class="fa-light fa-calendar-lines-pen"></i>
                                                            <span>{{ $my_completed_course->course->countLessons() }} @lang('home.lessons')</span>
                                                        </div>
                                                    </div>
                                                    <div class="progress-wrapper-lesson-compleate">
                                                        <div class="compleate">
                                                            <div class="compl">
                                                                @lang('home.completed')
                                                            </div>
                                                            <div class="end">
                                                                <span>{{$my_completed_course->progress}}%</span>
                                                            </div>
                                                        </div>
                                                        <div class="progress">
                                                            <div class="progress-bar wow fadeInLeft bg--primary" role="progressbar" style="width: {{$my_completed_course->progress}}%" aria-valuenow="25" aria-valuemin="0" aria-valuemax="100">
                                                            </div>
                                                        </div>
                                                    </div>
                                                    @if ($my_completed_course->course->my_certificate)
                                                        <a href="{{Helper::uploadedImagesPath('certificates',$my_completed_course->course->my_certificate->path)}}" download class="rts-btn btn-border text-center">@lang('home.Download Certificate')</a>
                                                    @endif
                                                </div>
                                            </div>
                                                <!-- single course style two end -->
                                        </div>    
                                    @empty     
                                        <div class="m-5 text-center"> {{__('home.empty_courses')}}</div>                            
                                    @endforelse

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- rts dahboard-area-main-wrapper end -->


    <div class="rts-section-gapTop">

    </div>
@endsection


@section('script')
    @if(session()->has('success'))
        <script>
            Swal.fire({
                icon: 'success',
                title: '{{ session()->pull('success') }}'
            });
        </script>
    @endif
@endsection
