@extends('layouts.app')
@section('title')
    <title>{{ $course->{'name_'.$lang} }}</title>
@endsection
@section('content')
    <!-- rts lession details area start -->
    <div class="rts-lession-details-area-start">
        @if (isset($course_lesson))
            <div class="rts-lession-content-wrapper">
                <div class="rts-lession-left">
                    <!-- course content accordion area -->
                    <div class="course-content-wrapper-main">
                        <div class="accordion mt--30" id="accordionExample">

                            @foreach ($course->course->chapters as $chapter)
                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="headingOne">
                                        <button class="accordion-button @if($chapter->id!=$course_lesson->chapter_id) collapsed @endif" type="button" 
                                            data-bs-toggle="collapse" data-bs-target="#collapse_{{$chapter->id}}" aria-expanded="{{$chapter->id==$course_lesson->chapter_id? 'true':'false' }}" 
                                            aria-controls="collapse_{{$chapter->id}}">
                                            <span>{{$chapter->{'name_'.$lang} }}</span>
                                            <span>{{ $chapter->duration }}</span>
                                        </button>
                                    </h2>
                                    <div id="collapse_{{$chapter->id}}" class="accordion-collapse collapse @if($chapter->id==$course_lesson->chapter_id) show @endif" 
                                        aria-labelledby="headingOne" data-bs-parent="#accordionExample">
                                        <div class="accordion-body">
                                            @foreach ($chapter->lessons as $lesson)
                                            <!-- play single area start -->
                                            <a href="{{url('user/lesson/'.$lesson->{'link_'.$lang} )}}" class="play-vedio-wrapper">
                                                    <div class="left">
                                                        <i class="fa-light fa-circle-play"></i>
                                                        <span>{{$lesson->{'name_'.$lang} }}</span>
                                                    </div>
                                                    <div class="right">
                                                        <span>{{ $lesson->duration }}</span>
                                                    </div>
                                                </a>
                                                <!-- play single area end -->
                                                @foreach ($lesson->attachments as $attachment)
                                                    <!-- play single area start -->
                                                    <a href="{{Helper::uploadedImagesPath('attachments',$attachment->path )}}" 
                                                        download="{{ $attachment->{'name_'.$lang} }}.pdf"
                                                          class="play-vedio-wrapper">
                                                        <div class="left">
                                                            <i class="fa-light fa-download"></i>
                                                            <span>{{$attachment->{'name_'.$lang} }}</span>
                                                        </div>
                                                    </a>
                                                    <!-- play single area end -->
                                                @endforeach

                                            @endforeach
                                            @if ($chapter->exame)
                                                <a href="{{url('user/exame/'.$chapter->exame->id )}}" class="play-vedio-wrapper">
                                                    <div class="left">
                                                        <i class="fa-light fa-circle-question"></i>
                                                        <span>{{$chapter->exame->{'name_'.$lang} }}</span>
                                                    </div>
                                                    <div class="right">
                                                        <span>{{ $chapter->exame->duration }}</span>
                                                    </div>
                                                </a>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                            <div class="accordion-item">
                                <h2 class="accordion-header" id="headingOne">
                                    <button class="accordion-button collapsed" type="button" 
                                        data-bs-toggle="collapse" data-bs-target="#collapse_certificate" aria-expanded="false" 
                                        aria-controls="collapse_certificate">
                                        <span>@lang('home.certificate')</span>
                                    </button>
                                </h2>
                                <div id="collapse_certificate" class="accordion-collapse collapse" 
                                    aria-labelledby="headingOne" data-bs-parent="#accordionExample">
                                    <div class="accordion-body">
                                        
                                        @if ($order_course->progress==100)
                                            @if ($order_course->course->my_certificate)
                                                @if ($order_course->course->my_certificate->status==0)
                                                    <a>
                                                        <div class="left">
                                                            <i class="fa-light fa-download"></i>
                                                            <span>{{__('home.your certificate has been blocked') }}</span>
                                                        </div>
                                                    </a> 
                                                @else
                                                    <form method="post" action="{{route('getMyCertificate')}}">
                                                        @csrf
                                                        <input type="hidden" name="course_id" value="{{$course->id}}">
                                                        <button type="submit"  class="play-vedio-wrapper">
                                                            <div class="left">
                                                                <i class="fa-light fa-download"></i>
                                                                <span>{{__('home.certificate').' : '.$course->{'name_'.$lang} }}</span>
                                                            </div>
                                                        </button>
                                                    </form>
                                                @endif
                                            @else
                                                <form method="post" action="{{route('getMyCertificate')}}">
                                                    @csrf
                                                    <input type="hidden" name="course_id" value="{{$course->id}}">
                                                    <button type="submit"  class="play-vedio-wrapper">
                                                        <div class="left">
                                                            <i class="fa-light fa-download"></i>
                                                            <span>{{__('home.certificate').' : '.$course->{'name_'.$lang} }}</span>
                                                        </div>
                                                    </button>
                                                </form>
                                            @endif
                                        @else
                                            <a>
                                                <div class="left">
                                                    <i class="fa-light fa-download"></i>
                                                    <span>{{__('home.you have to pass 100 of the course') }}</span>
                                                </div>
                                            </a>    
                                        @endif                                           
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="mt-5">
                            <div class="progress" style="height: 3px;">
                                <div class="progress-bar" role="progressbar" aria-label="Example 1px high" style="width: {{$order_course->progress}}%;" aria-valuenow="25" aria-valuemin="0" aria-valuemax="100"></div>
                            </div>
                            <span>{{$order_course->progress.'/100' }}</span>
                        </div>  
                        <!-- course content accordion area end -->
                    </div>
                </div>
                <div class="rts-lession-right">
                    <div class="lesson-top-bar">
                        <div class="left-area">
                            <div class="toggle-class" id="toggle-left-back">
                                <i class="fa-light fa-chevron-left"></i>
                            </div>
                            <span>{{__('home.course').' | '.$course->course->{'name_'.$lang} }}</span>
                        </div>
                        <div class="right">
                            <a href="{{url('user/my-courses')}}"><i class="fa-solid fa-x"></i></a>
                        </div>
                    </div>
                    @if ($course?->type?->name_en=="Recorded")
                        {!! $course_lesson?->content_link_en !!}
                    @elseif ($course?->type?->name_en==="On Site")
                        <div class="row d-flex m-5 gap-5">
                            <h4 class="col-auto">@lang('home.address') : {{$course_lesson->{'content_link_'.$lang} }}</h4>
                            <h5 class="col-auto">@lang('home.duration') : {{$course_lesson->duration }}</h5>
                            <h5 class="col-auto">@lang('home.date') : {{$course_lesson->date }}</h5>
                            <h5 class="col-auto">@lang('home.time') : {{Carbon\Carbon::parse($course_lesson->time)->format('h:i A')}}</h5>
                        </div>                      
                    @elseif ($course?->type?->name_en==="Online")
                        <div class="text-center m-5">
                            <h4 class="col-auto">@lang('home.Meeting Link') : {{$course_lesson->{'content_link_'.$lang} }}</h4>
                            <h5 class="col-auto">@lang('home.duration') : {{$course_lesson->duration }}</h5>
                            <h5 class="col-auto">@lang('home.date') : {{$course_lesson->date }}</h5>
                            <h5 class="col-auto">@lang('home.time') : {{Carbon\Carbon::parse($course_lesson->time)->format('h:i A')}}</h5>
                        </div>
                    @endif
                    <div class="lesson-bottom-area">
                        <h2 class="title mb--10">{{$course_lesson->{'name_'.$lang} }}</h2>
                        <h5 class="title mb--10">@lang('home.details')</h5>
                        <p class="disc">{!! $course_lesson->{'text_'.$lang} !!}</p>
                    </div>
                    <div class="next-prev-area">
                        @if ($prev_lesson)
                        <a href="{{url('user/lesson/'.$prev_lesson->{'link_'.$lang} )}}">
                            <div class="prev">
                                <i class="fa-sharp fa-solid fa-play"></i>
                                @lang('home.prev')
                            </div>
                        </a>                        
                        @endif
                        @if ($next_lesson)
                            <a href="{{url('user/lesson/'.$next_lesson->{'link_'.$lang} )}}">
                                <div class="next">
                                    @lang('home.next')
                                    <i class="fa-sharp fa-solid fa-play"></i>
                                </div>
                            </a>
                        @endif
                    </div>
                </div>
        </div>
        @else
            <div class="row m-5 text-center justify-content-center">
                <h1>@lang('home.empty_course')</h1>
                <a href="{{url('user/my-courses')}}" class="rts-btn btn-border text-center">
                    @lang('home.my_courses')</a>
            </div>
        @endif
    </div>
    <!-- rts lession details area end -->
@endsection
@section('script')
<script src="https://player.vimeo.com/api/player.js"></script>
@if (isset($course_lesson))
<script>
    $(document).ready(function() {
        var actionFlag = true;
        var iframe = document.querySelector('iframe');
        
        var player = new Vimeo.Player(iframe);
        
        player.on('timeupdate', function(data) {
            var duration = data.duration;
            var currentTime = data.seconds;
            var percentPlayed = (currentTime / duration) * 100;
            
            if (percentPlayed >= 80 &&actionFlag) {
                actionFlag=false;
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });
                $.ajax({
                    url: "{{route('updateProgress') }}" ,
                    type: 'post',
                    data: {
                        course_lesson_id: '{{$course_lesson->id}}'
                    },
                    success: function(data) {
                        console.log(data);
                    }
                });
            }
        });
    });
</script>
@endif
    @endsection