@extends('layouts.app')
@section('title')
    <title>{{ __('home.dashboard') }}</title>
@endsection
@section('content')
    <!-- dashboard banner area start -->
    <div class="dashboard-banner-area-wrapper">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="dashboard-banner-area-start bg_image">
                        <div class="author-profile-image-and-name">
                            <div class="profile-pic">
                                @if ($user->image)
                                    <img alt="{{ $user->name() }}"
                                        src="{{ URL::to('uploads/users/source') }}/{{ $user->image }}">
                                @else
                                    <img alt="avatar"
                                        src="{{ URL::To('resources/assets/back/images/users/avatar-1.jpg') }}">
                                @endif
                            </div>
                            <div class="name-desig">
                                <h1 class="title">{{ $user->name() }}</h1>
                                <div class="course-vedio">
                                    <div class="single">
                                        <i class="fa-light fa-envelope"></i>
                                        <span>{{ $user->email }}</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- dashboard banner area end -->
    <!-- rts dahboard-area-main-wrapper -->
    <div class="dashboard--area-main pt--100">
        <div class="container">
            <div class="row g-5">
                @include('userboard.partials.sideUserDashboard') 
                <div class="col-lg-9">
                    <div class="right-sidebar-dashboard">
                        <div class="row g-5">
                            <div class="col-lg-4 col-md-6 col-sm-6 col-12">
                                <!-- single dashboard-card -->
                                <div class="single-dashboard-card">
                                    <div class="icon">
                                        <i class="fa-regular fa-graduation-cap"></i>
                                    </div>
                                    <h5 class="title"><span class="counter">{{count($my_courses)}}</span></h5>
                                    <p>@lang('HOME.Active Courses')</p>
                                </div>
                                <!-- single dashboard-card end -->
                            </div>
                            <div class="col-lg-4 col-md-6 col-sm-6 col-12">
                                <!-- single dashboard-card -->
                                <div class="single-dashboard-card">
                                    <div class="icon">
                                        <i class="fa-light fa-trophy"></i>
                                    </div>
                                    <h5 class="title"><span class="counter">{{count($my_completed_courses)}}</span></h5>
                                    <p>@lang('HOME.Completed Courses')</p>
                                </div>
                                <!-- single dashboard-card end -->
                            </div>
                        </div>


                        <div class="row mt--40">
                            <div class="col-lg-12">
                                <!-- in progress course area -->
                                <div class="in-progress-course-wrapper">
                                    <h5 class="title">@lang('home.In Progress Courses')</h5>
                                </div>
                                <!-- in progress course area end -->

                                @foreach ($my_courses as $my_course)
                                    <!-- single progress area start -->
                                    <div class="single-progress-course">
                                        <a    href="{{ LaravelLocalization::localizeUrl('user/course/' . $my_course->course->{'link_' . $lang}) }}" class="thumbnail">
                                            <img src="{{ Helper::uploadedImagesPath('courses', $my_course->course->image) }}" alt="{{$my_course->course->{'name_'.$lang} }}">
                                        </a>
                                        <div class="information-progress-course">
                                            <div class="rating-area">
                                                <?php $rate = intval($my_course->course->rate); ?>
                                                @for ($i = 1; $i <= $rate; $i++)
                                                    <i class="fa-solid fa-star"></i>
                                                @endfor
                                                @for ($i = 1; $i <= 5 - $rate; $i++)
                                                    <i class="fa-light fa-star"></i>
                                                @endfor
                                                @if ($my_course->course->rate != 0)
                                                    <span>({{ $my_course->course->rate }})</span>
                                                @endif
                                            </div>
                                            <a    href="{{ LaravelLocalization::localizeUrl('user/course/' . $my_course->course->{'link_' . $lang}) }}">
                                                <h5 class="title">{{$my_course->course->{'name_'.$lang} }}</h5>
                                            </a>
                                            <?php $countHistory = $my_course->course->countHistoryLessons($user->id)?>
                                            <?php $countLessons = $my_course->course->countLessons()?>
                                            <span class="comp"> @lang('home.Completed Lessons'):  {{$countHistory}} of {{$countLessons}} @lang('home.lesson')</span>
                                            <div class="progress-wrapper-lesson-compleate">
                                                <div class="progress">
                                                    <div class="progress-bar wow fadeInLeft bg--primary" role="progressbar" style="width: {{$my_course->progress}}%" aria-valuenow="25" aria-valuemin="0" aria-valuemax="100">
                                                    </div>
                                                </div>
                                                <div class="end">
                                                    <span>{{$my_course->progress}}% @lang('home.completed')</span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- single progress area end -->                                    
                                @endforeach

                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- rts dahboard-area-main-wrapper end -->


    <div class="rts-section-gapTop">

    </div>
@endsection
