@extends('layouts.app')
@section('title')
    <title>{{ __('home.certificates') }}</title>
@endsection
@section('content')
    <!-- dashboard banner area start -->
    <div class="dashboard-banner-area-wrapper">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="dashboard-banner-area-start bg_image">
                        <div class="author-profile-image-and-name">
                            <div class="profile-pic">
                                @if ($user->image)
                                    <img alt="{{ $user->name() }}"
                                        src="{{ URL::to('uploads/users/source') }}/{{ $user->image }}">
                                @else
                                    <img alt="avatar"
                                        src="{{ URL::To('resources/assets/back/images/users/avatar-1.jpg') }}">
                                @endif
                            </div>
                            <div class="name-desig">
                                <h1 class="title">{{ $user->name() }}</h1>
                                <div class="course-vedio">
                                    <div class="single">
                                        <i class="fa-light fa-envelope"></i>
                                        <span>{{ $user->email }}</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- dashboard banner area end -->
    <!-- rts dahboard-area-main-wrapper -->
    <div class="dashboard--area-main pt--100">
        <div class="container">
            <div class="row g-5">
                @include('userboard.partials.sideUserDashboard') 
                <div class="col-lg-9">
                    <div class="certificates-wrapper-dashed">
                        <h5 class="title mt--30">@lang('home.All Certificate')</h5>
                        <div class="all-certificates-main-wrapper-dashed mt--25">
                            @foreach ($courses as $course)
                                @if ($course->course->my_certificate)
                                    <!-- single certificates- -->
                                    <div class="d-flex justify-content-between align-items-center">
                                        <span class="m-5">{{ $course->course->{'name_'.$lang} }}</span>
                                        <span class="m-5">{{ $course->course->my_certificate->certificate_code }}</span>
                                        <form class="m-5" method="post" id="form_generate" action="{{ route('getMyCertificate') }}">
                                            @csrf
                                            <input type="hidden" name="course_id" value="{{ $course->course->id }}">
                                            <a href="javascript:void(0)" onclick="document.getElementById('form_generate').submit();" class="play-vedio-wrapper">
                                                <i class="fa-light fa-download"></i>
                                                <span>{{ __('home.certificate') }}</span>
                                            </a>
                                        </form>
                                    </div>                                
                                @endif
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- rts dahboard-area-main-wrapper end -->

    <div class="rts-section-gapTop">

    </div>
@endsection
