@extends('layouts.admin')

@section('meta')
<title>{{$training->{'name_'.$lang} }}</title>
@endsection
@section('style')
<style>
    @import url('https://fonts.googleapis.com/css2?family=Montserrat&display=swap');
        
        *{
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
 
        .container_auestions{
            background-color: #555;
            color: #ddd;
            border-radius: 10px;
            padding: 20px;
            font-family: 'Montserrat', sans-serif;
        }
        .container_auestions > p{
            font-size: 32px;
        }
        .options{
            position: relative;
            padding-left: 40px;
        }
        #options label{
            display: block;
            margin-bottom: 15px;
            font-size: 14px;
            cursor: pointer;
        }
        .options input{
            opacity: 0;
        }
        .checkmark {
            position: absolute;
            top: -1px;
            left: 2;
            height: 25px;
            width: 25px;
            background-color: #555;
            border: 1px solid #ddd;
            border-radius: 50%;
        }
        .options input:checked ~ .checkmark:after {
            display: block;
        }
        .options .checkmark:after{
            content: "";
        	width: 10px;
            height: 10px;
            display: block;
        	background: white;
            position: absolute;
            top: 50%;
        	left: 50%;
            border-radius: 50%;
            transform: translate(-50%,-50%) scale(0);
            transition: 300ms ease-in-out 0s;
        }
        .options input[type="radio"]:checked ~ .checkmark{
            background: #21bf73;
            transition: 300ms ease-in-out 0s;
        }
        .options input[type="radio"]:checked ~ .checkmark:after{
            transform: translate(-50%,-50%) scale(1);
        }
        .btn-primary{
            background-color: #555;
            color: #ddd;
            border: 1px solid #ddd;
        }
        .btn-primary:hover{
            background-color: #21bf73;
            border: 1px solid #21bf73;
        }
        .btn-success{
            padding: 5px 25px;
            background-color: #21bf73;
        }
        @media(max-width:576px){
            .question{
                width: 100%;
                word-spacing: 2px;
            } 
        }
</style>
@endsection
@section('content')

<div class="container-fluid">

    <!-- Page Header -->

    <!-- End Page Header -->

    <!-- Row-->
    <div class="row mt-5">
        <div class="col-sm-12 col-xl-12 col-lg-12">
            <div class="card custom-card">
                <div class="card-body">
                     <h2 class="main-content-title tx-24 mg-b-5">{{trans('home.welcome').' '.auth()->user()->name()}}</h2>

                    <div class="text-center">
                        <h4 class="m-auto">{{__('home.training_info')}}</h4>
                    </div>
                    <div class="text-center">
                        <h4 class="m-auto">{{$training->{'name_'.$lang} }}</h4>
                    </div>
                </div>
            </div>
        </div>
    </div> 
    <div class="col-12">
		<div class="card custom-card main-content-body-profile">
            <nav class="nav main-nav-line m-auto">
                <a class="nav-link active" id="courses-tab" data-toggle="tab" href="#courses" role="tab" aria-controls="courses" aria-selected="true">{{__('home.course')}}</a>
                <a class="nav-link" id="scan_qrCode-tab" data-toggle="tab" href="#scan_qrCode" role="tab" aria-controls="scan_qrCode" aria-selected="false">{{__('home.attendances')}}</a>
                <a class="nav-link" id="details-tab" data-toggle="tab" href="#details" role="tab" aria-controls="details" aria-selected="false">{{__('home.training_info')}}</a>
                <a class="nav-link" id="online_meeting-tab" data-toggle="tab" href="#online_meeting" role="tab" aria-controls="online_meeting" aria-selected="false">{{__('home.meeting_url')}}</a>
                @if($training->view_exam==date('Y-m-d'))
                    <a class="nav-link" id="exame-tab" data-toggle="tab" href="#exame" role="tab" aria-controls="exame" aria-selected="false">{{__('home.exames')}}</a>
                @endif
            </nav>
              <div class="tab-content " id="myTabContent">
                    <div class="tab-pane fade show active" id="courses" role="tabpanel" aria-labelledby="courses-tab">
                        <div class="card-deck m-5">
                            @foreach($training->courses as $course)
                            <div class="card rounded col-3">
                                <img class="card-img-top"  src="{{Helper::uploadedImagesPath('courses/images',$course->course_info->image)}}" alt="{{$course->course_info->alt_img}}">
                                <div class="card-body">
                                    <h5 class="card-title">{{$course->course_info->{'name_'.$lang} }}</h5>
                                    <p class="card-text">
                                        @php
                                        $text = strip_tags($course->course_info->{'text_'.$lang});
                                        $text = mb_substr($text, 0, 100);
                                        $text = preg_replace('/<br>/', '', $text);
                                        echo $text . " ... ";
                                        @endphp
                                    </p>
                                    <a href="{{route('watch_course',$course->course_info->id)}}" class="btn btn-primary">{{__('home.watch_course')}}</a>
                                </div>
                            </div>
                            @endforeach
                        </div>
                    </div>
                    <div class="tab-pane fade" id="scan_qrCode" role="tabpanel" aria-labelledby="scan_qrCode-tab">
                        <div class="modal-body">
                            <div class="table-responsive">
                                    <table class="table" id="exportexample">
                                        <thead>
                                            <tr>
                                                <th>{{ trans('home.name') }}</th>
                                                <th >{{ trans('home.training') }}</th>
                                                <th >{{ trans('home.attendance_date') }}</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach($attendances as $attendance)
                                                <tr>
                                                    <td> {{ $attendance->user->name() }}  </td>
                                                    <td> {{ $attendance->training->{'name_'.$lang} }}  </td>
                                                    <td> {{\Carbon\Carbon::parse($attendance->created_at)->format("d / m / Y")  }}</td>
                                                 
                                                </tr>
                                            @endforeach
                        
                                        </tbody>
                                    </table>
                        	    </div>
                          </div>
                    </div>
                    <div class="tab-pane fade  text-center" id="details" role="tabpanel" aria-labelledby="details-tab">
                        <!-- Content for Tab 3 -->
                       <div class="row mb-5">
                            <div class="m-5 col-md-5">
                                <div class="row justify-content-center">
                                    <div class="col-md-12">
                                        <h3>{{$training->{'name_'.$lang} }}</h3>
                                    </div>
                                </div>
                                <hr>
                                <div class="row justify-content-center">
                                    <div class="col-md-12">
                                        <p>{{__('home.training_info')}}</p>
                                        <h3>{!! $training->{'text_'.$lang} !!}</h3>
                                        @if($training->trainings_schaduals->center)
                                        <h3>{{ __('home.center').' : '.$training->trainings_schaduals->center->{'name_'.$lang} }}</h3>
                                        @endif
                                        <h3>{{ __('home.timing_type').' : '.$training->timing_type }}</h3>
                                        <h3>{{ __('home.training_type').' : '.$training->training_type }}</h3>
                                        <h3>{{ __('home.from').' : '.$training->time_from.'  '. __('home.to').' : '.$training->time_to  }}</h3>
                                    </div>
                                </div>
                            </div>
                            <div class="m-5 col-md-5 d-flex justify-content-center align-items-center">
                                <img class="card-img-top" src="{{Helper::uploadedImagesPath('trainings',$training->image)}}" alt="{{$training->alt_img}}">
                            </div>
                        </div>

                        
                    </div>
                    <div class="tab-pane fade text-center" id="online_meeting" role="tabpanel" aria-labelledby="online_meeting-tab">
                        <!-- Content for Tab 3 -->
                        @if($training->online_url)
                        <div class="text-center m-5">
                            <h3>{{__('home.meeting_url') }}</h3>
                            <a href="{{$training->online_url}}">  <i class="fas fa-video fa-5x"></i> </a>
                        </div>
                        @endif
                    </div>
                    @if($training->view_exam==date('Y-m-d'))
                        <div class="tab-pane fade text-center" id="exame" role="tabpanel" aria-labelledby="exame-tab">
                            <form method="POST" action="{{route('submit_exame')}}">
                                @csrf
                                <input type="hidden" name="exame_id" value="{{$exame->id}}">
                                <div class="container_auestions mx-5 my-5">
                                    <div class="py-2 h5">
                                        <b>{{$exame->{'name_'.$lang} }}</b>
                                        <hr>
                                    </div>
                                <div class="question pt-2 m-auto">
                                    @foreach($exame_questions as $index => $exame_question)
                                        <div class="py-2 h5"><b>{{($index + 1).' - '}} {{$exame_question->{'question_'.$lang} }}</b></div>
                                        <input type="hidden" name="questions[]" value="{{$exame_question->id}}">
                                        
                                        <div class="ml-md-3 ml-sm-3 pl-md-5 pt-sm-0 pt-3 form-check-inline" id="options">
                                            @foreach($exame_question->answers as $answer)
                                                <label class="options">{{$answer->{'answer_'.$lang} }}
                                                    <input type="radio" name="answers[{{$exame_question->id}}]" value="{{$answer->id}}">
                                                    <span class="checkmark"></span>
                                                </label>
                                            @endforeach
                                        </div>
                                    @endforeach
                                </div>
                                <div class=" pt-3 m-auto">
                                        <button class="submit btn btn-primary">{{__('home.submit_exame')}}</button>
                                </div>
                            </div>
                            </form>
                            

                        </div>
                    @endif
                </div>

            
        </div>
    </div>
   
</div>
@endsection
