@extends('layouts.app')
@section('meta')
<title>{{trans('home.welcome').' '.auth()->user()->name() }}</title>
@endsection

@section('content')
  <!--================= back wrapper Start Here =================-->
<div class="back-wrapper">
    <div class="back-wrapper-inner">
        <!--================= Back Breadcrumbs Section Start Here =================-->
        <div class="back-breadcrumbs">
            <div class="breadcrumbs-wrap">
                <img class="desktop" src="{{ Helper::imageFilesPath('breadcrumbs/1.png')}}" alt="Breadcrumbs">
                <img class="mobile" src="{{ Helper::imageFilesPath('breadcrumbs/1.png')}}" alt="Breadcrumbs">
                <div class="breadcrumbs-inner">
                    <div class="container">
                        <div class="breadcrumbs-text">
                            <h1 class="breadcrumbs-title">{{ auth()->user()->name() }} </h1>
                            <div class="back-nav">
                                <ul>
                                    <li>
                                        <a href="{{LaravelLocalization::localizeUrl('/')}}">{{trans('home.home')}}</a>
                                    </li>
                                    <li>{{trans('home.welcome').' '.auth()->user()->name() }} </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="profile-top pt-20 pb-90 md-pt-80 md-pb-50">
        <div class="container-fluid">
                @if(Session::has('accepted_request'))
                    <div class="alert alert-success d-flex align-items-center">
                        <div class="col text-center">
                            <span> {{ session()->pull('accepted_request') }}</span>
                        </div>
                        <div class="col-auto">
                            <a data-bs-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">×</span>
                            </a>
                        </div>
                    </div>
                @endif
          <div class="row">
            <div class="col-12 pl-50 md-pl-15 md-mt-60 back-courses__single-page">
              <div class="course-single-tab">
                <!-- main tabs wrapper  -->

                <!-- main tabs lists  -->
                <ul class="nav nav-tabs" id="back-tab" role="tablist">
                  <li class="nav-item w-50" role="presentation">
                    <a class="nav-link active" id="curriculums" data-bs-toggle="tab" href="#curriculum" role="tab" aria-controls="curriculum" aria-selected="true">
                      <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-book">
                        <path d="M4 19.5A2.5 2.5 0 0 1 6.5 17H20"></path>
                        <path d="M6.5 2H20v20H6.5A2.5 2.5 0 0 1 4 19.5v-15A2.5 2.5 0 0 1 6.5 2z"></path>
                      </svg>
                      {{__('home.my_trainings')}}
                    </a>
                  </li>
                  <li class="nav-item w-50" role="presentation">
                    <a class="nav-link" id="members" data-bs-toggle="tab" href="#member" role="tab" aria-controls="member" aria-selected="false" tabindex="-1">
                      <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-user">
                        <path d="M20 21v-2a4 4 0 0 0-4-4H8a4 4 0 0 0-4 4v2"></path>
                        <circle cx="12" cy="7" r="4"></circle>
                      </svg>
                      {{__('home.edit_profile') }}
                    </a>
                  </li>
                </ul>
                <!-- main tabs lists  -->

                <!-- main tabs content  -->
                <div class="tab-content" id="back-courses-tab-content">
                  <div class="tab-pane fade show active" id="curriculum" role="tabpanel" aria-labelledby="curriculum">
                    <div class="row align-items-start">
                      <!-- secound tabs content  -->
                      <div class="col-lg-3 col-sm-12">
                        <!-- secound tabs list  -->
                        <ul class="nav nav-tabs mt-0" id="back-tab-2" role="tablist">
                          @foreach($trainings as $training_index=>$training)
                          <li class="nav-item w-100" role="presentation">
                            <a class="nav-link @if($training_index==0) active @endif" id="course_name_1" data-bs-toggle="tab" href="#course_id_{{$training_index}}" role="tab" aria-controls="course_id_{{$training_index}}" aria-selected="true">
                              {{$training->{'name_'.$lang} }}
                                @if($training->trainings_schaduals->start_date)
                                    <p class="m-0">{{\Carbon\Carbon::parse($training->trainings_schaduals->start_date)->format("d / m / Y") .' - '.\Carbon\Carbon::parse($training->trainings_schaduals->end_date)->format("d / m / Y")   }}</p>
                                @endif
                                @if(isset($instructorsInfo[$training->id]->user))
                                <p class="m-0">{{__('home.instructor').' : '.$instructorsInfo[$training->id]->user->name()}}</p>
                                @endif
                              
                            </a>
                          </li>
                          @endforeach
                          
                        </ul>
                        <!-- secound tabs list  --> 

                      </div>
                  
                      <div class="col-lg-9 col-sm-12">
                        <!-- secound tabs content  -->
                        <div class="tab-content" id="back-tab-content">
                        @foreach($trainings as $training_index_div=>$training)
                              <div class="tab-pane fade @if($training_index_div==0) active show @endif" role="tabpanel" aria-labelledby="course_id_{{$training_index_div}}" id="course_id_{{$training_index_div}}">
                       
                            <!-- third tabs content  -->
                            <ul class="nav nav-tabs mt-0" id="back-tab-2" role="tablist">
                              <li class="nav-item" role="presentation">
                                <a class="nav-link active" id="course_name_curriculum{{$training_index_div}}" data-bs-toggle="tab" href="#course_id_curriculum{{$training_index_div}}" role="tab" aria-controls="course_id_curriculum{{$training_index_div}}" aria-selected="true">
                                  {{__('home.training_content')}}
                                </a>
                              </li>
                              @if($training->exame)
                              <li class="nav-item" role="presentation">
                                <a class="nav-link" id="course_name_faq{{$training_index_div}}" data-bs-toggle="tab" href="#course_id_faq{{$training_index_div}}" role="tab" aria-controls="course_id_faq{{$training_index_div}}" aria-selected="false" tabindex="-1">
                                {{__('home.questions')}}
                                </a>
                              </li>
                              @endif
                              <li class="nav-item" role="presentation">
                                <a class="nav-link" id="ul_attendance_{{$training_index_div}}" data-bs-toggle="tab" href="#attendance_{{$training_index_div}}" role="tab" aria-controls="attendance_{{$training_index_div}}" aria-selected="false" tabindex="-1">
                                {{__('home.attendances_record')}}
                                </a>
                              </li>
                              @if($training->exame)
                                @if(count($training->exame->exame_results )>=$training->exame->n_try)
                                    <li class="nav-item" role="presentation">
                                        <a class="nav-link" id="course_name_quiz{{$training_index_div}}" data-bs-toggle="tab" href="#course_id_quiz{{$training_index_div}}" role="tab" aria-controls="course_id_quiz{{$training_index_div}}" aria-selected="false" tabindex="-1">
                                         {{__('home.exame_result')}}
                                        </a>
                                    </li>
                                @elseif($training->view_exam==\Carbon\Carbon::now()->toDateString() && $training->exame->questions)
                                      <li class="nav-item" role="presentation">
                                        <a class="nav-link" id="course_name_quiz{{$training_index_div}}" data-bs-toggle="tab" href="#course_id_quiz{{$training_index_div}}" role="tab" aria-controls="course_id_quiz{{$training_index_div}}" aria-selected="false" tabindex="-1">
                                         {{__('home.exame')}}
                                        </a>
                                      </li>
                                @endif
                              @endif
                                @if($training->trainingSurvey)
                                    @if($training->view_survey<=\Carbon\Carbon::now()->toDateString() && count($training->trainingSurvey->survey->survayResult)==0) <li class="nav-item" role="presentation">
                                        <a class="nav-link" id="survey{{$training_index_div}}" data-bs-toggle="tab" href="#survey_div_{{$training_index_div}}" role="tab" aria-controls="survey_div_{{$training_index_div}}" aria-selected="false" tabindex="-1">
                                         {{__('home.survey')}}
                                        </a>
                                      </li>
                                    @endif
                                @endif

                            @if($training->exame || $training->trainingSurvey)
                                
                                  @if((count($training->exame->exame_results ?? [])> 0)  && ($training->exame->exame_results->pluck('result')->max()>=$training->exame->success_rate))
                                        @if($training->am_student->student_view_certificate==0)
                                            <?php $view_certification = 2 ; ?>
                                        @else
                                            @if( ((count($training->training_attendance) / $training->overall_days) * 100 ) < 60 )
                                                <?php $view_certification = 3 ;?>
                                            @else
                                                <?php $view_certification = 1 ;?>
                                            @endif
                                        @endif
                                        @if($training->exame->exame_results)
                                          @elseif((count($training->exame->exame_results ?? []) == 0)  && ($training->exame->exame_results->pluck('result')->max() < $training->exame->success_rate))
                                            <?php $view_certification = 4 ; ?>
                                        @endif
                                  @elseif(count($training->trainingSurvey->survey->survayResult) > 0)
                                      
                                        @if($training->am_student->student_view_certificate==0)
                                            <?php $view_certification = 2 ;?>
                                        @else
                                            @if( ((count($training->training_attendance) / $training->overall_days) * 100 ) < 60 )
                                                <?php $view_certification = 3 ;?>
                                            @else
                                                @if(now() >= Carbon\Carbon::parse($training->trainings_schaduals->end_date))
                                                    <?php $view_certification = 1 ;?> 
                                                @else
                                                    <?php $view_certification = 6 ;?> 
                                                @endif
                                            @endif
                                        @endif
                                  @elseif(count($training->trainingSurvey->survey->survayResult) == 0)
                                    <?php $view_certification = 5 ; ?>
                                  @else
                                    <?php $view_certification = 0 ;?>
                                  @endif
                              
                              <li class="nav-item" role="presentation">
                                  @if($view_certification == 1)
                                    <a class="nav-link" 
                                       id="course_name_certificate{{$training_index_div}}" 
                                       data-bs-toggle="tab" 
                                        href="#course_id_certificate{{$training_index_div}}"
                                       role="tab" 
                                       aria-controls="course_id_certificate{{$training_index_div}}" 
                                       aria-selected="false" 
                                       tabindex="-1">
                                        {{__('home.certificate')}} 
                                    </a>
                                   @elseif($view_certification == 2)
                                        <a class="nav-link">
                                            {{__('home.certificate_blocked')}}
                                        </a>
                                   @elseif($view_certification == 3)
                                       <a class="nav-link"
                                           href="#" data-bs-toggle="modal" data-bs-target="#attendance_not_completed">
                                            {{__('home.certificate')}}
                                       </a>
                                   @elseif($view_certification == 4)
                                    <a class="nav-link"
                                       href="#" data-bs-toggle="modal" data-bs-target="#exam_not_allow">
                                        {{__('home.certificate')}}
                                    </a>
                                   @elseif($view_certification == 5)
                                    <a class="nav-link"
                                       href="#" data-bs-toggle="modal" data-bs-target="#survey_not_allow">
                                        {{__('home.certificate')}}
                                    </a>
                                   @elseif($view_certification == 6)
                                    <a class="nav-link"
                                       href="#" data-bs-toggle="modal" data-bs-target="#certificate_last_day_not_allow">
                                        {{__('home.certificate')}}
                                    </a>
                                   @endif
                            </li>
                            @endif

                            </ul>
                            
                            
                            <!--content training*------------------------->
                            <div class="tab-content" id="back-courses-tab-content">
                              <div class="tab-pane fade show active" id="course_id_curriculum{{$training_index_div}}" role="tabpanel" aria-labelledby="course_id_curriculum{{$training_index_div}}">
                               @if($training->online_url || $training->courses->first())
                                <div class="d-flex justify-content-center">
                                   @if($training->online_url) <a target="_blank" class="btn btn-outline-success col-2 m-1" href="{{ $training->online_url}}">{{ __('home.meeting')}}</a> @endif
                                   @if($training->courses->first() && $training->courses->first()->course_info->student_training_bag) <a target="_blank" class="btn btn-outline-success col-2 m-1" href="{{url('uploads/courses/training_bags/files/'.$training->courses->first()->course_info->student_training_bag)}}">{{ __('home.student_training_bag')}}</a> @endif
                                </div>
                                @endif
                                @foreach($training->courses as $course_relation)
                                    <h3>{{$course_relation->course_info->{'name_'.$lang} }} </h3>
                                    <p>{!! $course_relation->course_info->{'text_'.$lang} !!}</p>
                                    @foreach($course_relation->student_lessons as $lesson_index=>$lesson)
                                        <div class="single-week">
                                          <ul class="week__top mb-0 border-0" data-bs-toggle="collapse" href="#collapseExample" role="button" aria-expanded="{{$lesson_index==0?'true':'false'}}" aria-controls="collapseExample">
                                            <li>{{$lesson->{'name_'.$lang} }}</li>
                                            <li>
                                                <em>
                                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-clock">
                                              <circle cx="12" cy="12" r="10"></circle>
                                              <polyline points="12 6 12 12 16 14"></polyline>
                                            </svg>{{'  '.$lesson->duration}}</em>
                                            </li>
                                          </ul>
                                          <div class="collapse mt-2 pt-3 border-t {{$lesson_index==0?'show':''}}" id="collapseExample">
                                            <p>{!! $lesson->{'text_'.$lang} !!}</p>
                                            <ul class="course__title">
                                               @if($lesson->video_url) 
                                                <li>
                                                    <a href="{{Laravellocalization::localizeUrl('student/course/'.$course_relation->course_info->code.'/lesson/'.$lesson->id)}}" >
                                                      <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-video">
                                                        <polygon points="23 7 16 12 23 17 23 7"></polygon>
                                                        <rect x="1" y="5" width="15" height="14" rx="2" ry="2"></rect>
                                                      </svg>
                                                        {{$lesson->{'name_'.$lang} }}
                                                    </a>
                                                </li>
                                              @endif
                                            @if($lesson->attachments)
                                                @if($lesson->attachments->{'intro_attachment_'.$lang} )
                                                    <li>
                                                        <a href="{{url('uploads/courses/attachments/files/'.$lesson->attachments->{'intro_attachment_'.$lang} )}}" 
                                                        download="{{url('uploads/courses/attachments/files/'.$lesson->attachments->{'intro_attachment_'.$lang} )}}">
                                                          <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-file-text">
                                                            <path d="M14 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V8z"></path>
                                                            <polyline points="14 2 14 8 20 8"></polyline>
                                                            <line x1="16" y1="13" x2="8" y2="13"></line>
                                                            <line x1="16" y1="17" x2="8" y2="17"></line>
                                                            <polyline points="10 9 9 9 8 9"></polyline>
                                                          </svg>
                                                          PDF: {{__('home.intro_attachment')}}
                                                        </a>
                                                    </li>
                                                @endif
                                                  
                                                @if($lesson->attachments->{'attachment_'.$lang} )
                                                    <li>
                                                        <a href="{{url('uploads/courses/attachments/files/'.$lesson->attachments->{'attachment_'.$lang} )}}" 
                                                        download="{{url('uploads/courses/attachments/files/'.$lesson->attachments->{'attachment_'.$lang} )}}">
                                                          <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-file-text">
                                                            <path d="M14 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V8z"></path>
                                                            <polyline points="14 2 14 8 20 8"></polyline>
                                                            <line x1="16" y1="13" x2="8" y2="13"></line>
                                                            <line x1="16" y1="17" x2="8" y2="17"></line>
                                                            <polyline points="10 9 9 9 8 9"></polyline>
                                                          </svg>
                                                          PDF: {{__('home.attachment')}}
                                                        </a>
                                                    </li>
                                                @endif
                                                @if($lesson->attachments->{'details_attachment_'.$lang} )
                                                    <li>
                                                        <a href="{{url('uploads/courses/attachments/files/'.$lesson->attachments->{'details_attachment_'.$lang} )}}" 
                                                        download="{{url('uploads/courses/attachments/files/'.$lesson->attachments->{'details_attachment_'.$lang} )}}">
                                                          <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-file-text">
                                                            <path d="M14 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V8z"></path>
                                                            <polyline points="14 2 14 8 20 8"></polyline>
                                                            <line x1="16" y1="13" x2="8" y2="13"></line>
                                                            <line x1="16" y1="17" x2="8" y2="17"></line>
                                                            <polyline points="10 9 9 9 8 9"></polyline>
                                                          </svg>
                                                          PDF: {{__('home.details_attachment')}}
                                                        </a>
                                                    </li>
                                                @endif
                                            @endif     
                                            </ul>
                                          </div>
                                        </div>
                                    @endforeach
                                @endforeach
                                
                              </div>
                                <!--questions div------------------------->
                              <div class="tab-pane fade" role="tabpanel" aria-labelledby="course_id_faq{{$training_index_div}}" id="course_id_faq{{$training_index_div}}">
                                <h3>{{__('home.questions')}} </h3>
                                <div class="accordion" id="accordionExample">
                                @foreach($training->courses as $course_relation)
                                    @foreach($course_relation->student_lessons as $lesson_index=>$lesson)
                                        @foreach($lesson->questions as $index_question=>$question)
                                          <div class="accordion-item">
                                            <h2 class="accordion-header" id="headingOne_{{$index_question}}">
                                              <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#collapseOne_{{$index_question}}" aria-expanded="{{$index_question==0?'true':'false'}}" aria-controls="collapseOne">
                                             {{$question->{'question_'.$lang} }}
                                              </button>
                                            </h2>
                                            <div id="collapseOne_{{$index_question}}" class="accordion-collapse collapse {{$index_question==0?'show':''}}" aria-labelledby="headingOne_{{$index_question}}" data-bs-parent="#accordionExample">
                                              <div class="accordion-body">
                                                <strong>{{$question->{'answer_'.$lang} }}</strong>
                                              </div>
                                            </div>
                                          </div>
                                        @endforeach  
                                    @endforeach
                                @endforeach
                                  
                                </div>
                              </div>
                              
                                 <!--attendances div------------------------->
                              <div class="tab-pane fade" role="tabpanel" aria-labelledby="attendance_{{$training_index_div}}" id="attendance_{{$training_index_div}}">
                                <h3>{{__('home.attendances')}} </h3>
                                <div class="table-responsive">
                                     {{--<div class=" pt-3 m-auto">
                                            <a  class=" btn w-btn-3" href="{{url('student/training/'.$training->id.'/attendance')}}"  >{{__('home.attend_my_self')}}</a>
                                    </div>--}}
                                    <table class="table" id="exportexample">
                                        <thead>
                                            <tr>
                                                <th>{{ trans('home.name') }}</th>
                                                <th >{{ trans('home.training') }}</th>
                                                <th >{{ trans('home.attendance_date') }}</th>
                                                <th >{{ trans('home.created_at') }}</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach($training->training_attendance as $attendance)
                                                <tr>
                                                    <td> {{ $attendance->user->name() }}  </td>
                                                    <td> {{ $attendance->training->{'name_'.$lang} }}  </td>
                                                    <td> {{\Carbon\Carbon::parse($attendance->attendance_date)->format("d / m / Y")  }}</td>
                                                    <td> {{\Carbon\Carbon::parse($attendance->created_at)->format("d / m / Y")  }}</td>
                                                 
                                                </tr>
                                            @endforeach
                        
                                        </tbody>
                                    </table>
                        	    </div>
                              </div>
                              
                              
                              <!--exames div------------------------->
                            @if($training->exame)
                                @if(count($training->exame->exame_results )>=$training->exame->n_try)
                                    <div class="tab-pane fade" role="tabpanel" aria-labelledby="course_id_quiz{{$training_index_div}}" id="course_id_quiz{{$training_index_div}}">
                                       <div class="row d-flex justify-content-center">
                                           <div class="col-12 text-center">
                                               @if($training->exame->exame_results->pluck('result')->max()>=$training->exame->success_rate)
                                                    <h1 class="text-success">{{__('home.congratulations')}}</h1>
                                               @else
                                                    <h1 class="text-danger">{{__('home.We are sorry, percentage to pass is').' : '.$training->exame->success_rate.' %'}}</h1>
                                                    <h1 class="text-danger">{{__('home.and your score is')}}</h1>
                                               @endif
                                               <h1>{{$training->exame->exame_results->pluck('result')->max().' %'}}</h1>
                                           </div>
                                           {{--
                                           <div class="col-6">
                                               <img src="https://media1.tenor.com/m/yxPY2BsqCDQAAAAC/minions.gif">
                                           </div>
                                           --}}
                                       </div>
                                       
                                        
                                    </div>

                                @elseif($training->view_exam==\Carbon\Carbon::now()->toDateString() && $training->exame->questions)
                                  <div class="tab-pane fade" role="tabpanel" aria-labelledby="course_id_quiz{{$training_index_div}}" id="course_id_quiz{{$training_index_div}}">
                                        <form method="POST" action="{{route('submit_exame')}}">
                                            @csrf
                                            <input type="hidden" name="exame_id" value="{{$training->exame->exam_id}}">
                                            <input type="hidden" name="training_id" value="{{$training->id}}">
                                            
                                            @foreach($training->exame->questions as $index_ecxame_que => $exame_question)
                                                @if(count($exame_question->answers)>0 )
                                                    <div class="single-week">
                                                      <ul class="week__top mb-0 border-0" data-bs-toggle="collapse" href="#quizcollapseExample_{{$index_ecxame_que}}" role="button" 
                                                      aria-expanded="{{$index_ecxame_que==0?'true':'false'}}" aria-controls="quizcollapseExample_{{$index_ecxame_que}}">
                                                        <li>{{($index_ecxame_que + 1).' - '}} {{$exame_question->{'question_'.$lang} }}</li>
                                                        <input type="hidden" name="questions[]" value="{{$exame_question->id}}">
                                                      </ul>
                                                      <div class="collapse mt-2 pt-3 border-t" id="quizcollapseExample_{{$index_ecxame_que}}">
                                                        <div class="row quizExample">
                                                            @foreach($exame_question->answers as $index_answer => $answer)
                                                                <div class="col-3">
                                                                    <div class="form-check col-10">
                                                                        <input class="form-check-input" type="radio" value="{{$answer->id}}" name="answers[{{$exame_question->id}}]" id="flexRadioDefault_{{$index_answer.'_'.$exame_question->id}}">
                                                                        <label class="form-check-label" for="flexRadioDefault_{{$index_answer.'_'.$exame_question->id}}">
                                                                            {{$answer->{'answer_'.$lang} }}
                                                                        </label>
                                                                    </div>
                                                                </div>
                                                            @endforeach
                
                                                        </div>
                                                      </div>
                                                    </div>
                                                @endif
                                            @endforeach
                                            <div class=" pt-3 m-auto">
                                                    <button type="submit" class="submit btn w-btn-3">{{__('home.submit_exame')}}</button>
                                            </div>
                                        </form>
                                      </div>
                                @endif
                            @endif
                            <!--survay div------------------------->
                            @if($training->trainingSurvey)
                             @if($training->view_survey<=\Carbon\Carbon::now()->toDateString() && count($training->trainingSurvey->survey->survayResult)==0)
                              <div class="tab-pane fade" role="tabpanel" aria-labelledby="survey_div_{{$training_index_div}}" id="survey_div_{{$training_index_div}}">
                                <form method="POST" action="{{route('submit_survay')}}" enctype="multipart/form-data">
                                    @csrf
                                    <input type="hidden" name="survey_id" value="{{$training->trainingSurvey->survey->id}}">
                                    <input type="hidden" name="training_id" value="{{$training->id}}">
                                     <h3>{{$training->trainingSurvey->survey->{'name_'.$lang} }} </h3>
                                    <div class="single-week">
                                      <ul class="week__top mb-0 border-0" >
                                      <div class="col-12">
                                          
                                        @foreach($training->trainingSurvey->survey->surveyQuestions as $index_survey => $survey_question)
                                        <div class="row mt-4">
                                                <li class="mb-2">{{($index_survey + 1).' - '}} {{$survey_question->{'question_'.$lang} }}</li>
                                                @if($survey_question->question_type=="file")
                                                <input type="hidden" name="attached_questions[]" value="{{$survey_question->id}}" >
                                                @else
                                                <input type="hidden" name="questions[]" value="{{$survey_question->id}}" >
                                                @endif
                                            @if($survey_question->question_type=="link")
                                                <input class="col-8 col-sm-12" type="text" name="answers[{{$survey_question->id}}]" placeholder="{{__('home.link')}}">
                                            @elseif($survey_question->question_type=="notes")
                                                <textarea class="col-8 col-sm-12" type="text" name="answers[{{$survey_question->id}}]" placeholder="{{__('home.answer')}}" rows="3"></textarea>
                                            
                                            @elseif($survey_question->question_type=="rate")
                                                <div class="row">
                                                <div class="form-check col-2 col-xsm-4">
                                                    <input class="form-check-input"style="margin-left: 40px;" type="radio" name="answers[{{$survey_question->id}}]" id="flexRadioDefault_Perfect_{{$survey_question->id}}" value="Perfect">
                                                    <label class="form-check-label" for="flexRadioDefault_Perfect_{{$survey_question->id}}">
                                                        {{__('home.Perfect') }}
                                                    </label>
                                                </div>
                                                <div class="form-check col-2 col-xsm-4">
                                                    <input class="form-check-input"style="margin-left: 40px;" type="radio" name="answers[{{$survey_question->id}}]" id="flexRadioDefault_Good_{{$survey_question->id}}" value="Good">
                                                    <label class="form-check-label" for="flexRadioDefault_Good_{{$survey_question->id}}">
                                                        {{__('home.Good') }}
                                                    </label>
                                                </div>
                                                <div class="form-check col-3 col-xsm-4">
                                                    <input class="form-check-input"style="margin-left: 40px;" type="radio" name="answers[{{$survey_question->id}}]" id="flexRadioDefault_Average_{{$survey_question->id}}" value="Average">
                                                    <label class="form-check-label" for="flexRadioDefault_Average_{{$survey_question->id}}">
                                                        {{__('home.Average') }}
                                                    </label>
                                                </div>
                                                <div class="form-check col-2 col-xsm-4">
                                                    <input class="form-check-input"style="margin-left: 40px;" type="radio" name="answers[{{$survey_question->id}}]" id="flexRadioDefault_Poor_{{$survey_question->id}}" value="Poor">
                                                    <label class="form-check-label" for="flexRadioDefault_Poor_{{$survey_question->id}}">
                                                        {{__('home.Poor') }}
                                                    </label>
                                                </div>
                                                <div class="form-check col-3 col-xsm-4">
                                                    <input class="form-check-input"style="margin-left: 40px;" type="radio" name="answers[{{$survey_question->id}}]" id="flexRadioDefault_VeryBad_{{$survey_question->id}}" value="Very Bad">
                                                    <label class="form-check-label" for="flexRadioDefault_VeryBad_{{$survey_question->id}}">
                                                        {{__('home.Very Bad') }}
                                                    </label>
                                                </div>
                                            </div>
                                            @elseif($survey_question->question_type=="file")
                                                <div class="form-group">
                                                    <input id="pdf_file" class="form-control-file" type="file" name="attached[{{$survey_question->id}}]">
                                                </div>
                                            @endif
                                        </div>
                                        @endforeach
                                      </div>
                                      </ul>
                                    </div>
                                    <div class=" pt-3 m-auto">
                                            <button type="submit" class="submit btn w-btn-3">{{__('home.submit_exame') }}</button>
                                    </div>
                                </form>
                              </div>
                            @endif
                            @endif
                            @if($training->exame)
                                @if((count($training->exame->exame_results )>0) && (count($training->trainingSurvey->survey->survayResult)>0) && ($training->exame->exame_results->pluck('result')->max()>=$training->exame->success_rate &&$view_certification==1))
                                    <div class="tab-pane fade" role="tabpanel" aria-labelledby="course_id_certificate{{$training_index_div}}" id="course_id_certificate{{$training_index_div}}">
                                      <div class="cert-details">
                                        <h5 class="cert-num">{{auth()->user()->student_info->ssn}}</h5>
                                        <h5 class="cert-own">{{auth()->user()->name()}}</h5>
                                        <h5 class="cert-name">{{$training->name_ar}}</h5>
                                        <h5 class="cert-start">{{ isset($training->trainings_schaduals->start_date) ? \Carbon\Carbon::parse($training->trainings_schaduals->start_date)->format("d / m / Y") : ''  }}</h5>
                                        <h5 class="cert-end">{{ isset($training->trainings_schaduals->start_date) ? \Carbon\Carbon::parse($training->trainings_schaduals->end_date)->format("d / m / Y") : ''  }}</h5>
                                        <img class="rounded" src="{{Helper::uploadedImagesPath('trainings/certificates',$training->training_certificate)}}" alt="">
                                      </div>
                                  </div>
                                @endif
                            @else
                                @if( $training->trainingSurvey && (count($training->trainingSurvey->survey->survayResult->toArray()) > 0) && $view_certification==1)
                                        <div class="tab-pane fade" role="tabpanel" aria-labelledby="course_id_certificate{{$training_index_div}}" id="course_id_certificate{{$training_index_div}}">
                                          <div class="cert-details">
                                                 <h5 class="cert-num">{{auth()->user()->student_info->ssn}}</h5>
                                                 <h5 class="cert-own">{{auth()->user()->name()}}</h5>
                                                <h5 class="cert-name">{{$training->name_ar}}</h5>
                                                <h5 class="cert-start">{{ isset($training->trainings_schaduals->start_date) ? \Carbon\Carbon::parse($training->trainings_schaduals->start_date)->format("d / m / Y") : '' }}</h5>
                                                <h5 class="cert-end">{{ isset($training->trainings_schaduals->start_date) ? \Carbon\Carbon::parse($training->trainings_schaduals->end_date)->format("d / m / Y") : '' }}</h5>
                                                <h5 class="cert-end">{{ isset($training->trainings_schaduals->start_date) ? \Carbon\Carbon::parse($training->trainings_schaduals->end_date)->format("d / m / Y") : '' }}</h5>
                                                <h5 class="sn-code">{{ isset($training->am_student->certificate_serial) ? $training->am_student->certificate_serial : '' }}</h5>
                                                <img class="rounded" src="{{Helper::uploadedImagesPath('trainings/certificates',$training->training_certificate)}}" alt="">
                                                <div class="row m-auto text-center">
                                                    <form id="view_certificate" method="POST" action="{{route('student_generate_certificates')}}" >
                                                        @csrf
                                                        <input type="hidden" id="user_ids" value="{{auth()->user()->id}}" name="ids">
                                                        <input type="hidden" value="{{$training->id}}" name="training_id">
                                                        <button class="btn btn-outline-success m-4 col-lg-6 col-sm-12" type="submit">{{__('home.extract_certificate')}}</button>
                                                    </form>
                                                </div>
                                          </div>
                                        </div>
                                @endif
                            @endif
                            </div>
                            <!-- third tabs content  -->

                          </div>
                        @php
                            $training_now = $training;
                        @endphp
                        @endforeach
                        </div>
                        <!-- secound tabs content  -->

                      </div>
                      <!-- secound tabs content  -->
                    </div>
                  </div>

            <!--edit proooooooooooooooooooooooooofile -->
                  <div class="tab-pane fade" id="member" role="tabpanel" aria-labelledby="member">
                    <div class="row">
                      <div class="col-lg-4">
                        @if(auth()->user()->image)
                            <img src="{{Helper::uploadedImagesPath('users',auth()->user()->image)}}" alt="{{auth()->user()->name() }}">
                        @else
                            <img src="{{Helper::imageFilesPath('profile.webp')}}" alt="{{auth()->user()->name() }}">
                        @endif
                      </div>
                      
                      <div class="col-lg-8 pl-50 md-pl-15 md-mt-60">

                        <div class="login-right-form">
                          <form class="row" action="{{ url('student/update/accountSetting') }}" method="post" enctype="multipart/form-data">
                            @csrf
                            <p class="col-lg-6 col-sm-12">
                              <label>{{__('home.f_name')}} </label>
                              <input class="@error('f_name') is-invalid @enderror" placeholder="{{__('home.f_name')}} " type="text"  name="f_name" value="{{auth()->user()->l_name}}">
                                @error('f_name')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                                @enderror
                            </p>
                            <p class="col-lg-6 col-sm-12">
                              <label>{{__('home.l_name')}} </label>
                              <input class="@error('l_name') is-invalid @enderror" placeholder="{{__('home.l_name')}} " type="text" name="l_name" value="{{auth()->user()->f_name}}">
                                @error('l_name')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                                @enderror
                            </p>
                            <p class="col-lg-12 col-sm-6">
                                <label>{{ trans('home.upload_image') }}</label>
                                <input type="file" class="form-control-file @error('image') is-invalid @enderror" id="image" name="image" accept="image/*">
                                @error('image')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </p>

                            <p  class="col-lg-4 col-sm-6">
                                <label>{{trans('home.Current Password')}}</label>
                                <input class="@error('cur_password') is-invalid @enderror" type="password" placeholder="{{trans('home.Current Password')}}"
                                        name="cur_password" value="" id="cur_password"/>                    
                                @error('cur_password')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                                @enderror
                           </p>
                            <p class="col-lg-4 col-sm-6">
                                <label>{{trans('home.new_password')}}</label>
                                <input class="@error('new_password') is-invalid @enderror" placeholder="{{trans('home.new_password')}}"
                                    name="new_password" value="" id="new-password" type="password"/>     
                                @error('new_password')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                                @enderror
                           </p>
                            <p class="col-lg-4 col-sm-6">
                              <label>{{trans('home.confirm_password')}} </label>
                              <input class="@error('conf_password') is-invalid @enderror" type="password" class="form-control form-control-md"
                                    placeholder="{{trans('home.confirm_password')}}" id="conf-password" name="conf_password"/>
                                @error('conf_password')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                                @enderror
                            </p>

                            <button type="submit" id="button" name="submit">{{__('home.edit_account_information')}} </button>
                          </form>
                        </div>
                      </div>
                    </div>
                  </div>
                  
                </div>
                <!-- main tabs content  -->

                <!-- main tabs wrapper  -->

              </div>
            </div>
          </div>
        </div>
      </div>             
                <!--certificate not allowed -> exam not passed  -->
        <div class="modal fade bd-example-modal-lg" id="exam_not_allow" style="z-index:99999" tabindex="-1" role="dialog" aria-labelledby="trainingPartnerRequestmodelTitle" aria-hidden="true">
            <div class="modal-dialog modal-xl modal-dialog-centered" role="document">
                <div class="modal-content" style="border-radius: 35px;">
                    <div class="modal-body ">
                        <div class="m-auto text-center">
                            <h2>
                                {{__('home.you didnt pass this exam')}}
                            </h2>
                            <div class="m-auto">
                                <button class="btn btn-warning col-4" data-bs-dismiss="modal">{{__('home.close')}}</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
                <!--certificate not allowed -> survey not submitted -->
        <div class="modal fade bd-example-modal-lg" id="survey_not_allow" style="z-index:99999" tabindex="-1" role="dialog" aria-labelledby="trainingPartnerRequestmodelTitle" aria-hidden="true">
            <div class="modal-dialog modal-xl modal-dialog-centered" role="document">
                <div class="modal-content" style="border-radius: 35px;">
                    <div class="modal-body ">
                        <div class="m-auto text-center">
                            <h2>
                                {{__('home.you didnt submit Survey')}}
                            </h2>
                            <div class="m-auto">
                                <button class="btn btn-warning col-4" data-bs-dismiss="modal">{{__('home.close')}}</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
                <!--certificate not allowed -> last day not submitted -->
        <div class="modal fade bd-example-modal-lg" id="certificate_last_day_not_allow" style="z-index:99999" tabindex="-1" role="dialog" aria-labelledby="trainingPartnerRequestmodelTitle" aria-hidden="true">
            <div class="modal-dialog modal-xl modal-dialog-centered" role="document">
                <div class="modal-content" style="border-radius: 35px;">
                    <div class="modal-body ">
                        <div class="m-auto text-center">
                            <h2>
                                {{__('home.Certificate is blocked until last day')}} {{$training_now->trainings_schaduals->end_date}}
                            </h2>
                            <div class="m-auto">
                                <button class="btn btn-warning col-4" data-bs-dismiss="modal">{{__('home.close')}}</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
                <!--attendance not completed  -->
        <div class="modal fade bd-example-modal-lg" id="attendance_not_completed" style="z-index:99999" tabindex="-1" role="dialog" aria-labelledby="trainingPartnerRequestmodelTitle" aria-hidden="true">
            <div class="modal-dialog modal-xl modal-dialog-centered" role="document">
                <div class="modal-content" style="border-radius: 35px;">
                    <div class="modal-body ">
                        <div class="m-auto text-center">
                            <h2>
                                {{__('home.attendance ratio required not completed')}}
                            </h2>
                            <div class="m-auto">
                                <button class="btn btn-warning col-4" data-bs-dismiss="modal">{{__('home.close')}}</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
                         
      
      
</div>  
              
           

@endsection
