@extends('layouts.app')
@section('meta')
<title>{{trans('home.welcome').' '.auth()->user()->name() }}</title>
@endsection

@section('style')
      <link href="https://vjs.zencdn.net/8.10.0/video-js.css" rel="stylesheet" />
@endsection

@section('content')
  <!--================= back wrapper Start Here =================-->
  <div class="back-wrapper">
    <div class="back-wrapper-inner">
      <!--================= Back Breadcrumbs Section Start Here =================-->
      <div class="back-breadcrumbs">
        <div class="breadcrumbs-wrap">
          <img class="desktop" src="{{ Helper::imageFilesPath('breadcrumbs/1.png')}}" alt="Breadcrumbs">
          <img class="mobile" src="{{ Helper::imageFilesPath('breadcrumbs/1.png')}}" alt="Breadcrumbs">
          <div class="breadcrumbs-inner">
            <div class="container">
              <div class="breadcrumbs-text">
                <h1 class="breadcrumbs-title">{{trans('home.video_player')}}</h1>
                <div class="back-nav">
                  <ul>
                    <li>
                      <a href="index.html">{{trans('home.home')}}</a>
                    </li>
                    <li>{{trans('home.video_player')}}</li>
                  </ul>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
      <!--================= Back Breadcrumbs Section End Here =================-->
      <div class="container">
        <div class="row justify-content-center">
          <div class="col-12 col-lg-8 pt-50 pb-50 text-center">
            <h2 class="display-1 fw-bold">{{ $course->{'name_'.$lang} }}</h2>
            <p>{{ $course->{'text_'.$lang} }}</p>
          </div>
        </div>
      </div>
      <div class="px-lg-5 px-2 text-center">
        <div class="mx-auto d-flex align-items-center video__player__wrapper pb-50">
          <div class="videos_list w-25">
            <div class="title d-flex align-items-center justify-content-between">
              <h2 class="mb-0">{{ $lesson->{'name_'.$lang} ?? '' }}</h2>
              <span>{{ $lesson->duration ?? '' }}</span>
            </div>
            <ul>
              @foreach($course->student_lessons as $lesson_l)
                  <li class="@if($lesson_l->video_url == $lesson->video_url) current @endif">
                    <button class="d-flex gap-1" data-src="{{ $lesson_l->video_url }}">
                      <div class="img-wrapper">
                        <img src="{{Helper::uploadedImagesPath('courses/lesson_images',$lesson_l->image)}}" alt="">
                      </div>
                      <div class="list_title">
                        <h2 class="mb-0">{{ $lesson_l->{'name_'.$lang} }}</h2>
                        <span>{{ $lesson_l->duration }}</span>
                      </div>
                    </button>
                  </li>
              @endforeach
            </ul>
          </div>
          

          <!--<iframe src="https://www.youtube.com/embed/5L3wKniOnro?autoplay=1" width="800" height="400" -->
          <!--          allow="accelerometer; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen>-->
          <!--</iframe>-->
          <video id="player1" class="video-js w-75" controls preload="auto" poster="{{Helper::uploadedImagesPath('courses/lesson_images',$lesson->image)}}"
            data-setup="{}">
                <!--<source type="video/youtube" src="http://www.youtube.com/watch?v=nOEw9iiopwI"  />-->
                <source src="https://drive.google.com/file/d/1kE7d9O9ibMkxvm2Jm1syQQpQ5MooliJS/view?usp=sharing" type="video/mp4" />
                <source src="https://drive.google.com/file/d/1kE7d9O9ibMkxvm2Jm1syQQpQ5MooliJS/view?usp=sharing" type="video/webm" />
                <p class="vjs-no-js">
                  To view this video please enable JavaScript, and consider upgrading to a
                  web browser that
                  <a href="https://videojs.com/html5-video-support/" target="_blank">supports HTML5 video</a>
                </p>
          </video>
        </div>
      </div>
    </div>
  </div>
@endsection

@section('script')
      <script src="https://vjs.zencdn.net/8.10.0/video.min.js"></script>

@endsection