<!DOCTYPE html>
<html class="no-js" lang="{{ $lang == 'en' ? 'en' : 'ar' }}" dir="{{ $lang == 'en' ? 'ltr' : 'rtl' }}">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    @yield('meta')
    @yield('title')
    {!!
        $schema1 = new Melbahja\Seo\Schema\Thing('LocalBusiness', [
            'name'          => $configration->app_name,
            'url'          => LaravelLocalization::localizeUrl('/'),
            'image'         => url("uploads/settings/source/$configration->app_logo"),
            'telephone' => $setting->mobile,
            'address' => $configration->address1,
        ]);
    !!}
    @include('layouts.partials.hreflang')

   <!-- Google Tag Manager -->
<script>(function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':
new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],
j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src=
'https://www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);
})(window,document,'script','dataLayer','GTM-5MRLJ9TX');</script>
<!-- End Google Tag Manager -->

    <!-- Favicon -->
    <link rel="shortcut icon" type="image/x-icon" href="{{ Helper::imageFilesPath('favicon.ico') }}">

    <!-- CSS
	============================================ -->
    <link rel="stylesheet" href="{{ Helper::cssFilesPath('vendor/bootstrap.min.css') }}">
    <link rel="stylesheet" href="{{ Helper::cssFilesPath('plugins/feather.css') }}">
    <link rel="stylesheet" href="{{ Helper::cssFilesPath('vendor/slick.css') }}">
    <link rel="stylesheet" href="{{ Helper::cssFilesPath('vendor/slick-theme.css') }}">
    <link rel="shortcut icon" type="image/x-icon"
        href="{{ Helper::uploadedImagesPath('settings', $configration->app_logo) }}">
    <link rel="icon" href="{{url('uploads/settings/'.$configration->fav_icon)}}" type="image/x-icon" />

    <!-- fontawesome 6.4.2 -->
    <link rel="stylesheet" href="{{ Helper::cssFilesPath('plugins/jodit.min.css') }}">
    <link rel="stylesheet" href="{{ Helper::cssFilesPath('plugins/sal.css') }}">
    <link rel="stylesheet" href="{{ Helper::cssFilesPath('plugins/fontawesome.min.css') }}">
    <link rel="stylesheet" href="{{ Helper::cssFilesPath('plugins/magnigy-popup.min.css') }}">
    <link rel="stylesheet" href="{{ Helper::cssFilesPath('plugins/euclid-circulara.css') }}">
    <link rel="stylesheet" href="{{ Helper::cssFilesPath('plugins/plyr.css') }}">
    <link rel="stylesheet" href="{{ Helper::cssFilesPath('plugins/odometer.css') }}">
    <link rel="stylesheet" href="{{ Helper::cssFilesPath('plugins/animation.css') }}">
    <!-- swiper Css 10.2.0 -->
    <link rel="stylesheet" href="{{ Helper::cssFilesPath('plugins/swiper.css') }}">
    <!-- magnific popup css -->
    <!--<link rel="stylesheet" href="{{ Helper::cssFilesPath('vendor/magnific-popup.css') }}">-->
    <!-- Bootstrap 5.0.2 -->
    <link rel="stylesheet" href="{{ Helper::cssFilesPath('plugins/bootstrap-select.min.css') }}">
    <!-- jquery ui css -->
    <link rel="stylesheet" href="{{ Helper::cssFilesPath('plugins/jquery-ui.css') }}">
    <!-- metismenu scss -->
    <!--<link rel="stylesheet" href="{{ Helper::cssFilesPath('vendor/metismenu.css') }}">-->
    <!-- custom style css -->
    <link rel="stylesheet" href="{{ Helper::cssFilesPath('styles.css') }}">
    @if(app()->getLocale() === 'ar')
        <link rel="stylesheet" href="{{ Helper::cssFilesPath('rtl.css') }}">
    @endif
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@10/dist/sweetalert2.min.css">
    

    @yield('style')

  </head>

<body class="rbt-header-sticky">

<!-- Google Tag Manager (noscript) -->
<noscript><iframe src="https://www.googletagmanager.com/ns.html?id=GTM-5MRLJ9TX"
height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>
<!-- End Google Tag Manager (noscript) -->

    @include('layouts.partials.header')     
    <a href="tel:{{$setting->mobile}}" class="float-call">
        <svg class="svg-inline--fa fa-phone" aria-hidden="true" focusable="false" data-prefix="fal" data-icon="phone" role="img" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512" data-fa-i2svg=""><path fill="currentColor" d="M484.6 330.6C484.6 330.6 484.6 330.6 484.6 330.6l-101.8-43.66c-18.5-7.688-40.2-2.375-52.75 13.08l-33.14 40.47C244.2 311.8 200.3 267.9 171.6 215.2l40.52-33.19c15.67-12.92 20.83-34.16 12.84-52.84L181.4 27.37C172.7 7.279 150.8-3.737 129.6 1.154L35.17 23.06C14.47 27.78 0 45.9 0 67.12C0 312.4 199.6 512 444.9 512c21.23 0 39.41-14.44 44.17-35.13l21.8-94.47C515.7 361.1 504.7 339.3 484.6 330.6zM457.9 469.7c-1.375 5.969-6.844 10.31-12.98 10.31c-227.7 0-412.9-185.2-412.9-412.9c0-6.188 4.234-11.48 10.34-12.88l94.41-21.91c1-.2344 2-.3438 2.984-.3438c5.234 0 10.11 3.094 12.25 8.031l43.58 101.7C197.9 147.2 196.4 153.5 191.8 157.3L141.3 198.7C135.6 203.4 133.8 211.4 137.1 218.1c33.38 67.81 89.11 123.5 156.9 156.9c6.641 3.313 14.73 1.531 19.44-4.219l41.39-50.5c3.703-4.563 10.16-6.063 15.5-3.844l101.6 43.56c5.906 2.563 9.156 8.969 7.719 15.22L457.9 469.7z"></path></svg>
    </a>
            <a href="https://wa.me/{{$setting->whatsapp}}" class="float-whts" target="_blank">
        <svg class="svg-inline--fa fa-whatsapp" aria-hidden="true" focusable="false" data-prefix="fab" data-icon="whatsapp" role="img" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512" data-fa-i2svg=""><path fill="currentColor" d="M380.9 97.1C339 55.1 283.2 32 223.9 32c-122.4 0-222 99.6-222 222 0 39.1 10.2 77.3 29.6 111L0 480l117.7-30.9c32.4 17.7 68.9 27 106.1 27h.1c122.3 0 224.1-99.6 224.1-222 0-59.3-25.2-115-67.1-157zm-157 341.6c-33.2 0-65.7-8.9-94-25.7l-6.7-4-69.8 18.3L72 359.2l-4.4-7c-18.5-29.4-28.2-63.3-28.2-98.2 0-101.7 82.8-184.5 184.6-184.5 49.3 0 95.6 19.2 130.4 54.1 34.8 34.9 56.2 81.2 56.1 130.5 0 101.8-84.9 184.6-186.6 184.6zm101.2-138.2c-5.5-2.8-32.8-16.2-37.9-18-5.1-1.9-8.8-2.8-12.5 2.8-3.7 5.6-14.3 18-17.6 21.8-3.2 3.7-6.5 4.2-12 1.4-32.6-16.3-54-29.1-75.5-66-5.7-9.8 5.7-9.1 16.3-30.3 1.8-3.7 .9-6.9-.5-9.7-1.4-2.8-12.5-30.1-17.1-41.2-4.5-10.8-9.1-9.3-12.5-9.5-3.2-.2-6.9-.2-10.6-.2-3.7 0-9.7 1.4-14.8 6.9-5.1 5.6-19.4 19-19.4 46.3 0 27.3 19.9 53.7 22.6 57.4 2.8 3.7 39.1 59.7 94.8 83.8 35.2 15.2 49 16.5 66.6 13.9 10.7-1.6 32.8-13.4 37.4-26.4 4.6-13 4.6-24.1 3.2-26.4-1.3-2.5-5-3.9-10.5-6.6z"></path></svg>
    </a>
    @yield('content')

     
    @include('layouts.partials.footer')     


    <div class="rbt-progress-parent">
        <svg class="rbt-back-circle svg-inner" width="100%" height="100%" viewBox="-1 -1 102 102">
            <path d="M50,1 a49,49 0 0,1 0,98 a49,49 0 0,1 0,-98" />
        </svg>
    </div>

    <!-- JS ============================================ -->
    <!-- Modernizer JS -->
    <script src="{{ Helper::jsFilesPath('vendor/modernizr.min.js') }}"></script>
    <!-- jQuery JS -->
    <script src="{{ Helper::jsFilesPath('vendor/jquery.js') }}"></script>
    <!-- Bootstrap JS -->
    <script src="{{ Helper::jsFilesPath('vendor/bootstrap.min.js') }}"></script>
    <!-- sal') }} -->
    <script src="{{ Helper::jsFilesPath('vendor/sal.js') }}"></script>
    <!-- Dark Mode Switcher -->
    <script src="{{ Helper::jsFilesPath('vendor/js.cookie.js') }}"></script>
    <script src="{{ Helper::jsFilesPath('vendor/jquery.style.switcher.js') }}"></script>
    <script src="{{ Helper::jsFilesPath('vendor/swiper.js') }}"></script>
    <script src="{{ Helper::jsFilesPath('vendor/jquery-appear.js') }}"></script>
    <script src="{{ Helper::jsFilesPath('vendor/odometer.js') }}"></script>
    <script src="{{ Helper::jsFilesPath('vendor/backtotop.js') }}"></script>
    <script src="{{ Helper::jsFilesPath('vendor/isotop.js') }}"></script>
    <script src="{{ Helper::jsFilesPath('vendor/imageloaded.js') }}"></script>

    <script src="{{ Helper::jsFilesPath('vendor/wow.js') }}"></script>
    <script src="{{ Helper::jsFilesPath('vendor/waypoint.min.js') }}"></script>
    <script src="{{ Helper::jsFilesPath('vendor/easypie.js') }}"></script>
    <script src="{{ Helper::jsFilesPath('vendor/text-type.js') }}"></script>
    <script src="{{ Helper::jsFilesPath('vendor/jquery-one-page-nav.js') }}"></script>
    <script src="{{ Helper::jsFilesPath('vendor/bootstrap-select.min.js') }}"></script>
    <script src="{{ Helper::jsFilesPath('vendor/jquery-ui.js') }}"></script>
    <script src="{{ Helper::jsFilesPath('vendor/magnify-popup.min.js') }}"></script>
    <script src="{{ Helper::jsFilesPath('vendor/paralax-scroll.js') }}"></script>
    <script src="{{ Helper::jsFilesPath('vendor/paralax.min.js') }}"></script>
    <script src="{{ Helper::jsFilesPath('vendor/countdown.js') }}"></script>
    <script src="{{ Helper::jsFilesPath('vendor/plyr.js') }}"></script>
    <script src="{{ Helper::jsFilesPath('vendor/jodit.min.js') }}"></script>
    <script src="{{ Helper::jsFilesPath('vendor/Sortable.min.js') }}"></script>
    <script>
        var lang = "{{ app()->getLocale() }}"; // Or use any method to get the current language
    </script>
    <script>
$(document).ready(function () {
    const searchInput = $('#search-input');
    const resultsContainer = $('#autocomplete-results');
    let selectedCategories = [];  // Array to store selected category IDs

    searchInput.on('input', function () {
        const query = $(this).val();
        const lang = '{{ app()->getLocale() }}'; // Get the current locale
    
        if (query.length > 2) {
            $.ajax({
                url: '{{ route("auto-complete") }}',
                method: 'GET',
                data: { phrase: query, categories: selectedCategories }, // Send selected categories with the request
                success: function (response) {
                    console.log(response);
                    resultsContainer.empty();

                    // Check if there are any results
                    if (response.categories.length === 0 && response.trainings.length === 0) {
                        resultsContainer.append('<div style="padding: 10px;">No results found</div>');
                        resultsContainer.show();
                        return;
                    }

                    // Display categories
                    if (response.categories.length > 0) {
                        resultsContainer.append('<div style="padding: 5px; font-weight: bold;">Categories</div>');
                        response.categories.forEach(category => {
                            resultsContainer.append(`
                                <div class="autocomplete-item" style="padding: 5px; cursor: pointer;">
                                    <a href="javascript:void(0);" data-category-id="${category.id}" class="category-select" style="text-decoration: none; color: black;">
                                        ${category.name}
                                    </a>
                                </div>
                            `);
                        });
                    }

                    // Display trainings
                    if (response.trainings.length > 0) {
                        resultsContainer.append('<div style="padding: 5px; font-weight: bold;">Trainings</div>');
                        response.trainings.forEach(training => {
                            resultsContainer.append(`
                                <div class="autocomplete-item" style="padding: 5px; cursor: pointer;">
                                    <a href="${window.location.origin}/${lang}/course/${training.link}" style="text-decoration: none; color: black;">
                                        ${training.name}
                                    </a>
                                </div>
                            `);
                        });
                    }

                    resultsContainer.show();
                },
                error: function () {
                    console.error('Error fetching search results.');
                }
            });
        } else {
            resultsContainer.hide();
        }
    });

    // Handle category selection
    $(document).on('click', '.category-select', function (e) {
        e.preventDefault();
        const categoryId = $(this).data('category-id');

        // Toggle category selection
        if (selectedCategories.includes(categoryId)) {
            selectedCategories = selectedCategories.filter(id => id !== categoryId);
        } else {
            selectedCategories.push(categoryId);
        }

        // Redirect to the '/courses' route with selected categories as query parameters
        const url = new URL('{{ route("courses") }}', window.location.origin); // Replace with the correct route
        selectedCategories.forEach(id => {
            url.searchParams.append('categories[]', id); // Append each category ID as an array parameter
        });

        window.location.href = url.toString(); // Navigate to the new route with the selected categories
    });

    $(document).click(function (e) {
        if (!$(e.target).closest('.search-field').length) {
            resultsContainer.hide();
        }
    });
});

    </script>

    <!-- Main JS -->
    <script src="{{ Helper::jsFilesPath('main.js') }}"></script>
    @yield('script')
</body>

</html>