@extends('layouts.auth')

@section('content')
<div class="container  page main-signin-wrapper">
    <div class="row justify-content-center">
        <div class="col-md-5">
            <div class="card">
                <div class="card-header">
                    <a class="register-main-logo" href="{{LaravelLocalization::localizeUrl('/')}}">
                        <img src="{{Helper::uploadedImagesPath('configrations',$configration->app_logo)}}" alt="logo">
                    </a>
                    <span>{{ __('Reset Password') }}</span>
                </div>

                <div class="card-body">
                    @if (session('status'))
                        <div class="alert alert-success" role="alert">
                            {{ session('status') }}
                        </div>
                    @endif

                    <form method="POST" action="{{ route('password.email') }}">
                        @csrf

                        <div class="row mb-3">
                            <div class="col-12">
                                <input id="email" type="email" class="form-control @error('email') is-invalid @enderror" name="email" value="{{ old('email') }}" required autocomplete="email" autofocus placeholder="{{ __('Email Address') }}">

                                @error('email')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                        </div>

                        <div class="col-12 d-flex flex-column">
                            <button type="submit" class="btn btn-primary w-100 hover-effect">
                               {{ __('Send Password Reset Link') }}
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
