@extends('layouts.admin')
<title>{{trans('home.users')}}</title>
@section('content')
    <div class="container-fluid">

        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5">{{trans('home.users')}}</h2>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{url('/admin')}}">{{trans('home.admin')}}</a></li>
                    <li class="breadcrumb-item active" aria-current="page">{{trans('home.users')}}</li>
                </ol>
            </div>

            <div class="btn btn-list">
                <a href="{{url('admin/users/create')}}" class="btn ripple btn-primary"><i class="fe fe-plus"></i> {{trans('home.add')}}</a>
                <a href="javascript:void(0)" id="btn_users_delete" class="btn ripple btn-danger"><i class="fe fe-x"></i> {{trans('home.delete')}}</a>
            </div>
        </div>
        <!-- End Page Header -->

        @if(session()->has('success'))
            <div class="alert alert-success">
                {{ session()->pull('success') }}
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        @endif

        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1">{{trans('home.users')}}</h6>
                            <p class="text-muted card-sub-title">{{trans('home.table_contain_all_data_shortly_you_can_view_more_details')}}</p>
                        </div>
                        
                        <div class="row">
                            <div class="form-group col-md-6">
                                <label class="">{{trans('home.type')}}</label>
                                <div class="row">
                                        <div class="col-8">
                                            <select id="type" class="form-control select2  " name="type" required>
                                                <option value="">{{ __('home.choose_type') }}</option>
                                                <option value="all" @if(Request::segment(4) == 'all') selected @endif>{{ __('home.Select_all') }}</option>
                                                @foreach($types as $type)
                                                    <option value="{{$type}}" @if(Request::segment(4) == $type) selected @endif>
                                                        {{trans('home.' . $type . 's')}}
                                                    </option>
                                                @endforeach
                                            </select>
                                        </div>
                                </div>
                            </div>
                        </div>
                        
                        <div class="d-flex justify-content-left m-3">
                            <input style="width:15px; margin-left:5px" type="checkbox" name="checkbox" class="tableChecked" value="Select All" id="checkAll"/>
                            <label style="font-size:20px; padding-top:10px" for="checkAll">{{trans('home.select_all')}}</label>
                        </div>

                        {!! $dataTable->table(['class' => 'table table-bordered w-100']) !!}

                    </div>                    
                </div>
            </div>
        </div>
        <!-- End Row -->
    </div>
@endsection

@section('script')
    <script>
        $('#type').change(function () {
            var id = $(this).val();
             var url = "{{url('admin/schedule_users')}}/"+id;
            window.location.href = url ;
        });
    </script>
    
    <script>
        $(document).ready(function(){
            $('#btn_users_delete').click(function(){
                var id = [];
                <?php
                $last_word = Request::segment(2);
                // return $last_word;
                Session::put('route', $last_word);
                ?>
                $('.tableChecked:checked').each(function(i){
                    id[i] = $(this).val();
                });
                if(id.length === 0) //tell you if the array is empty
                {
                    alert("Please Select atleast one checkbox");
                }
                else
                {
                    $.confirm({
                        title: '{{__('home.Are you sure you want to delete that ?')}}',
                        content:'',
                        buttons: {
                            confirm: {
                                text: '{{__('home.delete')}}',
                                btnClass: 'btn-red any-other-class',
                                keys: ['enter', 'shift'],
                                action: function(){
                                     $.ajaxSetup({
                                        headers: {
                                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                                        }
                                    });
                    
                                    $.ajax({
                                        url: "<?php echo url('/admin/users') ?>/" + id,
                                        type: 'DELETE',
                                        data: {id: id},
                                        success: function () {
                                            for (var i = 0; i < id.length; i++) {
                                                $('tr#' + id[i]).css('background-color', '#ccc').fadeOut('slow');
                                                $('input:checkbox[value="' + id[i] + '"]').removeClass('tableChecked').removeAttr('checked');
                                            }
                                        }
                                    }); 
                                }
                            },
                            cancel: {
                                text: '{{__('home.cancel')}}',
                                action: function(){
                                    close();
                                }
                            }
                        }
                    });
                }
            });
        });
    </script>
    {!! $dataTable->scripts() !!}
@endsection