@extends('layouts.admin')
@section('meta')
    <title>{{trans('home.show_training')}}</title>
@endsection
@section('content')

<div class="container-fluid">
    <!-- Page Header -->
    <div class="page-header">
        <div>
            <h2 class="main-content-title tx-24 mg-b-5">{{trans('home.trainings')}}</h2>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{url('/admin')}}">{{trans('home.admin')}}</a></li>
                <li class="breadcrumb-item"><a href="{{url('admin/trainings')}}">{{trans('home.trainings')}}</a></li>
                <li class="breadcrumb-item active" aria-current="page">{{trans('home.show_training')}}</li>
            </ol>
        </div>
    </div>

    <!-- End Page Header -->
    {!! Form::open(['method'=>'PATCH','url' => 'admin/trainings/'.$training->id, 'data-toggle'=>'validator', 'files'=>'true']) !!}
        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    
                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1">{{trans('home.training_info')}}</h6>
                            <hr>
                        </div>
                        @php $user_c = auth()->user()->roles->pluck('name')->toArray()[0]; @endphp
                        
                        <div class="row">
                            {{--@if($user_c != 'منسق خارجي') --}}
                            <div class="form-group col-md-3">
                                <label class="">{{trans('home.name_en')}}</label>
                                <input class="form-control @error('name_en') is-invalid @enderror" name="name_en" value="{{old('name_en', $training->name_en)}}" type="text"  disabled>
                                @error('name_en')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            {{--@endif--}}
                            
                            <div class="form-group col-md-3">
                                <label class="">{{trans('home.name_ar')}}</label>
                                <input class="form-control @error('name_ar') is-invalid @enderror" name="name_ar" value="{{old('name_ar', $training->name_ar)}}" type="text" disabled>
                                @error('name_ar')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            <div class="form-group col-md-2">
                                <label class="">{{trans('home.code')}}</label>
                                <input class="form-control @error('code') is-invalid @enderror"
                                       name="code" value="{{old('code', $training->code)}}" type="text"  disabled>
                            </div>

                            @if(auth()->user()->type != 'instructor')
                            <div class="form-group col-md-4">
                                <label class="">{{trans('home.online_url')}}</label>
                                <input class="form-control @error('online_url') is-invalid @enderror" name="online_url" value="{{old('online_url', $training->online_url)}}" type="text" disabled>
                            </div>
                            @endif
                            @if(auth()->user()->type != 'instructor') 
                            <div class="col-md-4">
                                <label>{{trans('home.image')}}</label>
                                <div class="input-group mb-1">
                                    @if($training->image)
                                        <img style="height: 150px; margin-top:15px"
                                            src="{{ url("uploads/trainings/$training->image") }}" alt="">
                                        <div class="form-group col-md-12 mb-4 d-flex align-items-center">
                                            <a href="{{url('uploads/trainings/certificates/'.$training->training_certificate)}}" download="{{$training->training_certificate}}">
                                              <i class="fas fa-download"></i>
                                            {{$training->training_certificate}}</a>
                                        </div>
                                    @else
                                        <span class="text-danger">{{ trans('home.image_not_found') }}</span>
                                    @endif
                                </div>
                            </div>
                            @endif
                            @if(auth()->user()->type != 'instructor') 
                            <div class="form-group col-md-3">
                                <label class="">{{trans('home.alt_img')}}</label>
                                <input class="form-control" name="alt_img" value="{{old('alt_img', $training->alt_img)}}" type="text" disabled />
                            </div>
                            @endif

                            <div class="form-group col-md-2">
                                <label class="">{{trans('home.centers')}}</label>
                                <input class="form-control" name="center_id" value="{{(app()->getLocale() == 'en')?$center->name_en ?? '':$center->name_ar ?? '' }}" type="text" disabled />
                            </div>
                            
                            <div class="form-group col-md-3">
                                <label class="">{{trans('home.halls')}}</label>
                                <input class="form-control" name="hall_id" value="{{(app()->getLocale() == 'en') ?  $training->trainings_schaduals->hall->name_en ?? '': $training->trainings_schaduals->hall->name_ar ?? ''}}" type="text" disabled />
                            </div>

                            <div class="form-group col-md-3">
                                <label for="start_date">{{trans('home.start_date')}}</label>
                                <div class="input-group">
                                    <input type='text' class="form-control" name="start_date" value="{{$training->trainings_schaduals ? \Carbon\Carbon::parse($training->trainings_schaduals->start_date)->format("Y-m-d") : ''}}" readonly disabled/>
                                    <div class="input-group-append">
                                        <span class="input-group-text">
                                            <i class="fas fa-calendar"></i>
                                        </span>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="form-group col-md-3">
                                <label for="end_date">{{trans('home.end_date')}}</label>
                                <div class="input-group">
                                    <input type='text' class="form-control datepicker" name="end_date" value="{{$training->trainings_schaduals ? \Carbon\Carbon::parse($training->trainings_schaduals->end_date)->format("Y-m-d") : ''}}" readonly disabled/>
                                    <div class="input-group-append">
                                        <span class="input-group-text">
                                            <i class="fas fa-calendar"></i>
                                        </span>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="form-group col-md-3">
                                <label for="training_field_id">{{trans('home.training_field_id')}}</label>
                                <select class="form-control select2" name="training_field_id" disabled>
                                    @foreach($fields as $field)
                                        <option value="{{$field->id}}" {{($field->id == $training->training_field_id)?'selected':''}} >{{(app()->getLocale() == 'en')?$field->name_en:$field->name_ar }}</option>
                                    @endforeach
                                </select>
                            </div>
                            
                            <div class="form-group col-md-3">
                                <label class="">{{trans('home.training_type')}}</label>
                                <input class="form-control" type="text" name="training_type" value="{{$training->training_type == 'offline' ? 'حضوري' : 'اونلاين'}}" disabled />
                            </div>
                            
                            
                            @if(auth()->user()->type != 'instructor')
                            <div class="form-group col-md-3">
                                <label class="">{{trans('home.recorded')}}</label>
                                <input class="form-control" name="recorded" value="{{$training->recorded == 1 ? 'مسجلة' : 'غير مسجلة'}}" type="text" disabled />
                            </div>
                            @endif

                            <div class="form-group col-md-3">
                                <label for="time_from">{{trans('home.time_from')}} ({{trans('home.attendance')}})</label>
                                <div class="input-group">
                                    <input type='text' class="form-control timepicker" name="time_from" value="{{$training->time_from}}" readonly disabled/>
                                    <div class="input-group-append">
                                        <span class="input-group-text">
                                            <i class="fas fa-clock"></i>
                                        </span>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="form-group col-md-3">
                                <label for="time_to">{{trans('home.time_to')}} ({{trans('home.attendance')}})</label>
                                <div class="input-group">
                                    <input type='text' class="form-control timepicker" name="time_to" value="{{$training->time_to}}" readonly disabled/>
                                    <div class="input-group-append">
                                        <span class="input-group-text">
                                            <i class="fas fa-clock"></i>
                                        </span>
                                    </div>
                                </div>
                            </div>
                            <div class="form-group col-md-3">
                                <label class="">{{trans('home.timing_type')}}</label>
                                <input class="form-control" name="timing_type" value="{{$training->timing_type}}" type="text" disabled />
                            </div>

                            <div class="form-group col-md-2">
                                <label class="">{{trans('home.overall_days')}}</label>
                                <input class="form-control" name="overall_days" value="{{old('overall_days', $training->overall_days)}}" type="number" min="0" disabled/>
                            </div>
                            
                            <div class="form-group col-md-2">
                                <label class="">{{trans('home.overall_time')}}</label>
                                <input class="form-control" name="overall_time" value="{{old('overall_time', $training->overall_time)}}" type="number" min="0" disabled/>
                            </div>
                            
                            @if(auth()->user()->type != 'instructor')
                            <div class="form-group col-md-2">
                                <label class="">{{trans('home.online_price')}}</label>
                                <input class="form-control" name="online_price" value="{{old('online_price', $training->online_price)}}" type="number" min="0" disabled/>
                            </div>
                            
                            <div class="form-group col-md-2">
                                <label class="">{{trans('home.offline_price')}}</label>
                                <input class="form-control" name="offline_price" value="{{old('offline_price', $training->offline_price)}}" type="number" min="0.00" disabled/>
                            </div>
                            @endif
                            
                            
                             <div class="form-group col-md-2">
                                <label for="view_survey">{{trans('home.view_survey_date')}}</label>
                                <div class="input-group">
                                    <input type='text' class="form-control" name="view_survey" value="{{old('view_survey', $training->view_survey)}}" value="{{old('view_survey')}}" disabled readonly/>
                                    <div class="input-group-append">
                                        <span class="input-group-text">
                                            <i class="fas fa-calendar"></i>
                                        </span>
                                    </div>
                                </div>
                            </div>
                            @if(auth()->user()->type != 'instructor')
                            <div class="form-group col-md-2">
                                <label for="view_exam">{{trans('home.view_exam_date')}}</label>
                                <div class="input-group">
                                    <input type='text' class="form-control " name="view_exam" value="{{old('view_exam', $training->view_exam)}}" value="{{old('view_exam')}}" readonly disabled/>
                                    <div class="input-group-append">
                                        <span class="input-group-text">
                                            <i class="fas fa-calendar"></i>
                                        </span>
                                    </div>
                                </div>
                            </div>
                            <div class="form-group col-md-2">
                                <label for="success_rate">{{trans('home.success_rate')}}</label>
                                <div class="input-group">
                                    <input type='number' class="form-control" name="success_rate" value="{{ $training_exame ? $training_exame->success_rate : '' }}" disabled />
                                </div>
                            </div>
                            <div class="form-group col-md-2">
                                <label for="n_try">{{trans('home.n_try')}}</label>
                                <div class="input-group">
                                    <input type='number' class="form-control" name="n_try" value="{{ $training_exame ? $training_exame->n_try : ' '}}" disabled/>
                                </div>
                            </div>
                            @endif
                            
                            <div class="form-group col-md-2">
                                <label class="">{{trans('home.instructors')}}</label>
                                <input class="form-control" name="instructor_id" value="{{$instructor->f_name ?? '' }}" type="text" min="0" disabled/>
                            </div>
                            
                            <div class="form-group col-md-2">
                                <label class="">{{trans('home.coordinators')}}</label>
                                <input class="form-control" name="coordinator_id" value="{{$coordinator->f_name ?? ''}}" type="text" min="0" disabled/>
                            </div>
                            @if(auth()->user()->type != 'instructor')
                            <div class="form-group col-md-2">
                                <label class="">{{trans('home.marketers')}}</label>
                                <input class="form-control" name="marketer_id" value="{{$marketer->f_name ?? ''}}" type="text" min="0" disabled/>
                            </div>
                            @endif
                            
                            <div class="form-group col-md-2">
                                <label class="">{{trans('home.regions')}}</label>
                                <input class="form-control" name="region_id" value="{{ (app()->getLocale() == 'en')?$region->name_en ?? '':$region->name_ar ?? '' }}" type="text" min="0" disabled/>
                            </div>
                            
                            <div class="form-group col-md-12">
                                <label for="helperText">{{trans('home.courses')}}  </label>
                                <select class="form-control role select2" name="courses_id[]" multiple disabled>
                                    @foreach($courses as $course)
                                        <option value="{{$course->id}}" {{(in_array($course->id,$coursIds) )?'selected':''}} >{{(app()->getLocale() == 'en')?$course->name_en ?? '': $course->name_ar ?? '' }}</option>
                                    @endforeach
                                </select>
                            </div>
                            @if(auth()->user()->type != 'instructor')
                            <div class="col-md-2">
                                <label>{{trans('home.training_certificate')}}</label>
                                <div class="input-group mb-1">
                                   @if($training->training_certificate)
                                       <img style="height: 150px; margin-top:15px"
                                                src="{{ url("uploads/trainings/certificates/$training->training_certificate") }}" alt="">
                                        <div class="form-group col-md-12 mb-4 d-flex align-items-center">
                                            <a href="{{url('uploads/trainings/certificates/'.$training->training_certificate)}}" download="{{$training->training_certificate}}">
                                              <i class="fas fa-download"></i>
                                            {{$training->training_certificate}}</a>
                                        </div> 
                                   @else
                                        <span class="text-danger">{{ trans('home.image_not_found') }}</span>
                                   @endif
                                </div>
                            </div>
                            
                            <div class="form-group col-md-2">
                                <label class="">{{trans('home.regions')}}</label>
                                <input class="form-control" name="region_id" value="{{ (app()->getLocale() == 'en')?$region->name_en ?? '':$region->name_ar ?? '' }}" type="text" min="0" disabled/>
                            </div>
                            
                            <div class="form-group col-md-4">
                                <label for="parent">{{trans('home.surveys_models')}}</label>
                                <select class="form-control" name="survey_id[]" multiple disabled readonly>
                                    @if(count($surveys) > 0)
                                        @foreach($surveys as $survey)
                                            @if(in_array($survey->id,$surveyIds))<option value="{{$survey->id}}">{{(app()->getLocale()=='en')? $survey->name_en:$survey->name_ar}}</option>@endif
                                    @endforeach 
                                    @else
                                        <option >{{ trans('home.data_not_found') }}</option>
                                    @endif
                                </select>
                            </div>
                            <div class="form-group col-md-4">
                                <label for="parent">{{trans('home.exames_models')}}</label>
                                <select class="form-control" name="exame_id[]" multiple disabled>
                                    @if(count($exames) > 0)
                                        @foreach($exames as $exame)
                                            <option value="{{$exame->id}}" >{{(app()->getLocale()=='en')? $exame->name_en:$exame->name_ar}}</option>
                                        @endforeach   
                                    @else
                                        <option >{{ trans('home.data_not_found') }}</option>
                                    @endif
                                </select>
                            </div>
                            
                                

                            <div class="form-group col-md-12">
                                <p class="mt-4 mb-2">{{trans('home.status')}}</p>
                                <label class="custom-switch">
                                    <input type="checkbox" name="status" disabled readonly value="1" class="custom-switch-input" {{($training->status == 1)? 'checked':''}} />
                                    <span class="custom-switch-indicator"></span>
                                </label>
                            </div>
                            @endif
                            
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
        
        
        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    
                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1">{{trans('home.training description')}}</h6>
                            <hr>
                        </div>
                        
                        <div class="row">
                            <div class="form-group col-md-6">
                                <label class="">{{trans('home.text_en')}}</label>
                                <textarea class="form-control" name="text_en" disabled >{{strip_tags($training->text_en)}}</textarea>
                            </div>
                            
                            <div class="form-group col-md-6">
                                <label class="">{{trans('home.text_ar')}}</label>
                                <textarea class="form-control" name="text_ar" disabled >{{strip_tags($training->text_ar)}}</textarea>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
        

    {!! Form::close() !!}
</div>

@endsection


