@extends('layouts.admin')
<title>{{trans('home.edit_teams')}}</title>
@section('content')

<div class="container-fluid">

    <!-- Page Header -->
    <div class="page-header">
        <div>
            <h2 class="main-content-title tx-24 mg-b-5">{{trans('home.teams')}}</h2>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{url('/admin')}}">{{trans('home.admin')}}</a></li>
                <li class="breadcrumb-item"><a href="{{url('admin/teams')}}">{{trans('home.teams')}}</a></li>
                <li class="breadcrumb-item active" aria-current="page">{{trans('home.edit_team')}}</li>
            </ol>
        </div>
    </div>
    <!-- End Page Header -->
    
    {!! Form::open(['method'=>'PATCH','url' => 'admin/teams/'.$team->id, 'data-toggle'=>'validator', 'files'=>'true']) !!}

        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1">{{trans('home.edit_team')}}</h6>
                        </div>
                        <div class="row">

                            <div class="form-group col-md-2">
                                <label class="">{{trans('home.name_en')}}</label>
                                <input class="form-control" name="name_en" type="text" placeholder="{{trans('home.name_en')}}" value="{{$team->name_en}}">
                            </div>
                            
                            <div class="form-group col-md-2">
                                <label class="">{{trans('home.name_ar')}}</label>
                                <input class="form-control" name="name_ar" type="text" placeholder="{{trans('home.name_ar')}}" value="{{$team->name_ar}}">
                            </div>
                            
                            <div class="form-group col-md-2">
                                <label class="">{{trans('home.position_en')}}</label>
                                <input class="form-control" name="position_en" type="text" placeholder="{{trans('home.position_en')}}" value="{{$team->position_en}}">
                            </div>
                            
                            <div class="form-group col-md-2">
                                <label class="">{{trans('home.position_ar')}}</label>
                                <input class="form-control" name="position_ar" type="text" placeholder="{{trans('home.position_ar')}}" value="{{$team->position_ar}}">
                            </div>
                            
                            <div class="form-group  col-md-3">
                                <label>{{trans('home.image')}}</label>
                                <div class="input-group mb-1">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text"> {{trans('home.upload')}}</span>
                                    </div>
                                    <div class="custom-file">
                                        <input type="file" class="custom-file-input" name="img">
                                        <label class="custom-file-label" for="inputGroupFile01">{{trans('home.choose_image')}}</label>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="form-group col-md-1">
                                <label class="">{{trans('home.alt_img')}}</label>
                                <input class="form-control" name="alt_img" type="text" placeholder="{{trans('home.alt_img')}}" value="{{$team->alt_img}}">
                            </div>

                            @if($team->img)
                                <div class="form-group  col-md-12">
                                    <img style="border-radius:50%" src="{{url('uploads/teams/'.$team->img)}}" width="150">   
                                </div>
                            @endif

                            <div class="form-group col-md-6">
                                <label class="">{{trans('home.text_en')}}</label>
                                <textarea class="form-control" name="text_en"  placeholder="{{trans('home.text_en')}}">{!! $team->text_en !!}</textarea>
                            </div>
                            
                            <div class="form-group col-md-6">
                                <label class="">{{trans('home.text_ar')}}</label>
                                <textarea class="form-control" name="text_ar"  placeholder="{{trans('home.text_ar')}}">{!! $team->text_ar !!}</textarea>
                            </div>

                            <div class="form-group col-md-4">
                                <label class="ckbox">
                                    <input name="status" value="1" {{($team->status == 1)? 'checked':''}} type="checkbox"><span class="tx-13">{{trans('home.publish')}}</span>
                                </label>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
        
        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div class="row">
                            <div class="form-group col-md-12">
                                <button type="submit" class="btn btn-success"><i class="icon-note"></i> {{trans('home.save')}} </button>
                                <a href="{{url('/admin/teams')}}"><button type="button" class="btn btn-danger mr-1"><i class="icon-trash"></i> {{trans('home.cancel')}}</button></a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
    {!! Form::close() !!}
</div>

@endsection
