@extends('layouts.admin')
<title>{{trans('home.teachers')}}</title>
@section('content')
    <div class="container-fluid">

        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5">{{trans('home.teachers')}}</h2>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{url('/admin')}}">{{trans('home.admin')}}</a></li>
                    <li class="breadcrumb-item active" aria-current="page">{{trans('home.teachers')}}</li>
                </ol>
            </div>
            @can('operations')
            <div class="btn btn-list">
                <a href="{{url('admin/teachers/create')}}"><button class="btn ripple btn-primary"><i class="fas fa-plus-circle"></i> {{trans('home.add')}}</button></a>
                <a class="mr-2" id="btn_active"><button class="btn ripple btn-dark"><i class="fas fa-eye"></i> {{trans('home.publish/unpublish')}}</button></a>
                <a class="mr-2" id="btn_delete" ><button class="btn ripple btn-danger"><i class="fas fa-trash"></i> {{trans('home.delete')}}</button></a>
            </div>
            @endcan
        </div>
        <!-- End Page Header -->

         <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card-body">
                    <table class="table" id="datatable">
                        <thead>
                            <tr>
                                <th>{{trans('home.id')}}</th>
                                <th class="wd-20p">{{trans('home.name')}}</th>
                                <th class="wd-25p">{{trans('home.email')}}</th>
                                <th class="wd-20p">{{trans('home.category')}}</th>
                                <th class="wd-15p">{{trans('home.phone')}}</th>
                                <th>{{__('home.edit')}}</th>
                                <th>{{__('home.delete')}}                                
                                </th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($teachers as $teacher)
                                <tr id="{{$teacher->id}}">
                                    <td><a href="{{ route('teachers.edit', $teacher->id) }}">{{$teacher->id}}</a></td>
                                    <td>{{$teacher->name}}</td>
                                    <td>{{$teacher->email}}</td>
                                    <td>{{ $teacher->{'category_'.$lang} }}</td>
                                    <td>{{$teacher->phone}}</td>
                                    <td> 
                                        <a type="button" class="btn btn-info waves-effect waves-light " 
                                            href="{{ route('teachers.edit',$teacher->id) }}" >{{__('home.edit')}}</a>
                                    </td>
                                    <td> 
                                        <a type="button" class="btn btn-danger waves-effect waves-light btn_delete" 
                                            data-id="{{$teacher->id}}">{{__('home.delete')}}</a>
                                    </td>
                                </tr>
                            @endforeach

                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
@endsection

