@extends('layouts.admin')
@section('meta')
    <title>{{trans('home.training_surveys')}}</title>
@endsection
@section('content')
    <div class="container-fluid">

        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5">{{trans('home.training_surveys')}}</h2>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{url('/admin')}}">{{trans('home.admin')}}</a></li>
                    <li class="breadcrumb-item active" aria-current="page">{{trans('home.training_surveys')}}</li>
                </ol>
            </div>
        </div>
        <!-- End Page Header -->

        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1">{{trans('home.training_surveys')}}</h6>
                            <p class="text-muted card-sub-title">{{trans('home.table_contain_all_data_shortly_you_can_view_more_details')}}</p>
                        </div>

                        <div class="table-responsive">
                        <table class="table" id="exportexample">
                            <thead>
                                <tr>
                                    <th><input type="checkbox" id="checkAll"/></th>
                                    <th>{{trans('home.id')}}</th>
                                    <th>{{trans('home.name_en')}}</th>
                                    <th>{{trans('home.name_ar')}}</th>
                                    <th>{{trans('home.type')}}</th>
                                    <th>{{trans('home.status')}}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($training_surveys as $training_survey)
                                    <tr id="{{$training_survey->survey->id}}">
                                        <td> <input type="checkbox" name="checkbox"  class="tableChecked" value="{{$training_survey->survey->id}}" /> </td>
                                        <td><a href="{{ route('surveys_results.showResults', [$training_survey->survey->id,$id]) }}">{{$training_survey->survey->id}}</a></td>
                                        <td><a href="{{ route('surveys_results.showResults', [$training_survey->survey->id,$id]) }}">{{$training_survey->survey->name_en}}</a></td>
                                        <td><a href="{{ route('surveys_results.showResults', [$training_survey->survey->id,$id]) }}">{{$training_survey->survey->name_ar}}</a></td>
                                        <td><a href="{{ route('surveys_results.showResults', [$training_survey->survey->id,$id]) }}">{{$training_survey->survey->survay_type}}</a></td>
                                        <td>
                                            <a href="{{ route('surveys_results.showResults', [$training_survey->survey->id,$id]) }}">
                                                @if($training_survey->survey->status == 1)
                                                    <span class="badge badge-success">{{trans('home.yes')}}</span>
                                                @else
                                                    <span class="badge badge-danger">{{trans('home.no')}}</span>
                                                @endif
                                            </a>
                                        </td>  
                                    </tr>
                                @endforeach

                            </tbody>
                        </table>
					</div>
                    </div>

                </div>
            </div>
        </div>
        <!-- End Row -->
    </div>
@endsection
