@extends('layouts.admin')
@section('meta')
    <title>{{trans('home.add_survey')}}</title>
@endsection
@section('content')

<div class="container-fluid">
        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5">{{trans('home.surveys')}}</h2>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{url('/admin')}}">{{trans('home.admin')}}</a></li>
                    <li class="breadcrumb-item"><a href="{{url('admin/surveys')}}">{{trans('home.surveys')}}</a></li>
                    <li class="breadcrumb-item active" aria-current="page">{{trans('home.add_survey')}}</li>
                </ol>
            </div>
        </div>
        <!-- End Page Header -->
        {!! Form::open(['route' => 'surveys.store', 'data-toggle'=>'validator', 'files'=>'true']) !!}

            <!-- Row-->
            <div class="row">
                <div class="col-sm-12 col-xl-12 col-lg-12">
                    <div class="card custom-card overflow-hidden">
                        
                        <div class="card-body">
                            <div>
                                <h6 class="card-title mb-1">{{trans('home.survey')}}</h6>
                                <hr>
                            </div>
                            <div class="row">

                                <div class="form-group col-md-5">
                                    <label class="">{{trans('home.name_en')}}</label>
                                    <input class="form-control" name="name_en" type="text" placeholder="{{trans('home.name_en')}}" required>
                                </div>

                                <div class="form-group col-md-5">
                                    <label class="">{{trans('home.name_ar')}}</label>
                                    <input class="form-control" name="name_ar" type="text" placeholder="{{trans('home.name_ar')}}" required>
                                </div>
                                
                                <div class="form-group col-md-2">
                                    <label for="parent">{{trans('home.survay_type')}}</label>
                                     <select class="form-control select2" name="survay_type">
                                        <option value="student" @selected(old('survay_type') == 'student')>{{trans('home.student')}}</option>
                                        <option value="instructor" @selected(old('survay_type') == 'instructor')>{{trans('home.instructor')}}</option>
                                        <option value="company" @selected(old('survay_type') == 'company')>{{trans('home.company')}}</option>
                                    </select>
                                </div>
                                
                                @can('status_or_publish_field')
                                <div class="form-group col-md-12">
                                    <p class="mt-4 mb-2">{{trans('home.publish')}}</p>
                                    <label class="custom-switch">
                                        <input type="checkbox" name="status" value="1" class="custom-switch-input" checked>
                                        <span class="custom-switch-indicator"></span>
                                        <span class="custom-switch-description">{{trans('home.click_to_publish_content')}}</span>
                                    </label>
                                </div>
                                @endcan
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- End Row -->

            <!-- Row-->
            <div class="row">
                <div class="col-sm-12 col-xl-12 col-lg-12">
                    <div class="card custom-card overflow-hidden">
                        
                        <div class="card-body">
                            <div>
                                <h6 class="card-title mb-1">{{trans('home.survey_questions')}}</h6>
                                <hr>
                            </div>

                            <div class="question_wrapper">
                                <div class="row">
                                    <div class="form-group col-md-4"> 
                                        <label for="question_en">{{trans('home.question_en')}}</label>
                                        <input type="text"  class="form-control" placeholder="{{trans('home.question_en')}}" name="question_en[]">
                                    </div>
                                    
                                    <div class="form-group col-md-4"> 
                                        <label for="question_ar">{{trans('home.question_ar')}}</label>
                                        <input type="text"  class="form-control" placeholder="{{trans('home.question_ar')}}" name="question_ar[]">
                                    </div>

                                    <div class="form-group col-md-3">
                                        <label for="question_type">{{trans('home.question_type')}}</label>
                                        <select class="form-control select2" name="question_type[]">
                                            <option value="notes" @selected(old('question_type') == 'notes')>{{trans('home.notes')}}</option>
                                            <option value="question" @selected(old('question_type') == 'question')>{{trans('home.question')}}</option>
                                            <option value="rate" @selected(old('question_type') == 'rate')>{{trans('home.rate')}}</option>
                                            <option value="file" @selected(old('question_type') == 'file')>{{trans('home.file')}}</option>
                                            <option value="link" @selected(old('question_type') == 'link')>{{trans('home.link')}}</option>
                                        </select>
                                    </div>
                                </div>  
                            </div>       
                            <a href="javascript:void(0);" class="add_question btn" title="Add field"><i class="fas fa-plus-square"></i></a>								
                        </div>
                    </div>
                </div>
            </div>
            <!-- End Row -->

            <!-- Row-->
            <div class="row">
                <div class="col-sm-12 col-xl-12 col-lg-12">
                    <div class="card custom-card overflow-hidden">
                        <div class="card-body">
                            <div class="row">
                                <div class="form-group col-md-12">
                                    <button type="submit" class="btn btn-success"><i class="icon-note"></i> {{trans('home.save')}} </button>
                                    <a href="{{url('/admin/surveys')}}"><button type="button" class="btn btn-danger mr-1"><i class="icon-trash"></i> {{trans('home.cancel')}}</button></a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- End Row -->
        {!! Form::close() !!}

    </div>

@endsection

@section('script')
    <script>
        
            $(document).ready(function(){
            var maxField = 100; //Input fields increment limitation
            var addButton = $('.add_question'); //Add button selector
            var wrapper = $('.question_wrapper'); //Input field wrapper
           var fieldHTML ='<div class="row"><hr><div class="form-group col-md-4"> <label for="question_en">{{trans('home.question_en')}}</label> <input type="text"  class="form-control" placeholder="{{trans('home.question_en')}}" name="question_en[]"> </div>';
            fieldHTML +='<div class="form-group col-md-4"> <label for="question_ar">{{trans('home.question_ar')}}</label> <input type="text"  class="form-control" placeholder="{{trans('home.question_ar')}}" name="question_ar[]"> </div>';
            fieldHTML +='<div class="form-group col-md-3"> <label for="question_type">{{trans('home.question_type')}}</label> <select class="form-control select2" name="question_type[]"> <option value="notes">{{trans('home.notes')}}</option> <option value="question">{{trans('home.question')}}</option> <option value="rate">{{trans('home.rate')}}</option> <option value="file">{{trans('home.file')}}</option> <option value="link">{{trans('home.link')}}</option> </select> </div>';
            fieldHTML +='<div class="form-group col-md-1"><a href="javascript:void(0);" style="margin-top: 30px;" class="remove_button btn"><i class="fas fa-trash-alt"></i></a></div></div>';

            var x = 1; //Initial field counter is 1

            //Once add button is clicked
            $(addButton).click(function(){
                //Check maximum number of input fields
                if(x < maxField){
                    x++; //Increment field counter
                    $(wrapper).append(fieldHTML); //Add field html
                }
                $('.select2').select2({
                    'placeholder' : 'choose',
                });
            });

            //Once remove button is clicked
            $(wrapper).on('click', '.remove_button', function(e){
                e.preventDefault();
                $(this).parent().parent('div').remove(); //Remove field html
                x--; //Decrement field counter
            });
        });


    </script>
@endsection

