<div class="modal fade" id="view_trainingModal_{{$std_id}}" tabindex="-1" style="z-index: 9999999;" role="dialog" aria-labelledby="view_trainingModal_{{$std_id}}_Label" aria-hidden="true">
    <div class="modal-dialog modal-xl" style="max-width: 1140px;" role="document">
        <div class="modal-content">
          <div class="modal-header">
            <h5 class="modal-title m-auto" id="view_trainingModalLabel">{{__('home.trainings')}}</h5>
            <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
            </button>
          </div>
          
          <form method="Post" action="#">
              @csrf
              @if(!empty($trainings))
                  <div class="table-responsive">
                    <table class="table table-striped" style="margin: 3rem 3rem 3rem 3rem !important; width:92%"  id="">
                        <thead>
                            <tr>
                                <th >{{ trans('home.id') }}</th>
                                <th >{{ trans('home.training') }}</th>
                                <th >{{ trans('home.code') }}</th>
                                <th >{{ trans('home.center') }}</th>
                                <th >{{ trans('home.instructor') }}</th>
                                <th >{{ trans('home.online_link_or_location') }}</th>
                                <th >{{ trans('home.region') }}</th>
                                <th >{{ trans('home.area') }}</th>
                                <th >{{ trans('home.start_date') }}</th>
                                <th >{{ trans('home.end_date') }}</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($trainings as $training)
                                <tr id="{{ $training->training->id }}">
                                    <td>{{ $training->training->id }}</td>
                                    <td>{{ $training->training->{'name_'.$lang} ?? '' }}</td>
                                    <td>{{ $training->training->code }}</td>
                                    <td>{{ $training->training->trainings_schaduals->center->{'name_'.$lang} ?? '' }}</td>
                                    <td>{{ $training->training->instructor->f_name ?? '' }}</td>
                                    <td>{{ $training->training->trainings_schaduals->hall->map_url ?? '' }}</td>
                                    <td>{{ $training->training->trainings_schaduals->hall->region->{'name_'.$lang} ?? '' }}</td>
                                    <td>{{ $training->training->trainings_schaduals->hall->area->{'name_'.$lang} ?? '' }}</td>
                                    <td>
                                        {{\Carbon\Carbon::parse($training->training->trainings_schaduals->start_date)->format("d / m / Y")  }}
                                    </td>
                                    <td>
                                        {{\Carbon\Carbon::parse($training->training->trainings_schaduals->end_date)->format("d / m / Y")  }}
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                  </div>
             
              @else
                <h4 class="text-center p-5 text-danger">{{ trans('home.no_data_found_with_this_page') }}<h4>
              @endif
              <div class="modal-footer justify-content-center">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{__('home.close')}}</button>
                <!--<button type="submit" class="btn btn-primary col-2">{{__('home.save')}}</button>-->
              </div>
          </form>
        </div>
    </div>
</div>