@extends('layouts.admin')
@section('meta')
    <title>{{trans('home.schedule_students')}}</title>
@endsection
@section('content')

<div class="container-fluid">
    <!-- Page Header -->
    <div class="page-header">
        <div>
            <h2 class="main-content-title tx-24 mg-b-5">{{trans('home.search')}}</h2>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{route('admin')}}">{{trans('home.admin')}}</a></li>
                @can('students')
                    <li class="breadcrumb-item"><a href="{{route('students.index')}}">{{trans('home.students')}}</a></li>
                @endcan
                <li class="breadcrumb-item active" aria-current="page">{{trans('home.schedule_students')}}</li>
            </ol>
        </div>
    </div>
    <div class="row">
        <div class="col-sm-12 col-xl-12 col-lg-12">
        <!-- End Page Header -->
            <div class="card custom-card overflow-hidden">
                <div class="card-body">
                    <div>
                        <h6 class="card-title mb-1">{{trans('home.students')}}</h6>
                        <hr>
                    </div>
                    <div class="row">
                        <div class="form-group col-md-10">
                            {{-- <label class="">{{trans('home.students')}}</label>
                           <div class="row">
                                <div class="col-4">
                                    <label>{{ __('home.choose_training_by_name') }}</label>
                                    <select id="trainings" class="form-control select2 @error('training') is-invalid @enderror" name="training" required>
                                        <option value="">{{ __('home.choose_training') }}</option>
                                        <option value="all" @if(Request::segment(4) == 'all') selected @endif>{{ __('home.Select_all') }}</option>
                                        @foreach($trainings_selector as $training_selector)
                                            <option value="{{$training_selector->id}}" @if(Request::segment(4) == $training_selector->id) selected @endif>
                                                {{$training_selector->{'name_'.$lang} }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('country_id')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                                <div class="col-4">
                                    <label>{{ __('home.choose_training_by_code') }}</label>
                                    <select id="trainings_filter_2" class="form-control select2 @error('training') is-invalid @enderror" name="training" required>
                                        <option value="">{{ __('home.choose_training') }}</option>
                                        <option value="all" @if(Request::segment(4) == 'all') selected @endif>{{ __('home.Select_all') }}</option>
                                        @foreach($trainings_selector as $training_selector)
                                            <option value="{{$training_selector->id}}" @if(Request::segment(4) == $training_selector->id) selected @endif>
                                                {{$training_selector->code }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('country_id')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div> --}}


                        </div>   

                    </div>
                        {!! $dataTable->table(['class' => 'table table-bordered w-100']) !!}
                </div>
            </div>
        </div>
    </div>
</div>

@endsection

@section('script')
    <script>
        $('#trainings').change(function () {
            var id = $(this).val();
             var url = "{{url('admin/schedule_students')}}/"+id;
            window.location.href = url ;
        });
        $('#trainings_filter_2').change(function () {
            var id = $(this).val();
             var url = "{{url('admin/schedule_students')}}/"+id;
            window.location.href = url ;
        });
    </script>
    
    {!! $dataTable->scripts() !!}
    
     <script>
        function viewModel2(id){
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });
                $.ajax({
                    url: '{{route('viewtrainings.show')}}',
                    method: 'POST',
                    data: {
                        std_id: id,
                    },
                    success: function (response) {
                        $('#view_trainingModal').empty();
                        $('.main-content').append(response.view);
                        $('#view_trainingModal_'+id).modal('show');
                    }
                });
        }
    </script>
    
@endsection