@extends('layouts.admin')
<title>{{ trans('home.students') }}</title>
@section('content')
    <div class="container-fluid">

        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5">{{ trans('home.students') }}</h2>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('admin') }}">{{ trans('home.admin') }}</a></li>
                    <li class="breadcrumb-item active" aria-current="page">{{ trans('home.students') }}</li>
                </ol>
            </div>

            <div class="btn btn-list">

                <a href="{{ route('un_assign_student') }}"><button class="btn ripple btn-warning">
                   <i class="fas fa-times-circle"></i> {{ trans('home.delete_trainings_of_students') }}</button></a>
                <a class="mr-2" href="{{ route('assign_student') }}" id="assign_students" ><button class="btn ripple btn-info"><i
                            class="fas fa-plus-circle"></i> {{ trans('home.assign_students') }}</button></a>
                <a class="mr-2" href="{{ route('students.create') }}"><button class="btn ripple btn-primary"><i
                            class="fas fa-plus-circle"></i> {{ trans('home.add') }}</button></a>
                <a class="mr-2" id="btn_active"><button class="btn ripple btn-dark"><i class="fas fa-eye"></i>
                        {{ trans('home.publish/unpublish') }}</button></a>
                <a class="mr-2" id="btn_delete"><button class="btn ripple btn-danger"><i class="fas fa-trash"></i>
                        {{ trans('home.delete') }}</button></a>
            </div>
        </div>
        <!-- End Page Header -->

        @if (session()->has('success'))
            <div class="alert alert-success">
                {{ session()->pull('success') }}
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        @endif

        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1">{{ trans('home.students') }}</h6>
                            <p class="text-muted card-sub-title">
                                {{ trans('home.table_contain_all_data_shortly_you_can_view_more_details') }}</p>
                        </div>

                            <form method="post" action="{{ route('student.import.excel') }}" enctype="multipart/form-data">
                                @csrf
                                <div class="row">
                                    {{-- <label>{{trans('home.Exel')}}</label> --}}
                                    <div class="input-group mb-1 d-flex justify-content-first">
                                        <div class="input-group-prepend"> 
                                            <span class="input-group-text"> {{ trans('home.upload') }}</span>
                                        </div>
                                        <div class="custom-file col-3">
                                            <input type="file" class="custom-file-input" name="excelFile"  accept=".csv,.xlsx">
                                            <label class="custom-file-label"
                                                for="inputGroupFile01">{{ trans('home.choose_excel_file') }}</label>
                                        </div>
                                        <button class="btn ripple btn-primary mr-5" type="submit"><i
                                        class="fas fa-plus-circle"></i>
                                        {{ trans('home.importExcel') }}</button>
                                    </div>
                                        
                                    @error('excelFile')
                                        <div class="alert alert-danger">{{ $message }}</div>
                                    @enderror
                                </div>
                            </form>

                        <div class="table-responsive">
                            <table class="table data-table" id="exportexample">
                                <thead>
                                    <tr>
                                            <th>No</th>
                                            <th>Name</th>
                                            <!--<th>Email</th>-->
                                            <!--<th width="100px">Action</th>-->
                                        {{--
                                        <th><input type="checkbox" name="checkbox" class="tableChecked" id="checkAll"/></th>
                                        <th>{{ trans('home.id') }}</th>
                                        <th >{{ trans('home.ssn') }}</th>
                                        <th >{{ trans('home.name') }}</th>
                                        <th >{{ trans('home.email') }}</th>
                                        <th >{{ trans('home.phone') }}</th>
                                        <th >{{ trans('home.image') }}</th>
                                        <th >{{ trans('home.n_training') }}</th>
                                        <th >{{ trans('home.status') }}</th>
                                        --}}
                                    </tr>
                                </thead>
                                <tbody>
                                    {{--
                                    @foreach ($users as $user)
                                        <tr id="{{ $user->id }}">
                                            <td> <input type="checkbox" name="checkbox" class="tableChecked" value="{{ $user->id }}" /> </td>
                                            <td><a href="{{ route('students.edit', $user->id) }}">{{ $user->id }}</a>  </td>
                                            <td><a href="{{ route('students.edit', $user->id) }}">{{ $user->student_info? $user->student_info->ssn:'' }}</a>  </td>
                                            <td><a  href="{{ route('students.edit',$user->id) }}">{{ $user->name() }}</a> </td>
                                            <td><a  href="{{ route('students.edit',$user->id) }}">{{ $user->email}}</a> </td>
                                            <td><a  href="{{ route('students.edit',$user->id) }}">{{ $user->student_info? $user->student_info->mobile:''}}</a> </td>
                                            <td>
                                                <a href="{{ route('students.edit', $user->id) }}">
                                                    @if($user->image)
                                                        <img src={{url('uploads/users/source/'.$user->image)}} width="100">
                                                    @endif
                                                </a>
                                            </td>
                                            <td><a  href="{{ route('students.edit', $user->id) }}">{{ count($user->trainings)}}</a> </td>
                                            <td><a  href="{{ route('students.edit', $user->id) }}">{{ $user->status==1? __('home.active') : __('home.inactive') }}</a> </td>
                                           
                                        </tr>
                                    @endforeach
                                --}}
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
    </div>
@endsection
  
@section('script')



@endsection
