@extends('layouts.admin')
@section('meta')
    <title>{{trans('home.add_student')}}</title>
@endsection
@section('content')

<div class="container-fluid">
    <!-- Page Header -->
    <div class="page-header">
        <div>
            <h2 class="main-content-title tx-24 mg-b-5">{{trans('home.students')}}</h2>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{route('admin')}}">{{trans('home.admin')}}</a></li>
                <li class="breadcrumb-item"><a href="{{route('students.index')}}">{{trans('home.students')}}</a></li>
                <li class="breadcrumb-item active" aria-current="page">{{trans('home.add_student')}}</li>
            </ol>
        </div>
    </div>
    <div class="row">
        <div class="col-sm-12 col-xl-12 col-lg-12">
        <!-- End Page Header -->
            {!! Form::open(['route' => 'students.store', 'data-toggle'=>'validator', 'files'=>'true']) !!}
               
                @csrf
                <!--account_data-->
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1">{{trans('home.account_data')}}</h6>
                            <hr>
                        </div>
                        <div class="row">
                            <div class="form-group col-md-3">
                                <label class="">{{trans('home.ssn')}}</label>
                                <input class="form-control @error('ssn') is-invalid @enderror" name="ssn" type="text" placeholder="{{trans('home.ssn')}}" required value="{{ old('ssn') }}" >
                                @error('ssn')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            <div class="form-group col-md-3">
                                <label class="">{{trans('home.name')}}</label>
                                <input class="form-control @error('f_name') is-invalid @enderror" name="f_name" type="text" placeholder="{{trans('home.name')}}" required value="{{ old('f_name') }}" >
                                @error('f_name')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
    
                            <div class="form-group col-md-3">
                                <label class="">{{trans('home.email')}}</label>
                                <input class="form-control @error('email') is-invalid @enderror" name="email" type="text" placeholder="{{ trans('home.email') }}" value="{{ old('email') }}">
                                @error('email')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            
                            <div class="form-group col-md-3">
                                <label class="">{{trans('home.password')}}</label>
                                <input class="form-control area1 @error('password') is-invalid @enderror" name="password" type="password" placeholder="{{trans('home.password')}}"value="{{ old('password') }}">
                                @error('password')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            
                            <div class="col-md-3">
                                <label>{{trans('home.image')}}</label>
                                <div class="input-group mb-1">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text"> {{trans('home.upload')}}</span>
                                    </div>
                                    <div class="custom-file">
                                        <input type="file" class="custom-file-input  @error('image') is-invalid @enderror" name="image">
                                        <label class="custom-file-label" for="inputGroupFile01">{{trans('home.choose_image')}}</label>
                                    </div>
                                </div>
                                @error('image')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            <div class="form-group col-md-3">
                                <label class="">{{trans('home.mobile')}}</label>
                                <input class="form-control area1 @error('mobile') is-invalid @enderror" name="mobile" type="tel" required placeholder="{{trans('home.mobile')}}"value="{{ old('mobile') }}">
                                @error('mobile')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            <div class="form-group col-md-3">
                                <label class="">{{trans('home.whatsapp')}}</label>
                                <input class="form-control area1 @error('whatsapp') is-invalid @enderror" name="whatsapp" required type="tel" placeholder="{{trans('home.whatsapp')}}"value="{{ old('whatsapp') }}">
                                @error('whatsapp')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            @can('status_or_publish_field')
                            <div class="form-group col-md-3">
                                <label class="">{{trans('home.publish')}}</label>
                                <select class="form-control select2 " name="status" required id="">
                                    <option value="1" selected>{{ __('home.active') }}</option>
                                    <option value="0">{{ __('home.inactive') }}</option>
                                </select>
                            </div>
                            @endcan
                    </div>
                    </div>
                </div>
               
                <!--account_details-->
                <div class="card custom-card overflow-hidden">
                    <div class="card-body"> 
                        <div>
                            <h6 class="card-title mb-1">{{trans('home.account_details')}}</h6>
                            <hr>
                        </div>
                        <div class="row">
                        
                            <div class="form-group col-md-4">
                                <label class="">{{trans('home.general_specialization')}}</label>
                                <input class="form-control @error('general_specialization') is-invalid @enderror" name="general_specialization" type="text" placeholder="{{trans('home.general_specialization')}}" value="{{ old('general_specialization') }}" >
                                @error('general_specialization')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            <div class="form-group col-md-4">
                                <label class="">{{trans('home.accurate_specialization')}}</label>
                                <input class="form-control @error('accurate_specialization') is-invalid @enderror" name="accurate_specialization" type="text" placeholder="{{trans('home.accurate_specialization')}}" value="{{ old('accurate_specialization') }}" >
                                @error('accurate_specialization')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            <div class="form-group col-md-4">
                                <label class="">{{trans('home.job_title_Insurances')}}</label>
                                <input class="form-control @error('job_title_Insurances') is-invalid @enderror" name="job_title_Insurances" type="text" placeholder="{{trans('home.job_title_Insurances')}}" value="{{ old('job_title_Insurances') }}" >
                                @error('job_title_Insurances')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            <div class="form-group col-md-4">
                                <label class="">{{trans('home.job_title_ksa_classification')}}</label>
                                <input class="form-control @error('job_title_ksa_classification') is-invalid @enderror" name="job_title_ksa_classification" type="text" placeholder="{{trans('home.job_title_ksa_classification')}}" value="{{ old('job_title_ksa_classification') }}" >
                                @error('job_title_ksa_classification')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            <div class="form-group col-md-3">
                                <label class="">{{trans('home.qualification')}}</label>
                                <input class="form-control @error('qualification') is-invalid @enderror" name="qualification" type="text" placeholder="{{trans('home.qualification')}}" value="{{ old('qualification') }}" >
                                @error('qualification')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            <div class="form-group col-md-3">
                                <label class="">{{trans('home.company')}}</label>
                                <input class="form-control @error('company') is-invalid @enderror" name="company" type="text" placeholder="{{trans('home.company')}}" value="{{ old('company') }}" >
                                @error('company')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            
                            <div class="form-group col-md-2">
                                <label class="">{{trans('home.student_status')}}</label>
                                <select class="form-control select2  @error('student_status') is-invalid @enderror" name="student_status" id="">
                                        <option value="">{{ __('home.choose_status') }}</option>
                                        <option value="مقبول" @selected(old('student_status')=='مقبول')>{{trans('home.accepted')}}</option>
                                        <option value="مرفوض"  @selected(old('student_status')=='مرفوض')>{{trans('home.refused')}}</option>
                                </select>
                                @error('student_status')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            
                            <div class="form-group col-md-3">
                                <label class="">{{trans('home.registration_date')}}</label>
                                <div class="input-group">
                                    <input class="form-control datepicker @error('registration_date') is-invalid @enderror" name="registration_date" type="text" placeholder="{{trans('home.registration_date')}}" value="{{ old('registration_date') }}" >
                                    <div class="input-group-append">
                                        <span class="input-group-text">
                                            <i class="fas fa-calendar"></i>
                                        </span>
                                    </div>
                                </div>
                                @error('registration_date')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            
                            <div class="form-group col-md-3">
                                <label class="">{{trans('home.country')}}</label>
                                <select class="form-control select2 country @error('country_id') is-invalid @enderror" name="country_id" id="">
                                    <option value="">{{ __('home.choose_country') }}</option>
                                    
                                    @foreach($countries as $country)
                                        <option value="{{$country->id}}" @selected(old('country_id') == $country->id)>{{(app()->getLocale() == 'en')?$country->name_en:$country->name_ar}}</option>
                                    @endforeach
                                </select>
                                @error('country_id')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            
                            <div class="form-group col-md-3">
                                <label class="">{{trans('home.area')}}</label>
                                <select class="form-control select2 area @error('area_id') is-invalid @enderror" name="area_id">
                                    <option value="">{{ __('home.choose_area') }}</option>
                                    @if(old('area_id'))
                                            @php $area_old = App\Models\Area::find(old('area_id')); @endphp
                                            <option selected value="{{$area_old->id}}">{{(app()->getLocale() == 'en')?$area_old->name_en:$area_old->name_ar}}</option>
                                    @endif
                                </select>
                                @error('area_id')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            
                            <div class="form-group col-md-3">
                            <label class="">{{trans('home.region')}}</label>
                            <select class="form-control select2 region @error('region_id') is-invalid @enderror" name="region_id">
                                <option value="">{{ __('home.choose_region') }}</option>
                                @if(old('region_id'))
                                        @php $region_old = App\Models\Region::find(old('region_id')); @endphp
                                        <option selected value="{{$region_old->id}}">{{(app()->getLocale() == 'en')?$region_old->name_en:$region_old->name_ar}}</option>
                                @endif
                            </select>
                            @error('region_id')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                        
                        <div class="form-group col-md-3">
                            <label class="">{{trans('home.address')}}</label>
                            <input class="form-control @error('address') is-invalid @enderror" name="address" type="text" placeholder="{{trans('home.address')}}" value="{{ old('address') }}" >
                            @error('address')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                        <div class="form-group col-md-3">
                            <label class="">{{trans('home.building_num')}}</label>
                            <input class="form-control @error('building_num') is-invalid @enderror" name="building_num" type="number" placeholder="{{trans('home.building_num')}}" value="{{ old('building_num') }}" >
                            @error('building_num')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                        <div class="form-group col-md-3">
                            <label class="">{{trans('home.flat_num')}}</label>
                            <input class="form-control @error('flat_num') is-invalid @enderror" name="flat_num" type="number" placeholder="{{trans('home.flat_num')}}" value="{{ old('flat_num') }}" >
                            @error('flat_num')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                        <div class="form-group col-md-3">
                            <label class="">{{trans('home.land_mark')}}</label>
                            <input class="form-control @error('land_mark') is-invalid @enderror" name="land_mark" type="text" placeholder="{{trans('home.land_mark')}}" value="{{ old('land_mark') }}" >
                            @error('land_mark')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                        </div>
                        
                    </div>
                </div>
                 <!--training-->
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1">{{trans('home.training')}}</h6>
                            <hr>
                        </div>
                        <div class="row">
                           <div class="form-group col-md-12">
                                <label class="">{{trans('home.training')}}</label>
                                <select class="form-control select2  @error('training') is-invalid @enderror" name="trainings[]" multiple>
                                    <option value="">{{ __('home.choose_training') }}</option>
                                    @foreach($trainings as $training)
                                        <option value="{{$training->id}}" @selected(old('trainings[]') == $training->id) >{{ $training->code . ' - ' . $training->{'name_'.$lang} }}</option>
                                    @endforeach
                                </select>
                                @error('country_id')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div class="form-group col-md-12">
                            <button type="submit" class="btn btn-success"><i class="icon-note"></i> {{trans('home.save')}} </button>
                            <a href="{{route('students.index')}}"><button type="button" class="btn btn-danger mr-1"><i class="icon-trash"></i> {{trans('home.cancel')}}</button></a>
                        </div>
                    </div>
                </div>
                    
            {!! Form::close() !!}
        </div>
    </div>
</div>

@endsection

@section('script')
    <script>
        $('.country').change(function () {
            var id = $(this).val();
            var area = $('.area');
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                type: "POST",
                url: '{{url('admin/getAreas')  }}',
                data: {id: id},
                success: function( data ) {
                    var html = '';
                    html += '<option></option>'
                    for(var i=0;i<data.length;i++){
                        html += '<option  value="'+ data[i].id +'">@if(\App::getLocale() == 'en')'+ data[i].name_en +' @else '+ data[i].name_ar +' @endif</option>';
                    }
                    area.html(html);
                }
            });
        });

        $('.area').change(function () {
            var id = $(this).val();
            var region = $('.region');
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                type: "POST",
                url: '{{url('admin/getRegions')  }}',
                data: {id: id},
                success: function( data ) {
                    var html = '';
                    html += '<option></option>'
                    for(var i=0;i<data.length;i++){
                        html += '<option  value="'+ data[i].id +'">@if(\App::getLocale() == 'en')'+ data[i].name_en +' @else '+ data[i].name_ar +' @endif</option>';
                    }
                    region.html(html);
                }
            });
        });
    </script>
@endsection