@extends('layouts.admin')
@section('meta')
    <title>{{trans('home.edit_service')}}</title>
@endsection

@section('style')
<style>
    img {
        display:block !important;
    }
    .dz-hidden-input{
        position: absolute !important;
        top: 0px !important;
        left: 250px !important;
    }

</style>
<link href="https://cdnjs.cloudflare.com/ajax/libs/dropzone/4.0.1/min/dropzone.min.css" rel="stylesheet">
@endsection
@section('content')

<div class="container-fluid">
    <!-- Page Header -->
    <div class="page-header">
        <div>
            <h2 class="main-content-title tx-24 mg-b-5">{{trans('home.services')}}</h2>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{url('/admin')}}">{{trans('home.admin')}}</a></li>
                <li class="breadcrumb-item"><a href="{{url('admin/services')}}">{{trans('home.services')}}</a></li>
                <li class="breadcrumb-item active" aria-current="page">{{trans('home.edit_service')}}</li>
            </ol>
        </div>
    </div>
    <!-- End Page Header -->

    {!! Form::open(['method'=>'PATCH','url' => 'admin/services/'.$service->id, 'data-toggle'=>'validator', 'files'=>'true']) !!}
        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div>
                            <h6 class="card-title ">{{trans('home.edit_service')}}</h6>
                        </div>
                        <div class="row">
    
                            <div class="form-group col-md-2">
                                <label for="name_en">{{trans('home.name_en')}}</label>
                                <input type="text"  class="form-control" placeholder="{{trans('home.name_en')}}" name="name_en" value="{{$service->name_en}}" required>
                            </div>
    
                            <div class="form-group col-md-2">
                                <label for="name_ar">{{trans('home.name_ar')}}</label>
                                <input type="text"  class="form-control" placeholder="{{trans('home.name_ar')}}" name="name_ar" value="{{$service->name_ar}}">
                            </div>
    
                            <div class="form-group col-md-2">
                                <label for="youtube_link">{{trans('home.youtube_link')}}</label>
                                <input type="text"  class="form-control" placeholder="{{trans('home.youtube_link')}}" name="youtube_link" value="{{$service->youtube_link}}">
                            </div>
                            
                             
                            
                           {{--<div class="form-group col-md-2">
                                <label for="helperText">{{trans('home.parent')}}</label>
                                <select class="form-control select2" name="parent_id" required>
                                    <option value="0" {{($service->parent_id == 0)?'selected':''}}>{{trans('home.no_parent')}}</option>
                                    @foreach($services as $serv)
                                        <option value="{{$serv->id}}"  {{($serv->id ==$service->parent_id)?'selected':''}}>{{(app()->getLocale() == 'en')?$serv->name_en:$serv->name_ar}}</option>
                                    @endforeach
                                </select>
                            </div>--}}
                            
                            <div class="form-group col-md-1">
                                <label for="order">{{trans('home.order')}}</label>
                                <input type="number" min="0"  class="form-control" placeholder="{{trans('home.order')}}" name="order" value="{{$service->order}}">
                            </div>
                            
                            <div class="col-md-3">
                                <label>{{trans('home.image')}}</label>
                                <div class="input-group mb-1">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text"> {{trans('home.upload')}}</span>
                                    </div>
                                    <div class="custom-file">
                                        <input type="file" class="custom-file-input" name="img">
                                        <label class="custom-file-label" for="inputGroupFile01">{{trans('home.choose_image')}}</label>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="form-group col-md-2">
                                <label for="alt_img"> {{trans('home.alt_img')}}</label>
                                <input class="form-control" name="alt_img" type="text" placeholder="{{trans('home.alt_img')}}" value="{{$service->alt_img}}">
                            </div>
    
                            {{--<div class="col-md-4">
                                <label>{{trans('home.icon')}}</label>
                                <div class="input-group mb-1">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text"> {{trans('home.upload')}}</span>
                                    </div>
                                    <div class="custom-file">
                                        <input type="file" class="custom-file-input" name="icon">
                                        <label class="custom-file-label" for="inputGroupFile01">{{trans('home.choose_icon')}}</label>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="form-group col-md-2">
                                <label for="alt_icon"> {{trans('home.alt_icon')}}</label>
                                <input class="form-control" name="alt_icon" type="text" placeholder="{{trans('home.alt_icon')}}" value="{{$service->alt_icon}}">
                            </div>--}}
    
                            <div class="col-md-12">
                                <div class="row">
                                    @if($service->img)
                                        <div class="col-md-6">
                                            <img style="border-radius:50%" src="{{url('uploads/services/'.$service->img)}}" width="120">
                                        </div>
                                    @endif
    
                                    @if($service->icon)
                                        <div class="col-md-6">
                                            <img style="border-radius:50%" src="{{url('uploads/services/'.$service->icon)}}" width="120">
                                        </div>
                                    @endif
                                </div>
                            </div>
                            
                            <div class="form-group col-md-6">
                                <label for="short_text_en">{{trans('home.short_text_en')}}</label>
                                <textarea class="form-control" name="short_text_en" placeholder="{{trans('home.short_text_en')}}" >{!! $service->short_text_en !!}</textarea>
                            </div>
    
                            <div class="form-group col-md-6 "> 
                                <label for="short_text_ar">{{trans('home.short_text_ar')}}</label>
                                <textarea class="form-control" name="short_text_ar" placeholder="{{trans('home.short_text_ar')}}" >{!! $service->short_text_ar !!}</textarea>
                            </div>
    
                            <div class="form-group col-md-6">
                                <label for="text_en">{{trans('home.text_en')}}</label>
                                <textarea class="form-control area1" name="text_en" placeholder="{{trans('home.text_en')}}" >{!! $service->text_en !!}</textarea>
                            </div>
    
                            <div class="form-group col-md-6"> 
                                <label for="text_ar">{{trans('home.text_ar')}}</label>
                                <textarea class="form-control area1" name="text_ar" placeholder="{{trans('home.text_ar')}}" >{!! $service->text_ar !!}</textarea>
                            </div>
                            
                            <div class="form-group col-md-4">
                                <p class="mt-4 mb-2">{{trans('home.status')}}</p>
                                <label class="custom-switch">
                                    <input type="checkbox" name="status" value="1" class="custom-switch-input" {{($service->status == 1)? 'checked':''}}/>
                                    <span class="custom-switch-indicator"></span>
                                    <span class="custom-switch-description">{{trans('home.click_to_publish')}}</span>
                                </label>
                            </div>
                            
                            <div class="form-group col-md-4">
                                <p class="mt-4 mb-2">{{trans('home.menu')}}</p>
                                <label class="custom-switch">
                                    <input type="checkbox" name="menu" value="1" class="custom-switch-input" {{($service->menu == 1)? 'checked':''}}/>
                                    <span class="custom-switch-indicator"></span>
                                    <span class="custom-switch-description">{{trans('home.click_to_publish_in_menu')}}</span>
                                </label>
                            </div>
                        
                            
                            <div class="form-group col-md-4">
                                <p class="mt-4 mb-2">{{trans('home.home')}}</p>
                                <label class="custom-switch">
                                    <input type="checkbox" name="home" value="1" class="custom-switch-input" {{($service->home == 1)? 'checked':''}}/>
                                    <span class="custom-switch-indicator"></span>
                                    <span class="custom-switch-description">{{trans('home.click_to_publish_in_home')}}</span>
                                </label>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
    
       <!-- Row-->
        {{-- <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1">{{trans('home.servic_gallery')}}</h6>
                        </div>
                        <div class="row">
                            <div class="form-group col-md-12">
                                <hr>
                                <label for="images">{{trans('home.images')}}</label>
                                    <div class="dropzone col-md-12 upload_images">
                                </div>
                            </div>
                            
                            @if($service->images())
                                <div class="col-md-12">
                                    <div class="row serv">
                                        @foreach($service->images() as $key=>$image)
                                            <div class="col-xs-6 col-sm-2 col-md-2 col-xl-2 mb-2 pl-sm-2 pr-sm-2 service-img">
                                                <img class="img-responsive" src="{{url('uploads/services/'.$image->image)}}">
                                                <div class="del-btn">
                                                    <a href='javascrip:void()' data-image='{{$image->id}}' class='delete_img_btn btn-danger' >{{trans('home.delete')}}</a>
                                                </div>
                                            </div>
                                        @endforeach
                                    </div>
                                </div>
                            @endif
                        </div>
                    </div>
                </div>    
            </div>
        </div> --}}
        <!-- End Row -->
        
        <!-- Row-->
        {{-- <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1">{{trans('home.faqs')}}</h6>
                        </div>
                        <div class="row">
                            @if(count($questions) > 0)
                                @foreach($questions as $key=>$question)
                                    <div class="form-group col-md-2"> 
                                        <label for="question_en">{{trans('home.question_en')}}</label>
                                        <textarea class="form-control" placeholder="{{trans('home.question_en')}}" readonly>{{$question->question_en}}</textarea>
                                    </div>

                                    <div class="form-group col-md-3">
                                        <label for="answer_en">{{trans('home.answer_en')}}</label>
                                        <textarea class="form-control" placeholder="{{trans('home.answer_en')}}" readonly>{{$question->answer_en}}</textarea>
                                    </div>
                                    
                                    
                                    <div class="form-group col-md-2"> 
                                        <label for="question_ar">{{trans('home.question_ar')}}</label>
                                        <textarea class="form-control" placeholder="{{trans('home.question_ar')}}" readonly>{{$question->question_ar}}</textarea>
                                    </div>

                                    <div class="form-group col-md-3">
                                        <label for="answer_ar">{{trans('home.answer_ar')}}</label>
                                        <textarea class="form-control" placeholder="{{trans('home.answer_ar')}}" readonly>{{$question->answer_ar}}</textarea>
                                    </div>

                                    <div class="form-group col-md-2">
                                        <button type="button" style="margin-top: 28px;" class="btn" data-toggle="modal" data-target="#iconForm_{{$key}}"><i class="fas fa-edit"></i></button>
                                        <button type="button" style="margin-top: 28px;" class="btn rmv" data-faq_id="{{$question->id}}" id="type-error"><i class="fas fa-trash-alt"></i></button>
                                    </div>
                                @endforeach   
                                <div class="form-group col-md-12 text-center">
                                    <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#addfAQ"><i class="fas fa-plus-circle"></i> {{trans('home.add_faq')}} </button>
                                </div>
                            @else
                                <div class="form-group col-md-12 text-center">
                                    <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#addfAQ"><i class="fas fa-plus-circle"></i> {{trans('home.add_faq')}} </button>
                                </div>
                            @endif
                        </div>
                    </div>
                </div>    
            </div>
        </div> --}}
        <!-- End Row -->


        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1">{{trans('home.seo_block')}}</h6>
                        </div>
                        <div class="col-md-12 mb-3">
                            <label for="redirect_url">{{trans('home.redirect_url')}}</label>
                            <input type="text" class="form-control" value="{{ old('redirect_url',$service->redirect_url) }}" placeholder="{{trans('home.redirect_url')}}" name="redirect_url">
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <div class="row">
                                    <div class="form-group col-md-12">
                                        <hr>
                                        <span class="badge badge-success">{{trans('home.en')}}</span>
                                    </div>
                                    
                                    <div class="form-group col-md-2">
                                        <label for="link_en">{{trans('home.slug')}}</label>
                                        <input type="text" class="form-control" placeholder="{{trans('home.slug')}}" name="link_en" value="{{$service->link_en}}">
                                    </div>
                            
                                    <div class="form-group col-md-5">
                                        <label for="meta_title"> {{trans('home.meta_title')}}</label>
                                        <textarea class="form-control" name="meta_title_en" placeholder="{{trans('home.meta_title')}}">{{$service->meta_title_en}}</textarea>
                                    </div>
                                    
                                    <div class="form-group col-md-5">
                                        <label for="meta_desc"> {{trans('home.meta_desc')}}</label>
                                        <textarea class="form-control" name="meta_desc_en" placeholder="{{trans('home.meta_desc')}}">{{$service->meta_desc_en}}</textarea>
                                    </div>
                                    
                                    <div class="form-group col-md-12">
                                        <hr>
                                        <span class="badge badge-success">{{trans('home.ar')}}</span>
                                    </div>
                                    
                                    <div class="form-group col-md-2">
                                        <label for="link_ar">{{trans('home.slug')}}</label>
                                        <input type="text" class="form-control" placeholder="{{trans('home.slug')}}" name="link_ar" value="{{$service->link_ar}}">
                                    </div>
                                    
                                    <div class="form-group col-md-5">
                                        <label for="meta_title"> {{trans('home.meta_title')}}</label>
                                        <textarea class="form-control" name="meta_title_ar" placeholder="{{trans('home.meta_title')}}">{{$service->meta_title_ar}}</textarea>
                                    </div>
                                    
                                    <div class="form-group col-md-5">
                                        <label for="meta_desc"> {{trans('home.meta_desc')}}</label>
                                        <textarea class="form-control" name="meta_desc_ar" placeholder="{{trans('home.meta_desc')}}">{{$service->meta_desc_ar}}</textarea>
                                    </div>
                                    
                                    <div class="form-group col-md-12">
                                        <p class="mt-4 mb-2">{{trans('home.meta_robots')}}</p>
                                        <label class="custom-switch">
                                            <input type="checkbox" name="meta_robots" value="1" class="custom-switch-input" {{($service->meta_robots == 1)? 'checked':''}}>
                                            <span class="custom-switch-indicator"></span>
                                            <span class="custom-switch-description">{{trans('home.click_to_index')}}</span>
                                        </label>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>    
            </div>
        </div>
        <!-- End Row -->
        
        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div class="row">
                            <div class="form-group col-md-12">
                                <button type="submit" class="btn btn-success"><i class="icon-note"></i> {{trans('home.save')}} </button>
                                <a href="{{url('/admin/services')}}"><button type="button" class="btn btn-danger mr-1"><i class="icon-trash"></i> {{trans('home.cancel')}}</button></a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
    {!! Form::close() !!}
    
    <!-- add Modal --> 
    <div class="modal fade text-left" id="addfAQ" tabindex="-1" role="dialog" aria-labelledby="myModalLabel34" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h3 class="modal-title" id="myModalLabel34">{{trans('home.add_faq')}}</h3>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form action="{{route('storeServiceFaq')}}" method="post">
                    @csrf
                    <div class="modal-body">
                        <div class="row">
                            <div class="form-group col-md-6"> 
                                <label for="question_en">{{trans('home.question_en')}}</label>
                                <textarea class="form-control" placeholder="{{trans('home.question_en')}}" name="question_en"></textarea>
                            </div>

                            <div class="form-group col-md-6">
                                <label for="answer_en">{{trans('home.answer_en')}}</label>
                                <textarea class="form-control" placeholder="{{trans('home.answer_en')}}" name="answer_en"></textarea>
                            </div>

                            <div class="form-group col-md-6"> 
                                <label for="question_ar">{{trans('home.question_ar')}}</label>
                                <textarea class="form-control" placeholder="{{trans('home.question_ar')}}" name="question_ar"></textarea>
                            </div>

                            <div class="form-group col-md-6">
                                <label for="answer_ar">{{trans('home.answer_ar')}}</label>
                                <textarea class="form-control" placeholder="{{trans('home.answer_ar')}}" name="answer_ar"></textarea>
                            </div>
                            
                            <input type="hidden" name="service_id" value="{{$service->id}}"/>

                            <div class="form-group col-md-12">
                                <button type="submit" class="btn btn-success">{{trans('home.save')}} </button>
                            </div>
                        </div>                             
                    </div>
                </form>
            </div>
        </div>
    </div>
    
    <!-- edit Modal -->
    @foreach($questions as $key=>$question)
        <div class="modal fade text-left" id="iconForm_{{$key}}" tabindex="-1" role="dialog" aria-labelledby="myModalLabel34" aria-hidden="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h3 class="modal-title" id="myModalLabel34">{{trans('home.edit_faq')}}</h3>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <form action="{{route('updateServiceFaq')}}" method="post">
                        @csrf
                        <div class="modal-body">
                            <div class="row">
                                <div class="form-group col-md-6"> 
                                    <label for="question_en">{{trans('home.question_en')}}</label>
                                    <textarea class="form-control" placeholder="{{trans('home.question_en')}}" name="question_en">{{$question->question_en}}</textarea>
                                </div>
    
                                <div class="form-group col-md-6">
                                    <label for="answer_en">{{trans('home.answer_en')}}</label>
                                    <textarea class="form-control" placeholder="{{trans('home.answer_en')}}" name="answer_en">{{$question->answer_en}}</textarea>
                                </div>
                                
                                
                                <div class="form-group col-md-6"> 
                                    <label for="question_ar">{{trans('home.question_ar')}}</label>
                                    <textarea class="form-control" placeholder="{{trans('home.question_ar')}}" name="question_ar">{{$question->question_ar}}</textarea>
                                </div>
    
                                <div class="form-group col-md-6">
                                    <label for="answer_ar">{{trans('home.answer_ar')}}</label>
                                    <textarea class="form-control" placeholder="{{trans('home.answer_ar')}}" name="answer_ar">{{$question->answer_ar}}</textarea>
                                </div> 

                                <input type="hidden" name="faq_id" value="{{$question->id}}"/>

                                <div class="form-group col-md-12">
                                    <button type="submit" class="btn btn-success">{{trans('home.save')}} </button>
                                </div>
                            </div>                             
                        </div>
                    </form>
                </div>
            </div>
        </div>
    @endforeach
    
    
    
</div>

@endsection

@section('script')

    <script src="https://cdnjs.cloudflare.com/ajax/libs/dropzone/4.0.1/dropzone.js"></script>
    
    <script type="text/javascript">

        var token = "{{ csrf_token() }}";
        //Dropzone.autoDiscover = true;
        Dropzone.autoDiscover = false;

        $("div.upload_images").dropzone({
            
            addRemoveLinks: true,
            acceptedFiles: ".jpeg,.jpg,.png,.gif",
            url: "{{ URL::to('admin/services/uploadImages') }}",

            init: function() {
                this.on("sending", function(file, xhr, formData) {
                    formData.append("serviceId", {{$service->id}});
                });
            },
            
            params: {
                _token: token,
                type: 'product_image',
            },

            removedfile: function(file) {

                var fileName = file.name; 
                $.ajaxSetup({ headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') } });
                    $.ajax({
                    type: 'POST',
                    url: "{{ URL::to('admin/services/removeUploadImages') }}",
                    data: {type:'service_image',name: fileName,request: 'delete'},
                    sucess: function(data){
                        console.log('success: ' + data);
                    }
                });
                var _ref;
                return (_ref = file.previewElement) != null ? _ref.parentNode.removeChild(file.previewElement) : void 0;
            }

        });
        
    
        Dropzone.options.myAwesomeDropzone = {
            paramName: "file", // The name that will be used to transfer the file
            maxFilesize: 3, // MB
            accept: function(file, done) {

            },
        };
        
        $('.delete_img_btn').on('click',function(){
            var image = $(this).data('image');
            var serviceId={{$service->id}};
            var btn = $(this);
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                url:" {{url('admin/services/deleteImege')}}",
                method:'POST',
                data:{image:image , serviceId:serviceId },
                success:function(data)
                {
                    location.href = "{{route('services.edit',$service->id)}}";
                }
            });
        });
        
        
        $(document).ready(function(){
            $('.rmv').click(function () {
                var faq_id = $(this).data('faq_id');
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });
                $.ajax({
                    url:"{{route('removeServiceFaq')}}",
                    method:'POST',
                    data: {faq_id:faq_id},
                    success:function(data) {
                        location.reload();
                    }
                });
            });
            
        });

    </script>
    
@endsection