@extends('layouts.admin')
@section('meta')
    <title>{{trans('home.add_service')}}</title>
@endsection
@section('content')

<div class="container-fluid">
    <!-- Page Header -->
    <div class="page-header">
        <div>
            <h2 class="main-content-title tx-24 mg-b-5">{{trans('home.services')}}</h2>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{url('/admin')}}">{{trans('home.admin')}}</a></li>
                <li class="breadcrumb-item"><a href="{{url('admin/services')}}">{{trans('home.services')}}</a></li>
                <li class="breadcrumb-item active" aria-current="page">{{trans('home.add_service')}}</li>
            </ol>
        </div>
    </div>
    <!-- End Page Header -->

    {!! Form::open(['route' => 'services.store', 'data-toggle'=>'validator', 'files'=>'true']) !!}
        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div>
                            <h6 class="card-title ">{{trans('home.add_service')}}</h6>
                            <hr>
                        </div>
                        
                        <div class="row">

                            <div class="form-group col-md-2">
                                <label for="name_en">{{trans('home.name_en')}}</label>
                                <input type="text"  class="form-control" placeholder="{{trans('home.name_en')}}" name="name_en" required>
                            </div>

                            <div class="form-group col-md-2">
                                <label for="name_ar">{{trans('home.name_ar')}}</label>
                                <input type="text"  class="form-control" placeholder="{{trans('home.name_ar')}}" name="name_ar">
                            </div>
                         
                            <div class="form-group col-md-2">
                                <label for="youtube_link">{{trans('home.youtube_link')}}</label>
                                <input type="text"  class="form-control" placeholder="{{trans('home.youtube_link')}}" name="youtube_link">
                            </div>
                            
                           {{--  <div class="form-group col-md-2">
                                <label for="helperText">{{trans('home.parent')}}</label>
                                <select class="form-control select2" name="parent_id" required>
                                    <option value="0">{{trans('home.no_parent')}}</option>
                                    @foreach($services as $serv)
                                        <option value="{{$serv->id}}">{{(app()->getLocale() == 'en')?$serv->name_en:$serv->name_ar}}</option>
                                    @endforeach
                                </select>
                            </div>--}}
                            
                             <div class="form-group col-md-1">
                                <label for="order">{{trans('home.order')}}</label>
                                <input type="number" min="0"  class="form-control" placeholder="{{trans('home.order')}}" name="order">
                            </div>
                            
                            <div class="col-md-3">
                                <label>{{trans('home.image')}}</label>
                                <div class="input-group mb-1">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text"> {{trans('home.upload')}}</span>
                                    </div>
                                    <div class="custom-file">
                                        <input type="file" class="custom-file-input" name="img">
                                        <label class="custom-file-label" for="inputGroupFile01">{{trans('home.choose_image')}}</label>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="form-group col-md-2">
                                <label for="alt_img"> {{trans('home.alt_img')}}</label>
                                <input class="form-control" name="alt_img" type="text" placeholder="{{trans('home.alt_img')}}">
                            </div>

                            {{--<div class="col-md-4">
                                <label>{{trans('home.icon')}}</label>
                                <div class="input-group mb-1">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text"> {{trans('home.upload')}}</span>
                                    </div>
                                    <div class="custom-file">
                                        <input type="file" class="custom-file-input" name="icon">
                                        <label class="custom-file-label" for="inputGroupFile01">{{trans('home.choose_icon')}}</label>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="form-group col-md-2">
                                <label for="alt_icon"> {{trans('home.alt_icon')}}</label>
                                <input class="form-control" name="alt_icon" type="text" placeholder="{{trans('home.alt_icon')}}">
                            </div>--}}
                            
                            <div class="form-group col-md-6 ">
                                <label for="short_text_en">{{trans('home.short_text_en')}}</label>
                                <textarea class="form-control" name="short_text_en" placeholder="{{trans('home.short_text_en')}}" ></textarea>
                            </div>

                            <div class="form-group col-md-6 "> 
                                <label for="short_text_ar">{{trans('home.short_text_ar')}}</label>
                                <textarea class="form-control" name="short_text_ar" placeholder="{{trans('home.short_text_ar')}}" ></textarea>
                            </div>

                            <div class="form-group col-md-6">
                                <label for="text_en">{{trans('home.text_en')}}</label>
                                <textarea class="form-control area1" name="text_en" placeholder="{{trans('home.text_en')}}" ></textarea>
                            </div>

                            <div class="form-group col-md-6 "> 
                                <label for="text_ar">{{trans('home.text_ar')}}</label>
                                <textarea class="form-control area1" name="text_ar" placeholder="{{trans('home.text_ar')}}" ></textarea>
                            </div>
                            
                            <div class="form-group col-md-4">
                                <p class="mt-4 mb-2">{{trans('home.status')}}</p>
                                <label class="custom-switch">
                                    <input type="checkbox" name="status" value="1" class="custom-switch-input"/>
                                    <span class="custom-switch-indicator"></span>
                                    <span class="custom-switch-description">{{trans('home.click_to_publish')}}</span>
                                </label>
                            </div>
                            
                            <div class="form-group col-md-4">
                                <p class="mt-4 mb-2">{{trans('home.menu')}}</p>
                                <label class="custom-switch">
                                    <input type="checkbox" name="menu" value="1" class="custom-switch-input"/>
                                    <span class="custom-switch-indicator"></span>
                                    <span class="custom-switch-description">{{trans('home.click_to_publish_in_menu')}}</span>
                                </label>
                            </div>
                        
                            
                            <div class="form-group col-md-4">
                                <p class="mt-4 mb-2">{{trans('home.home')}}</p>
                                <label class="custom-switch">
                                    <input type="checkbox" name="home" value="1" class="custom-switch-input"/>
                                    <span class="custom-switch-indicator"></span>
                                    <span class="custom-switch-description">{{trans('home.click_to_publish_in_home')}}</span>
                                </label>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
        
        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1">{{trans('home.seo_block')}}</h6>
                        </div>
                        <div class="col-md-12 mb-3">
                            <label for="redirect_url">{{trans('home.redirect_url')}}</label>
                            <input type="text" class="form-control" value="{{ old('redirect_url') }}" placeholder="{{trans('home.redirect_url')}}" name="redirect_url">
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <div class="row">
                                    <div class="form-group col-md-12">
                                        <hr>
                                        <span class="badge badge-success">{{trans('home.en')}}</span>
                                    </div>
                                    
                                    <div class="form-group col-md-2">
                                        <label for="name_ar">{{trans('home.link')}}</label>
                                        <input type="text" autocomplete="off"  class="form-control" placeholder="{{trans('home.link')}}" name="link_en">
                                    </div> 
                                        
                                    <div class="form-group col-md-5">
                                        <label for="meta_title"> {{trans('home.meta_title')}}</label>
                                        <textarea class="form-control" name="meta_title_en" placeholder="{{trans('home.meta_title')}}"></textarea>
                                    </div>
                                    
                                    <div class="form-group col-md-5">
                                        <label for="meta_desc"> {{trans('home.meta_desc')}}</label>
                                        <textarea class="form-control" name="meta_desc_en" placeholder="{{trans('home.meta_desc')}}"></textarea>
                                    </div>
                                    
                                    <div class="form-group col-md-12">
                                        <hr>
                                        <span class="badge badge-success">{{trans('home.ar')}}</span>
                                    </div>
                                    
                                    <div class="form-group col-md-2">
                                        <label for="name_ar">{{trans('home.link')}}</label>
                                        <input type="text" autocomplete="off"  class="form-control" placeholder="{{trans('home.link')}}" name="link_ar">
                                    </div>
                                    
                                    <div class="form-group col-md-5">
                                        <label for="meta_title"> {{trans('home.meta_title')}}</label>
                                        <textarea class="form-control" name="meta_title_ar" placeholder="{{trans('home.meta_title')}}"></textarea>
                                    </div>
                                    
                                    <div class="form-group col-md-5">
                                        <label for="meta_desc"> {{trans('home.meta_desc')}}</label>
                                        <textarea class="form-control" name="meta_desc_ar" placeholder="{{trans('home.meta_desc')}}"></textarea>
                                    </div>
                                    
                                    <div class="form-group col-md-12">
                                        <p class="mt-4 mb-2">{{trans('home.meta_robots')}}</p>
                                        <label class="custom-switch">
                                            <input type="checkbox" name="meta_robots" value="1" class="custom-switch-input">
                                            <span class="custom-switch-indicator"></span>
                                            <span class="custom-switch-description">{{trans('home.click_to_index')}}</span>
                                        </label>
                                    </div>
                                </div>
                            <div>
                        </div>                                
                    </div>
                </div>
                    </div>
                </div>    
            </div>
        </div>
        <!-- End Row -->
        
        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div class="row">
                            <div class="form-group col-md-12">
                                <button type="submit" class="btn btn-success"><i class="icon-note"></i> {{trans('home.save')}} </button>
                                <a href="{{url('/admin/services')}}"><button type="button" class="btn btn-danger mr-1"><i class="icon-trash"></i> {{trans('home.cancel')}}</button></a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
    {!! Form::close() !!}
</div>

@endsection

