@extends('layouts.admin')
<title>{{trans('home.serviceCategories')}}</title>
@section('content')
<div class="container-fluid">

    <!-- Page Header -->
    <div class="page-header">
        <div>
            <h2 class="main-content-title tx-24 mg-b-5">{{trans('home.serviceCategories')}}</h2>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{url('/admin')}}">{{trans('home.admin')}}</a></li>
                <li class="breadcrumb-item active" aria-current="page">{{trans('home.serviceCategories')}}</li>
            </ol>
        </div>
        
        <div class="btn btn-list">
            <a href="{{url('admin/service-categories/create')}}"><button class="btn ripple btn-primary"><i class="fas fa-plus-circle"></i> {{trans('home.add')}}</button></a>
            <a id="btn_active"><button class="btn ripple btn-dark"><i class="fas fa-eye"></i> {{trans('home.publish/unpublish')}}</button></a>
            <a id="btn_delete" ><button class="btn ripple btn-danger"><i class="fas fa-trash"></i> {{trans('home.delete')}}</button></a>
        </div>
    </div>
    <!-- End Page Header -->

    <!-- Row-->
    <div class="row">
        <div class="col-sm-12 col-xl-12 col-lg-12">
            <div class="card custom-card overflow-hidden">
                <div class="card-body">
                    <div>
                        <h6 class="card-title mb-1">{{trans('home.serviceCategories')}}</h6>
                        <p class="text-muted card-sub-title">{{trans('home.table_contain_all_data_shortly_you_can_view_more_details')}}</p>
                        <hr>
                    </div>

                    <div class="table-responsive">
                    <table class="table" id="exportexample">
                        <thead>
                            <tr>
                                <th><input type="checkbox" name="checkbox" class="tableChecked" id="checkAll"/></th>
                                <th>{{trans('home.id')}}</th>
                                <th>{{trans('home.name_en')}}</th>
                                <th>{{trans('home.name_ar')}}</th>
                                <th>{{trans('home.status')}}</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($serviceCategories as $serviceCategory)
                                <tr id="{{$serviceCategory->id}}">
                                    <td> <input type="checkbox" name="checkbox"  class="tableChecked" value="{{$serviceCategory->id}}" /> </td>
                                    <td><a href="{{ route('service-categories.edit', $serviceCategory->id) }}">{{$serviceCategory->id}}</a></td>
                                    <td><a href="{{ route('service-categories.edit', $serviceCategory->id) }}">{{$serviceCategory->name_en}}</a></td>
                                    <td><a href="{{ route('service-categories.edit', $serviceCategory->id) }}">{{$serviceCategory->name_ar}}</a></td>
                                    <td>
                                        <a href="{{ route('service-categories.edit', $serviceCategory->id) }}">
                                            @if($serviceCategory->status == 1)
                                                <span class="badge badge-success">{{trans('home.yes')}}</span>
                                            @else
                                                <span class="badge badge-danger">{{trans('home.no')}}</span>
                                            @endif
                                        </a>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
				</div>
                </div>
            </div>
        </div>
    </div>
    <!-- End Row -->
    
</div>
@endsection

