@extends('layouts.admin')
<title>{{trans('home.job_seekers_reports')}}</title>
@section('content')

<div class="container-fluid">
        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5">{{trans('home.job_seekers_reports')}}</h2>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{url('/admin')}}">{{trans('home.admin')}}</a></li>
                    <li class="breadcrumb-item active" aria-current="page">{{trans('home.job_seekers_reports')}}</li>
                </ol>
            </div>
        </div>
        <!-- End Page Header -->
        
        <div class="row">
        <!--courses-->
        
        <div class="col-sm-6 col-md-4 col-xl-3">
			<div class="card custom-card">
				<div class="card-body text-center">
					<div class="icon-service bg-success-transparent rounded-circle text-success">
					    <i class="far fa-registered"></i>
					</div>
					<p class="mb-1 text-muted">{{trans('home.registered_count')}}</p>
					<h3 class="mb-0">{{$registered_count}}</h3>
				</div>
			</div>
		</div>
		<div class="col-sm-6 col-md-4 col-xl-3">
			<div class="card custom-card">
				<div class="card-body text-center">
					<div class="icon-service bg-primary-transparent rounded-circle text-primary">
					    <i class="fas fa-building"></i>
					</div>
					<p class="mb-1 text-muted">{{trans('home.gada_count')}}</p>
					<h3 class="mb-0">{{$gada_count}}</h3>
				</div>
			</div>
		</div>
		<div class="col-sm-6 col-md-4 col-xl-3">
			<div class="card custom-card">
				<div class="card-body text-center">
					<div class="icon-service bg-info-transparent rounded-circle text-info">
						<i class="fas fa-city"></i>
					</div>
					<p class="mb-1 text-muted">{{trans('home.riyadh_count')}}</p>
					<h3 class="mb-0">{{$riyadh_count}}</h3>
				</div>
			</div>
		</div>
		<div class="col-sm-6 col-md-4 col-xl-3">
			<div class="card custom-card">
				<div class="card-body text-center">
					<div class="icon-service bg-secondary-transparent rounded-circle text-secondary">
						<i class="fas fa-synagogue"></i>
					</div>
					<p class="mb-1 text-muted">{{trans('home.other_region_count')}}</p>
					<h3 class="mb-0">{{$other_region_count}}</h3>
				</div>
			</div>
		</div>
		<div class="col-sm-6 col-md-4 col-xl-3">
			<div class="card custom-card">
				<div class="card-body text-center">
					<div class="icon-service bg-danger-transparent rounded-circle text-danger">
						<i class="fas fa-male"></i>
					</div>
					<p class="mb-1 text-muted">{{trans('home.male_count')}}</p>
					<h3 class="mb-0">{{$male_count}}</h3>
				</div>
			</div>
		</div>
		<div class="col-sm-6 col-md-4 col-xl-3">
			<div class="card custom-card">
				<div class="card-body text-center">
					<div class="icon-service bg-success-transparent rounded-circle text-success">
						<i class="fas fa-female"></i>
					</div>
					<p class="mb-1 text-muted">{{trans('home.female_count')}}</p>
					<h3 class="mb-0">{{$female_count}}</h3>
				</div>
			</div>
		</div>
		<div class="col-sm-6 col-md-4 col-xl-3">
			<div class="card custom-card">
				<div class="card-body text-center">
					<div class="icon-service bg-primary-transparent rounded-circle text-primary">
						<i class="fas fa-university"></i>
					</div>
					<p class="mb-1 text-muted">{{trans('home.university_count')}}</p>
					<h3 class="mb-0">{{$university_count}}</h3>
				</div>
			</div>
		</div>
		<div class="col-sm-6 col-md-4 col-xl-3">
			<div class="card custom-card">
				<div class="card-body text-center">
					<div class="icon-service bg-info-transparent rounded-circle text-info">
						<i class="fas fa-graduation-cap"></i>
					</div>
					<p class="mb-1 text-muted">{{trans('home.diploma_count')}}</p>
					<h3 class="mb-0">{{$diploma_count}}</h3>
				</div>
			</div>
		</div>
		<div class="col-sm-6 col-md-4 col-xl-3">
			<div class="card custom-card">
				<div class="card-body text-center">
					<div class="icon-service bg-secondary-transparent rounded-circle text-secondary">
						<i class="fas fa-award"></i>
					</div>
					<p class="mb-1 text-muted">{{trans('home.secondary_count')}}</p>
					<h3 class="mb-0">{{$secondary_count}}</h3>
				</div>
			</div>
		</div>
		<div class="col-sm-6 col-md-4 col-xl-3">
			<div class="card custom-card">
				<div class="card-body text-center">
					<div class="icon-service bg-danger-transparent rounded-circle text-danger">
						<i class="fas fa-medal"></i>
					</div>
					<p class="mb-1 text-muted">{{trans('home.intermediate_count')}}</p>
					<h3 class="mb-0">{{$intermediate_count}}</h3>
				</div>
			</div>
		</div>
		
	    {{--@can('deserved_certificate_students_count')
		    <div class="col-sm-6 col-md-4 col-xl-3">
				<a href="{{route('students.index')}}" class="filter_type" data-filter="instructors">
				    <div class="card custom-card">
						<div class="card-body text-center">
							<div class="icon-service bg-danger-transparent rounded-circle text-danger">
							    <i class="fas fa-street-view"></i>
							</div>
							<p class="mb-1 text-muted">{{trans('home.n_deserved_certificate_students_count')}}</p>
							<h3 class="mb-0">{{$n_deserved_certificate_students_count}}</h3>
						</div>
					</div> 
				</a>
			</div>
		@endcan--}}
    </div>

    </div>

@endsection