@extends('layouts.admin')
<title>{{trans('home.all_reports')}}</title>
@section('content')

<div class="container-fluid">
        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5">{{trans('home.all_reports')}}</h2>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{url('/admin')}}">{{trans('home.admin')}}</a></li>
                    <li class="breadcrumb-item active" aria-current="page">{{trans('home.all_reports')}}</li>
                </ol>
            </div>
        </div>
        <!-- End Page Header -->
        
        <div class="row">
        <!--courses-->
		@can('dashboard_courses_count')
		    <div class="col-sm-6 col-md-4 col-xl-3">
			    <a href="{{route('courses.index')}}">
					<div class="card custom-card">
						<div class="card-body text-center">
							<div class="icon-service bg-success-transparent rounded-circle text-success">
							    <i class="far fa-file-video"></i>
							</div>
							<p class="mb-1 text-muted">{{trans('home.n_courses')}}</p>
							<h3 class="mb-0">{{$n_courses}}</h3>
						</div>
					</div>
				</a>
			</div>
		@endcan
    	<!--trainings-->
    	@can('dashboard_trainings_count')
    	    <div class="col-sm-6 col-md-4 col-xl-3">
			    <a href="{{route('trainings.index')}}">
					<div class="card custom-card">
						<div class="card-body text-center">
							<div class="icon-service bg-success-transparent rounded-circle text-success">
							    <i class="fas fa-chalkboard-teacher"></i>
							</div>
							<p class="mb-1 text-muted">{{trans('home.trainings')}}</p>
							<h3 class="mb-0">{{$n_trainings}}</h3>
						</div>
					</div>
				</a>
			</div>
    	
		@endcan
		<!--partners-->
		@can('dashboard_partners_count')
		
		    <div class="col-sm-6 col-md-4 col-xl-3">
			    <a href="{{url('admin/schedule_users/partner')}}">
					<div class="card custom-card">
						<div class="card-body text-center">
							<div class="icon-service bg-success-transparent rounded-circle text-success">
							    <i class="fas fa-handshake"></i>
							</div>
							<p class="mb-1 text-muted">{{trans('home.n_partners')}}</p>
							<h3 class="mb-0">{{$n_partners}}</h3>
						</div>
					</div>
				</a>
			</div>
		
		@endcan
		<!--centers-->
		@can('dashboard_centers_count')
		
		    <div class="col-sm-6 col-md-4 col-xl-3">
				<a href="{{route('centers.index')}}" class="filter_type" data-filter="instructors">
				    <div class="card custom-card">
						<div class="card-body text-center">
							<div class="icon-service bg-success-transparent rounded-circle text-success">
							    <i class="fas fa-university"></i>
							</div>
							<p class="mb-1 text-muted">{{trans('home.n_centers')}}</p>
							<h3 class="mb-0">{{$n_centers}}</h3>
						</div>
					</div> 
				</a>
			</div>
		
		
		@endcan
		<!--students-->
		@can('dashboard_students_count')
		   <div class="col-sm-6 col-md-4 col-xl-3">
			    <a href="{{route('students.index')}}">
					<div class="card custom-card">
						<div class="card-body text-center">
							<div class="icon-service bg-primary-transparent rounded-circle text-primary">
								<i class="fab fa-slideshare"></i>
							</div>
							<p class="mb-1 text-muted">{{trans('home.n_students')}}</p>
							<h3 class="mb-0">{{$n_students}}</h3>
						</div>
					</div>
				</a>
			</div>
		
		@endcan
		<!--instructors-->
		@can('dashboard_instructors_count')
		
		    
		    <div class="col-sm-6 col-md-4 col-xl-3">
			    <a href="{{url('admin/instructors')}}">
					<div class="card custom-card">
						<div class="card-body text-center">
							<div class="icon-service bg-primary-transparent rounded-circle text-primary">
								<i class="fas fa-user-tie"></i>
							</div>
							<p class="mb-1 text-muted">{{trans('home.n_instructors')}}</p>
							<h3 class="mb-0">{{$n_instructors}}</h3>
						</div>
					</div>
				</a>
			</div>
		
		@endcan
		<!--super_admins-->
		@can('dashboard_super_admins_count')
		
		    <div class="col-sm-6 col-md-4 col-xl-3">
			    <a href="{{url('admin/schedule_users/super_admin')}}" class="filter_type" data-filter="students">
					<div class="card custom-card">
						<div class="card-body text-center">
							<div class="icon-service bg-primary-transparent rounded-circle text-primary">
								<i class="fab fa-slideshare"></i>
							</div>
							<p class="mb-1 text-muted">{{trans('home.n_super_admins')}}</p>
							<h3 class="mb-0">{{$n_super_admins}}</h3>
						</div>
					</div>
				</a>
			</div>
		@endcan
		{{--
		<!--admins-->
		@can('dashboard_admins_count')
		<div class="col-sm-6 col-xl-4 col-lg-6">
			<div class="card custom-card">
				<div class="card-body dash1">
					<div class="d-flex">
						<p class="mb-1 tx-inverse">{{trans('home.admins')}}</p>
						<div class="ml-auto">
							<i class="fas fa-signal fs-20 text-info"></i>
						</div>
					</div>
					<div>
						<h3 class="dash-25">{{$n_admins}}</h3>
					</div>
					<div class="progress mb-1">
						<div aria-valuemax="100" aria-valuemin="0" aria-valuenow="70" class="progress-bar progress-bar-xs wd-40p" role="progressbar"></div>
					</div>
					<div class="expansion-label d-flex text-muted">
						<span class="text-muted">{{trans('home.n_admins')}}</span>
					</div>
				</div>
			</div>
		</div>
		@endcan
		--}}
		<!--coordinators-->
		@can('dashboard_coordinators_count')
		    <div class="col-sm-6 col-md-4 col-xl-3">
			    <a href="{{url('admin/schedule_users/coordinator')}}">
					<div class="card custom-card">
						<div class="card-body text-center">
							<div class="icon-service bg-primary-transparent rounded-circle text-primary">
								<i class="fas fa-user-clock"></i>
							</div>
							<p class="mb-1 text-muted">{{trans('home.n_coordinators')}}</p>
							<h3 class="mb-0">{{$n_coordinators}}</h3>
						</div>
					</div>
				</a>
			</div>
		@endcan
		<!--coordinators-->
		@can('dashboard_marketers_count')
		
		    <div class="col-sm-6 col-md-4 col-xl-3">
			    <a href="{{url('admin/schedule_users/marketer')}}">
					<div class="card custom-card">
						<div class="card-body text-center">
							<div class="icon-service bg-info-transparent rounded-circle text-info">
							    <i class="fas fa-city fa-xs"></i>
							</div>
							<p class="mb-1 text-muted">{{trans('home.n_marketers')}}</p>
							<h3 class="mb-0">{{$n_marketers}}</h3>
						</div>
					</div>
				</a>
			</div>
		
		@endcan
		
		
		@can('dashboard_finished_courses_count')
		    <div class="col-sm-6 col-md-4 col-xl-3">
			    <a href="{{route('trainings.index')}}">
					<div class="card custom-card">
						<div class="card-body text-center">
							<div class="icon-service bg-info-transparent rounded-circle text-info">
							    <i class="fas fa-hourglass-end"></i>
							</div>
							<p class="mb-1 text-muted">{{trans('home.n_finished_courses')}}</p>
							<h3 class="mb-0">{{$n_finished_courses}}</h3>
						</div>
					</div>
				</a>
			</div>
		
		@endcan
		
		
		@can('dashboard_started_courses_count')
		
		    <div class="col-sm-6 col-md-4 col-xl-3">
			    <a href="{{route('trainings.index')}}">
					<div class="card custom-card">
						<div class="card-body text-center">
							<div class="icon-service bg-info-transparent rounded-circle text-info">
							    <i class="fas fa-play"></i>
							</div>
							<p class="mb-1 text-muted">{{trans('home.n_started_courses')}}</p>
							<h3 class="mb-0">{{$n_started_courses}}</h3>
						</div>
					</div>
				</a>
			</div>
		@endcan

		
		@can('dashboard_not_started_courses_count')
		
		    <div class="col-sm-6 col-md-4 col-xl-3">
				<a href="{{route('trainings.index')}}" class="filter_type" data-filter="instructors">
				    <div class="card custom-card">
						<div class="card-body text-center">
							<div class="icon-service bg-info-transparent rounded-circle text-info">
							     <i class="fas fa-minus-circle"></i>
							</div>
							<p class="mb-1 text-muted">{{trans('home.n_not_started_courses')}}</p>
							<h3 class="mb-0">{{$n_not_started_courses}}</h3>
						</div>
					</div> 
				</a>
			</div>
		
		@endcan
		    
	   {{-- @can('male_count')
		
		    <div class="col-sm-6 col-md-4 col-xl-3">
				<a href="{{route('trainings.index')}}" class="filter_type" data-filter="instructors">
				    <div class="card custom-card">
						<div class="card-body text-center">
							<div class="icon-service bg-danger-transparent rounded-circle text-danger">
							    <i class="fas fa-user-tie"></i>
							</div>
							<p class="mb-1 text-muted">{{trans('home.n_male_count')}}</p>
							<h3 class="mb-0">{{$n_not_started_courses}}</h3>
						</div>
					</div> 
				</a>
			</div>
		@endcan
		@can('female_count')
		    <div class="col-sm-6 col-md-4 col-xl-3">
				<a href="{{route('trainings.index')}}" class="filter_type" data-filter="instructors">
				    <div class="card custom-card">
						<div class="card-body text-center">
							<div class="icon-service bg-danger-transparent rounded-circle text-danger">
							    <i class="fas fa-user-tie"></i>
							</div>
							<p class="mb-1 text-muted">{{trans('home.n_female_count')}}</p>
							<h3 class="mb-0">{{$n_not_started_courses}}</h3>
						</div>
					</div> 
				</a>
			</div>
		@endcan --}}
		
		@can('trainings_regions_count')
		
		    <div class="col-sm-6 col-md-4 col-xl-3">
				<a href="{{route('trainings.index')}}" class="filter_type" data-filter="instructors">
				    <div class="card custom-card">
						<div class="card-body text-center">
							<div class="icon-service bg-danger-transparent rounded-circle text-danger">
							    <i class="fas fa-user-tie"></i>
							</div>
							<p class="mb-1 text-muted">{{trans('home.n_trainings_regions_count')}}</p>
							<h3 class="mb-0">{{$n_trainings_regions_count}}</h3>
						</div>
					</div> 
				</a>
			</div>
		@endcan
		@can('filled_surveys_count')
		
		    <div class="col-sm-6 col-md-4 col-xl-3">
				<a href="{{route('surveys_results.index')}}" class="filter_type" data-filter="instructors">
				    <div class="card custom-card">
						<div class="card-body text-center">
							<div class="icon-service bg-danger-transparent rounded-circle text-danger">
							    <i class="fas fa-poll-h"></i>
							</div>
							<p class="mb-1 text-muted">{{trans('home.n_filled_surveys_count')}}</p>
							<h3 class="mb-0">{{$n_filled_surveys_count}}</h3>
						</div>
					</div> 
				</a>
			</div>
		
		@endcan
	    @can('deserved_certificate_students_count')
		    <div class="col-sm-6 col-md-4 col-xl-3">
				<a href="{{route('students.index')}}" class="filter_type" data-filter="instructors">
				    <div class="card custom-card">
						<div class="card-body text-center">
							<div class="icon-service bg-danger-transparent rounded-circle text-danger">
							    <i class="fas fa-street-view"></i>
							</div>
							<p class="mb-1 text-muted">{{trans('home.n_deserved_certificate_students_count')}}</p>
							<h3 class="mb-0">{{$n_deserved_certificate_students_count}}</h3>
						</div>
					</div> 
				</a>
			</div>
		@endcan
    </div>

    </div>

@endsection