@extends('layouts.admin')
<title>{{ trans('home.wad_requests') }}</title>
@section('content')
    <div class="container-fluid">

        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5">{{ trans('home.wad_requests') }}</h2>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('admin') }}">{{ trans('home.admin') }}</a></li>
                    <li class="breadcrumb-item active" aria-current="page">{{ trans('home.wad_requests') }}</li>
                </ol>
            </div>

            {{-- @can('wad_requests_operations')
                <div class="btn btn-list">
                    @can('wad_requests_accept_button')
                        <a id="btn_active_wad"><button class="btn ripple btn-dark"><i class="fas fa-eye"></i>
                                {{ trans('home.accept') }}</button>
                        </a>
                    @endcan
                    @can('wad_requests_delete_button')
                        <a class="mr-2" id="btn_delete"><button class="btn ripple btn-danger"><i class="fas fa-trash"></i>
                                {{ trans('home.delete') }}</button></a>
                    @endcan
                </div>
            @endcan --}}
        </div>
        <!-- End Page Header -->

        @if (session()->has('success'))
            <div class="alert alert-success">
                {{ session()->pull('success') }}
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        @endif

        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1">{{ trans('home.wad_requests') }}</h6>
                            <p class="text-muted card-sub-title">
                                {{ trans('home.table_contain_all_data_shortly_you_can_view_more_details') }}</p>
                        </div>
                        <div class="table-responsive">
                            
                            <table class="table" id="exportexample">
                                <thead>
                                    <tr>
                                        <th><input type="checkbox" name="checkbox" class="tableChecked" id="checkAll"/></th>
                                        <th>{{ trans('home.id') }}</th>
                                        <th class="wd-10p">{{ trans('home.name') }}</th>
                                        <th class="wd-10p">{{ trans('home.email') }}</th>
                                        <th class="wd-10p">{{ trans('home.phone') }}</th>
                                        <!--<th class="wd-10p">{{ trans('home.gender') }}</th>-->
                                        <!--<th class="wd-10p">{{ trans('home.level') }}</th>-->
                                        <!--<th class="wd-10p">{{ trans('home.area') }}</th>-->
                                        <th class="wd-100p">{{ trans('home.certificates') }}</th>
                                        <th class="wd-10p">{{ trans('home.seen') }}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($wad_requests as $wad_request)
                                    @php
                                        if(str_contains($wad_request->certificate , ',')) {
                                            $certificates = explode(',' , $wad_request->certificate);
                                        } else {
                                            $certificates = $wad_request->certificate;
                                        }
                                    @endphp
                                        <tr id="{{ $wad_request->id }}">
                                            <td> <input type="checkbox" name="checkbox" class="tableChecked" value="{{ $wad_request->id }}" /> </td>
                                            <td><a href="javascript::void(0)">{{ $wad_request->id }}</a>  </td>
                                            <td><a href="javascript::void(0)">{{ $wad_request->name }}</a>  </td>
                                            <td><a href="javascript::void(0)">{{ $wad_request->email }}</a>  </td>
                                            <td><a href="javascript::void(0)">{{ $wad_request->phone }}</a>  </td>
                                            <!--<td><a href="javascript::void(0)">{{ $wad_request->gender }}</a>  </td>-->
                                            <!--<td><a href="javascript::void(0)">{{ $wad_request->level }}</a>  </td>-->
                                            <!--<td><a href="javascript::void(0)">{{ $wad_request->area }}</a>  </td>-->
                                            <td><a href="javascript::void(0)">@if(is_array($certificates)) @foreach($certificates as $certificate)  {{ '- ' . $certificate }} <br> @endforeach @else {{ $certificates }}  @endif</a>  </td>
                                            <td><a  href="javascript::void(0)">{{ $wad_request->admin_seen==1? __('home.seen') : __('home.not_seen') }}</a> </td>
                                        </tr>
                                    @endforeach
                                </tbody>    
                            </table>
                           
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
    </div>
@endsection
@section('script')
<script>
    $(document).ready(function(){
        $('#btn_active_wad').click(function(){
            var id = [];
            $('.tableChecked:checked').each(function(i){
                id[i] = $(this).val();
            });
            
            if(id.length === 0) //tell you if the array is empty
            {
                alert("Please Select at least one checkbox");
            }
            else
            {
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });
                $.ajax({
                    url:"<?php echo url('admin/wads_requests_change_status')?>", 
                    method:'POST',
                    data:{id:id},
                    success:function(data)
                    {
                        // console.log(data);
                        location.reload();
                    }
                });
            }
        });
    });
</script>
    

@endsection